//                                               -*- C++ -*-
/**
 *  @file  AbdoRackwitzSpecificParameters.cxx
 *  @brief AbdoRackwitz specific parameters.
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: AbdoRackwitzSpecificParameters.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include <cstdlib>

#include "AbdoRackwitzSpecificParameters.hxx"
#include "ResourceMap.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      CLASSNAMEINIT(AbdoRackwitzSpecificParameters);

      static Base::Common::Factory<AbdoRackwitzSpecificParameters> RegisteredFactory("AbdoRackwitzSpecificParameters");

      typedef Common::ResourceMap ResourceMap;

      /* Multiplicative decrease of linear step */
      const NumericalScalar AbdoRackwitzSpecificParameters::DefaultTau    = ResourceMap::GetAsNumericalScalar( "AbdoRackwitz-DefaultTau" );
      /* Armijo factor */
      const NumericalScalar AbdoRackwitzSpecificParameters::DefaultOmega  = ResourceMap::GetAsNumericalScalar( "AbdoRackwitz-DefaultOmega" );
      /* Growing factor in penalization term */
      const NumericalScalar AbdoRackwitzSpecificParameters::DefaultSmooth = ResourceMap::GetAsNumericalScalar( "AbdoRackwitz-DefaultSmooth" );


      /* Default onstructor */
      AbdoRackwitzSpecificParameters::AbdoRackwitzSpecificParameters()
        : PersistentObject(),
          tau_(AbdoRackwitzSpecificParameters::DefaultTau),
          omega_(AbdoRackwitzSpecificParameters::DefaultOmega),
          smooth_(AbdoRackwitzSpecificParameters::DefaultSmooth)
      {
        // Nothing to do
      }



      AbdoRackwitzSpecificParameters::AbdoRackwitzSpecificParameters(const NumericalScalar tau,
                                                                     const NumericalScalar omega,
                                                                     const NumericalScalar smooth)
        : PersistentObject(),
          tau_(tau),
          omega_(omega),
          smooth_(smooth)
      {
        // Nothing to do
      }


      /* Virtual constructor */
      AbdoRackwitzSpecificParameters * AbdoRackwitzSpecificParameters::clone() const
      {
        return new AbdoRackwitzSpecificParameters(*this);
      }

      /* Tau accessor */
      NumericalScalar AbdoRackwitzSpecificParameters::getTau() const
      {
        return tau_;
      }

      /* Tau accessor */
      void AbdoRackwitzSpecificParameters::setTau(const NumericalScalar tau)
      {
        tau_ = tau;
      }

      /* Omega accessor */
      NumericalScalar AbdoRackwitzSpecificParameters::getOmega() const
      {
        return omega_;
      }

      /* Omega accessor */
      void AbdoRackwitzSpecificParameters::setOmega(const NumericalScalar omega)
      {
        omega_ = omega;
      }

      /* Smooth accessor */
      NumericalScalar AbdoRackwitzSpecificParameters::getSmooth() const
      {
        return smooth_;
      }

      /* Smooth accessor */
      void AbdoRackwitzSpecificParameters::setSmooth(const NumericalScalar smooth)
      {
        smooth_ = smooth;
      }

      /* String converter */
      String AbdoRackwitzSpecificParameters::__repr__() const
      {
        OSS oss;
        oss << "class=" << AbdoRackwitzSpecificParameters::GetClassName()
            << " tau=" << tau_
            << " omega=" << omega_
            << " smooth=" << smooth_;
        return oss;
      }

      /* Method save() stores the object through the StorageManager */
      void AbdoRackwitzSpecificParameters::save(StorageManager::Advocate & adv) const
      {
        Base::Common::PersistentObject::save(adv);
        adv.saveAttribute("tau_", tau_);
        adv.saveAttribute("omega_", omega_);
        adv.saveAttribute("smooth_", smooth_);
      }

      /* Method load() reloads the object from the StorageManager */
      void AbdoRackwitzSpecificParameters::load(StorageManager::Advocate & adv)
      {
        Base::Common::PersistentObject::load(adv);
        adv.loadAttribute("tau_", tau_);
        adv.loadAttribute("omega_", omega_);
        adv.loadAttribute("smooth_", smooth_);
      }

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */



