//                                               -*- C++ -*-
/**
 *  @file  NoNumericalMathHessianImplementation.hxx
 *  @brief Abstract top-level class for all numerical math hessian implementations
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: NoNumericalMathHessianImplementation.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_NONUMERICALMATHHESSIANIMPLEMENTATION_HXX
#define OPENTURNS_NONUMERICALMATHHESSIANIMPLEMENTATION_HXX

#include "NumericalMathHessianImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class NoNumericalMathHessianImplementation
       *
       * This class offers an interface for an real numerical mathematical hessian
       * implementations into the platform. It realizes the computation of the image vector
       * of a vector (aka NumericalPoint) through the hessian. The
       * hessian may be loaded in an external way through a wrapper.
       */
      class NoNumericalMathHessianImplementation
        : public NumericalMathHessianImplementation
      {
        CLASSNAME;
      public:

        typedef NumericalMathHessianImplementation::Description Description;
        typedef NumericalMathHessianImplementation::SymmetricTensor SymmetricTensor;
        typedef NumericalMathHessianImplementation::NumericalPoint NumericalPoint;
        typedef NumericalMathHessianImplementation::InvalidArgumentException InvalidArgumentException;
        typedef NumericalMathHessianImplementation::InternalException InternalException;

        /** Default constructor */
        NoNumericalMathHessianImplementation();

        /** Virtual constructor */
        virtual NoNumericalMathHessianImplementation * clone() const;

        /** Comparison operator */
        Bool operator ==(const NoNumericalMathHessianImplementation & other) const;

        /** String converter */
        virtual String __repr__() const;

        /** Test for actual implementation */
        virtual Bool isActualImplementation() const;



        /* Here is the interface that all derived class must implement */

        /** Hessian method */
        virtual SymmetricTensor hessian(const NumericalPoint & inP) const
          /* throw(InvalidArgumentException,InternalException) */;

        /** Accessor for input point dimension */
        virtual UnsignedLong getInputDimension() const
          /* throw(InternalException) */;

        /** Accessor for output point dimension */
        virtual UnsignedLong getOutputDimension() const
          /* throw(InternalException) */;

        /** Method save() stores the object through the StorageManager
         *  The inherited method is sufficient as we do not have any
         *  attribute
         */

        /** Method load() reloads the object from the StorageManager
         *  The inherited method is sufficient as we do not have any
         *  attribute
         */



      protected:

        /** The hessian that actually realizes assignment between objects */

      private:

      }; /* class NoNumericalMathHessianImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NONUMERICALMATHHESSIANIMPLEMENTATION_HXX */
