//                                               -*- C++ -*-
/**
 *  @file  NoNumericalMathHessianImplementation.cxx
 *  @brief Abstract top-level class for all numerical math hessian implementations
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: souchaud $
 *  @date:   $LastChangedDate: 2011-07-01 10:34:36 +0200 (Fri, 01 Jul 2011) $
 *  Id:      $Id: NoNumericalMathHessianImplementation.cxx 1981 2011-07-01 08:34:36Z souchaud $
 */
#include "NoNumericalMathHessianImplementation.hxx"
#include "PersistentObjectFactory.hxx"


namespace OpenTURNS {

  namespace Base {

    namespace Func {

      CLASSNAMEINIT(NoNumericalMathHessianImplementation);

      static Common::Factory<NoNumericalMathHessianImplementation> RegisteredFactory("NoNumericalMathHessianImplementation");

      /* Default constructor */
      NoNumericalMathHessianImplementation::NoNumericalMathHessianImplementation()
        : NumericalMathHessianImplementation()
      {
        // Nothing to do
      }

      /* Virtual constructor */
      NoNumericalMathHessianImplementation * NoNumericalMathHessianImplementation::clone() const
      {
        return new NoNumericalMathHessianImplementation(*this);
      }

      /* Comparison operator */
      Bool NoNumericalMathHessianImplementation::operator ==(const NoNumericalMathHessianImplementation & other) const
      {
        return true;
      }

      /* String converter */
      String NoNumericalMathHessianImplementation::__repr__() const {
        OSS oss;
        oss << "class=" << NoNumericalMathHessianImplementation::GetClassName()
            << " name=" << getName();
        return oss;
      }

      /* Test for actual implementation */
      Bool NoNumericalMathHessianImplementation::isActualImplementation() const
      {
        return false;
      }









      /* Here is the interface that all derived class must implement */

      /* Hessian method */
      NoNumericalMathHessianImplementation::SymmetricTensor NoNumericalMathHessianImplementation::hessian(const NumericalPoint & inP) const
      /* throw(InvalidArgumentException,InternalException) */
      {
        const UnsignedLong inputDimension(getInputDimension());
        if (inP.getDimension() != inputDimension) throw InvalidArgumentException(HERE) << "Error: the given point has an invalid dimension. Expect a dimension " << inputDimension << ", got " << inP.getDimension();
        ++callsNumber_;
        return SymmetricTensor();
      }

      /* Accessor for input point dimension */
      UnsignedLong NoNumericalMathHessianImplementation::getInputDimension() const
      /* throw(InternalException) */
      {
        return 0;
      }

      /* Accessor for output point dimension */
      UnsignedLong NoNumericalMathHessianImplementation::getOutputDimension() const
      /* throw(InternalException) */
      {
        return 0;
      }

    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
