//                                               -*- C++ -*-
/**
 *  @file  IdFactory.cxx
 *  @brief The class IdFactory builds unique Ids for all Objects
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: IdFactory.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include <cstdlib>
#include "IdFactory.hxx"
#include "OSS.hxx"
#include "OTthread.hxx"
#include "MutexLock.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      static pthread_once_t IdFactory_InstanceMutex_once = PTHREAD_ONCE_INIT;
      static AtomicInt IdFactory_NextId_;


      static void IdFactory_Initialization()
      {
        // Nothing to do
      }


      IdFactory_init::IdFactory_init()
      {
        int rc = pthread_once( &IdFactory_InstanceMutex_once, IdFactory_Initialization );
        if (rc != 0) { perror("IdFactory_init::IdFactory_init once Initialization failed"); exit(1); }
      }


      /* Default constructor */
      IdFactory::IdFactory()
      {
        // Nothing to do
      }


      /* Id accessor */
      Id IdFactory::BuildId()
      {
        return IdFactory_NextId_.fetchAndAdd( 1 );
      }



    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
