//                                               -*- C++ -*-
/**
 *  @file  ComparisonOperator.hxx
 *  @brief Abstract top-level class for all ComparisonOperator
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: ComparisonOperator.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_COMPARISONOPERATOR_HXX
#define OPENTURNS_COMPARISONOPERATOR_HXX

#include "TypedInterfaceObject.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Common {

      class ComparisonOperatorImplementation;


      /**
       * @class ComparisonOperator
       *
       * @brief The class describes the concept of a comparison operator.
       *
       * The implementation defined what comparison is actually performed.
       * @see ComparisonOperatorImplementation
       */
      class ComparisonOperator
        : public TypedInterfaceObject<ComparisonOperatorImplementation>
      {
        CLASSNAME;
      public:

        /** Default constructor */
        ComparisonOperator();

        /** Constructor from implementation */
        ComparisonOperator(const ComparisonOperatorImplementation & op);


        /**
         * Return true if comparison succeeds
         * @param a The left hand side of the expression
         * @param b The right hand side of the expression
         * @return True if comparison succeeds
         */
        Bool operator()(NumericalScalar a, NumericalScalar b) const;

        /** @copydoc operator()()
         * This method is an alias for ComparisonOperator::operator()(NumericalScalar a, NumericalScalar b).
         */
        Bool compare(NumericalScalar a, NumericalScalar b) const;


      }; /* class ComparisonOperator */


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COMPARISONOPERATOR_HXX */
