//                                               -*- C++ -*-
/**
 *  @file  StandardEvent.hxx
 *  @brief The class that implements an event based on a composite random vector whose
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: StandardEvent.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_STANDARDEVENT_HXX
#define OPENTURNS_STANDARDEVENT_HXX

#include "OTprivate.hxx"
#include "RandomVector.hxx"
#include "Event.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {


      /**
       * @class StandardEvent
       *
       * The class that implements an event based on a composite random vector whose
       * antecedent has a spherical distribution
       */
      class StandardEvent 
	: public Event
      {
	CLASSNAME;

      public:

	typedef Event::ComparisonOperator       ComparisonOperator;
	typedef Event::InvalidArgumentException InvalidArgumentException;

	/** Constructor from RandomVector */
	StandardEvent(const RandomVector & antecedent,
		      const ComparisonOperator & op,
		      const NumericalScalar threshold,
		      const String & name = OT::DefaultName)
	  /* throw (InvalidArgumentException) */;

	/** Constructor from Event */
	StandardEvent(const Event & event,
                      const String & name = OT::DefaultName)
	  /* throw (InvalidArgumentException) */;


      protected:

    
      private:

      }; /* class StandardEvent */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_STANDARDEVENT_HXX */
