//                                               -*- C++ -*-
/**
 *  @file  ConstantNumericalMathGradientImplementation.hxx
 *  @brief Class for a linear numerical math gradient impelmentation
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: ConstantNumericalMathGradientImplementation.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_CONSTANTNUMERICALMATHGRADIENTIMPLEMENTATION_HXX
#define OPENTURNS_CONSTANTNUMERICALMATHGRADIENTIMPLEMENTATION_HXX

#include "NumericalMathGradientImplementation.hxx"
#include "Exception.hxx"
#include "Matrix.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class ConstantNumericalMathGradientImplementation
       *
       * This class offers an interface for an real numerical mathematical gradient
       * implementations into the platform. It realizes the computation of the image matrix
       * of a vector (aka NumericalPoint) through the gradient. The
       * gradient may be loaded in an external way through a wrapper.
       */
      class ConstantNumericalMathGradientImplementation
	: public NumericalMathGradientImplementation
      {
	CLASSNAME;
      public:

	typedef NumericalMathGradientImplementation::NumericalPoint           NumericalPoint;
	typedef NumericalMathGradientImplementation::Matrix                   Matrix;
	typedef NumericalMathGradientImplementation::InvalidArgumentException InvalidArgumentException;
	typedef NumericalMathGradientImplementation::InternalException        InternalException;
	typedef NumericalMathGradientImplementation::StorageManager           StorageManager;
	typedef Common::InvalidDimensionException                             InvalidDimensionException;

	/** Default constructor */
	ConstantNumericalMathGradientImplementation();

	/** Parameter constructor */
	ConstantNumericalMathGradientImplementation(const Matrix & constant)
          /* throw(InvalidDimensionException) */;


	/** Virtual constructor */
	virtual ConstantNumericalMathGradientImplementation * clone() const;

	/** Comparison operator */
	Bool operator ==(const ConstantNumericalMathGradientImplementation & other) const;

	/** String converter */
	virtual String __repr__() const;

	/* Here is the interface that all derived class must implement */
	
	/** Gradient method */
	virtual Matrix gradient(const NumericalPoint & in) const
	  /* throw(InvalidArgumentException, InternalException) */;

	/** Accessor for input point dimension */
	virtual UnsignedLong getInputDimension() const
          /* throw(InternalException) */;

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputDimension() const
	  /* throw(InternalException) */;

	/** Accessor for the constant term */
	Matrix getConstant() const;

 	/** Method save() stores the object through the StorageManager */
	void save(StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(StorageManager::Advocate & adv);

      protected:

    
      private:
	Matrix constant_;
      }; /* class ConstantNumericalMathGradientImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_CONSTANTNUMERICALMATHGRADIENTIMPLEMENTATION_HXX */
