//                                               -*- C++ -*-
/**
 *  @file  AtomicFunctions.hxx
 *  @brief This file supplies some atomic functions to support multithreading
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-10 16:43:31 +0200 (Thu, 10 May 2007) $
 *  Id:      $Id: AtomicFunctions.hxx 434 2007-05-10 14:43:31Z dutka $
 */
#ifndef OPENTURNS_ATOMICFUNCTIONS_HXX
#define OPENTURNS_ATOMICFUNCTIONS_HXX

#include <cassert>
#include "OTprivate.hxx"

namespace OpenTURNS
{

  struct Atomic
  {


//#ifdef  __GNUC__
#if 0

    // Get *p value, increment it by d and return the old value
    static inline
    int ExchangeAndAdd( int * p, int d )
    {
      int result;

      assert(p && "Memory allocation error. Try to dereference a NULL pointer");

      __asm__ __volatile__
	(
	 "lock\n\t"
	 "xadd %1, %0"
	 : "=m" (*p), "=r" (result)
	 : "m"  (*p), "1"  (d)
	 : "memory", "cc"
	 );
      
      return result;
    }


    static inline
    void Increment( int * p )
    {
      assert(p && "Memory allocation error. Try to dereference a NULL pointer");

      __asm__
	(
	 "lock\n\t"
	 "incl %0"
	 : "=m" (*p)
	 : "m"  (*p)
	 : "cc"
	 );
    }

#else

    // Get *p value, increment it by d and return the old value
    static inline
    int ExchangeAndAdd( int * p, int d )
    {
      assert(p && "Memory allocation error. Try to dereference a NULL pointer");

      int result = *p;
      *p += d;
      return result;
    }


    static inline
    void Increment( int * p )
    {
      assert(p && "Memory allocation error. Try to dereference a NULL pointer");

      ++*p;
    }

#endif

  }; /* end struct Atomic */

} /* namespace OpenTURNS */

#endif /* OPENTURNS_ATOMICFUNCTIONS_HXX */
