Name:		opensaml
Summary:	Open source SAML library
Version:	2.0
Release:	6
Group:		System Environment/Libraries
Vendor:		Internet2
License:	Apache 2.0
URL:		http://www.opensaml.org/
Source0:	%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-root
BuildRequires:	xerces%{?xercesver}-c-devel >= 2.8.0
BuildRequires:  xml-security-c-devel >= 1.4.0
BuildRequires:	xmltooling-devel
%{?_with_log4cpp:BuildRequires: log4cpp-devel >= 1.0}
%{!?_with_log4cpp:BuildRequires: log4shib-devel}

%description
OpenSAML is an open source implementation of the OASIS Security Assertion
Markup Language Specification. It contains a set of open source C++ classes
that support the SAML 1.0, 1.1, and 2.0 specifications.

This package contains the saml runtime library.

%package devel
Summary: OpenSAML development Headers
Group: Development/Libraries
Requires: %{name} = %{version}

%description devel
OpenSAML is an open source implementation of the OASIS Security Assertion
Markup Language Specification. It contains a set of open source C++ classes
that support the SAML 1.0, 1.1, and 2.0 specifications.

This package contains the headers and other necessary files to build
applications or libraries that use or extend the saml library.

%package docs
Summary: OpenSAML API Documentation
Group: Development/Libraries
Requires: %{name} = %{version}

%description docs
OpenSAML Library API documentation generated by doxygen.

%prep
%setup -q

%build
%configure %{?saml_options}
%{__make}

%install
[ "$RPM_BUILD_ROOT" != "/" ] && %{__rm} -rf $RPM_BUILD_ROOT
%{__make} install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT/%{_bindir} -type f |
  %{__sed} -e "s|$RPM_BUILD_ROOT||" | sort > rpm.binlist

%check || :
%{__make} check

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && %{__rm} -rf $RPM_BUILD_ROOT

%ifnos solaris2.8 solaris2.9 solaris2.10 
%post -p /sbin/ldconfig
%endif

%ifnos solaris2.8 solaris2.9 solaris2.10 
%postun -p /sbin/ldconfig
%endif

%files -f rpm.binlist
%defattr(-,root,root,-)
%{_libdir}/libsaml.so.*
%dir %{_datadir}/xml/%{name}
%{_datadir}/xml/%{name}
%docdir %{_datadir}/doc/%{name}
%{_datadir}/doc/%{name}/LICENSE.txt
%{_datadir}/doc/%{name}/NOTICE.txt
%{_datadir}/doc/%{name}/LOG4CPP.LICENSE

%files devel
%defattr(-,root,root,-)
%{_includedir}
%{_libdir}/libsaml.so

%files docs
%defattr(644,root,root,755)
%doc %{_datadir}/doc/%{name}/api

%changelog
* Mon Mar 17 2008  Scott Cantor  <cantor.2@osu.edu>  - 2.0-6
- Official release.

* Fri Jan 18 2008  Scott Cantor  <cantor.2@osu.edu>  - 2.0-5
- Release candidate 1.

* Thu Nov 08 2007 Scott Cantor  <cantor.2@osu.edu>  - 2.0-4
- Second public beta.

* Thu Aug 16 2007 Scott Cantor  <cantor.2@osu.edu>  - 2.0-3
- First public beta.

* Fri Jul 13 2007  Scott Cantor  <cantor.2@osu.edu>  - 2.0-2
- Second alpha.

* Sun Apr 16 2007  Scott Cantor  <cantor.2@osu.edu>  - 2.0-1
- First SPEC file for 2.0.
