'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_xml_scenario.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsi $ $Date: 2006/11/03 09:50:00 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Check content.xml for correct scenario attributes
'*
'*************************************************************************************************
'*
' #1 subScenarioAttributes
' #1 tScenarioAttributes
' #1 subCreateScenario
' #1 subCheckScenarioInContentXML
'*
'\*************************************************************************************************
sub subScenarioAttributes
  printLog Chr(13) + "---------  scenario attributes  ----------"

     call tScenarioAttributes

end sub

'************************************************************
testcase tScenarioAttributes
'///<u><b>Check correct scenario attributes</b></u>///

dim iIndex as INTEGER
    
dim sExtension
    sExtension = ".ods"

dim sOutputFile as STRING
    sOutputFile = ( gOfficePath & ConvertPath( "user\work\scenarioAttributes" ) & sExtension )
    
dim sUnpackedStorageDir as STRING
    sUnpackedStorageDir = ( gOfficePath & ConvertPath( "user\work\scenarioAttributes" ))
    if (dir ( sUnpackedStorageDir ) <> "" ) then
        kill ( sUnpackedStorageDir )
    endif
    
dim sContentXML as STRING
    sContentXML = ( gOfficePath & ConvertPath( "user\work\scenarioAttributes" ) & ConvertPath( "\content.xml" ))
    
'///<ul>
'///<li>Open test document</li>///
    Call hNewDocument
    sleep(2)
    '///<li>Assign specific names for tables to avoid language dependencies</li>///
    for iIndex = 1 to 3
        FormatSheetRename
        Kontext "TabelleUmbenennen"
        select case iIndex
               case 1 : Tabellenname.SetText "Ten"
               case 2 : Tabellenname.SetText "Moves"
               case 3 : Tabellenname.SetText "Ahead"
        end select
        TabelleUmbenennen.OK
        sleep(1)
     
        EditSheetSelect
        Kontext "SelectSheets"
        if iIndex = 3 then
            SheetSelectionBox.Select "Ten"
        else
            SheetSelectionBox.Select ( iIndex + 1 )
        endif
        SelectSheets.OK
        sleep(1)
    next iIndex
    '///<li>Activate formula bar if invisible</li>///
    Kontext "RechenleisteCalc"
    if not RechenleisteCalc.isvisible then
        ViewToolbarsFormulaBar
    end if
    sleep(1)
    '///<li>Create simple data area</li>///
    Kontext "RechenleisteCalc"
    Bereich.TypeKeys "<MOD1 A>"
    Bereich.TypeKeys "C3"
    sleep(1)
    Bereich.TypeKeys "<RETURN>"
    sleep(1)
    Kontext "DocumentCalc"
    DocumentCalc.typekeys "1<RETURN>2<RETURN>3<RETURN>"
    '///<li>Select this area</li>///
    Kontext "RechenleisteCalc"
    Bereich.TypeKeys "<MOD1 A>"
    Bereich.TypeKeys "C3:C5"
    sleep(1)
    Bereich.TypeKeys "<RETURN>"
    sleep(1)
    '///<li>Create a scenario on this selection</li>///
    subCreateScenario ( "Scenario_XML_Test" , "Created by Peter Junge" , 1 , 0 , 0 , 0 , 0 )
    sleep(1)
    '///<li>Create a another scenario on this selection</li>///
    subCreateScenario ( "AnotherScenario" , "Random Comment" , 13 , 1 , 1 , 1 , 1 )
    sleep(1)
    '///<li>Select sheet "Moves"</li>///
    EditSheetSelect
    Kontext "SelectSheets"
    SheetSelectionBox.Select "Moves"
    SelectSheets.OK
    sleep(1)
    '///<li>Create simple data area</li>///
    Kontext "RechenleisteCalc"
    Bereich.TypeKeys "<MOD1 A>"
    Bereich.TypeKeys "d5"
    sleep(1)
    Bereich.TypeKeys "<RETURN>"
    sleep(1)
    Kontext "DocumentCalc"
    DocumentCalc.typekeys "1<RETURN>2<RETURN>3<RETURN>"
    '///<li>Select this area</li>///
    Kontext "RechenleisteCalc"
    Bereich.TypeKeys "<MOD1 A>"
    Bereich.TypeKeys "d5:d7"
    sleep(1)
    Bereich.TypeKeys "<RETURN>"
    sleep(1)
    '///<li>Create a scenario on this selection</li>///
    subCreateScenario ( "標準" , "기본값" , 9 , 1 , 1 , 0 , 0 )
    sleep(1)
    '///<li>Create a another scenario on this selection</li>///
    subCreateScenario ( "1标准9" , "2預設0" , 16 , 0 , 0 , 1 , 1 )
    sleep(1)
    
    '///<li>Save in current default format</li>///
    if hSpeichernUnterMitFilterKill ( sOutputFile , sFileFormat ) = FALSE then
       warnlog "Saving " & sOutputFile & " failed! -> Exiting test!"
       call hCloseDocument
    else
       '///<li>... and close</li>///
       call hCloseDocument
       sleep(3)

       '///<li>Unpack storage to obtain the XML files</li>///
       printlog "Unpack storage of test document."
       UnpackStorage( sOutputFile , sUnpackedStorageDir )
       printlog "Read the test documents DOM."
       '///<li>Read DOM of content.xml</li>///
       SAXReadFile( sContentXML )
       sleep(2)

       '///<li>Set the DOM pointer on element 'office:spreadsheet'</li>///
       printlog "Set the DOM pointer on element 'office:spreadsheet'"
       printlog "|-/"
       SAXSeekElement( "/" )
       printlog "  |-office:document-content"
       SAXSeekElement( "office:document-content" )
       printlog "    |-office:body"
       SAXSeekElement( "office:body" )
       printlog "      |-office:spreadsheet"
       SAXSeekElement( "office:spreadsheet" )
       '///<li>For all tables check if they are scenarios</li>///
       '///<li>For those tables which are scenarios check correct attributes</li>///
       for iIndex = 1 to 7
           printlog "        |-table:table"
           SAXSeekElement( "table:table" , iIndex )
           select case iIndex
                  case 1 : subCheckScenarioInContentXML ( "Ten" , FALSE )
                  case 2 : subCheckScenarioInContentXML ( _
                           "Scenario_XML_Test" , TRUE , TRUE , "#000000" , TRUE , "false" , FALSE , "false" , _
                           "Scenario_XML_Test.C3:Scenario_XML_Test.C5" , "Created by Peter Junge" )
                  case 3 : subCheckScenarioInContentXML ( _
                           "AnotherScenario" , TRUE , FALSE , "#ff0000" , FALSE , "false" , TRUE , "true" , _
                           "AnotherScenario.C3:AnotherScenario.C5" , "Random Comment" )
                  case 4 : subCheckScenarioInContentXML ( "Moves" , FALSE )
                  case 5 : subCheckScenarioInContentXML ( _
                           "標準" , TRUE , FALSE , "#c0c0c0" , FALSE , "false" , FALSE , "false" , _
                           "標準.D5:標準.D7" , "기본값" )
                  case 6 : subCheckScenarioInContentXML ( _
                           "1标准9" , TRUE , TRUE , "#ffffff" , TRUE , "false" , TRUE , "true" , _
                           "1标准9.D5:1标准9.D7" , "2預設0" )
                  case 7 : subCheckScenarioInContentXML ( "Ahead" , FALSE )
           end select

           SAXSeekElement( 0 )
       next iIndex
       '///<li>Check if too much sheets exist</li>///
       try 
           SAXSeekElement( "table:table" , 8 )
           warnlog "OOPS, it's expected to have only seven sheet but we got eight or more -> Check this out!"
           SAXSeekElement( 0 )
       catch
           printlog "OK, the document has seven sheets"
       endcatch
    endif
    SAXRelease
'///</ul>
endcase
'
'---------------------------------------------------------------------------
'
sub subCreateScenario ( sScenarioName as STRING, _
                        sComment as STRING, _
                        iColorIndex as INTEGER, _
                        bDisplayBorder as BOOLEAN, _
                        bCopyBack as BOOLEAN, _
                        bCopyEntireSheet as BOOLEAN, _
                        bPreventChanges as BOOLEAN )
'///<u><b>Create scenario with options</b></u>///
'///<ul>
        '///<li>Invoke tools::scenarios...</li>///
        ToolsScenarios
        Kontext "SzenarioAnlegen"
        '///<li>Set options as requested through arguments</li>///
        SzenarioName.SetText ( sScenarioName )
        Kommentar.SetText ( sComment )
        Rahmenfarbe.Select ( iColorIndex )

        if bDisplayBorder then
            RahmenAnzeigen.Check
        else
            RahmenAnzeigen.UnCheck
        endif
        if bCopyBack then
            Zurueckkopieren.Check
        else
            Zurueckkopieren.UnCheck
        endif
        if bCopyEntireSheet then
            GanzeTabelle.Check
        else
            GanzeTabelle.UnCheck
        endif
        if bPreventChanges then
            PreventChanges.Check
        else
            PreventChanges.UnCheck
        endif
        '///<li>Commit dialog</li>///        
        SzenarioAnlegen.OK
        sleep(1)
'///</ul>	
end sub
'
'---------------------------------------------------------------------------
'
sub subCheckScenarioInContentXML ( sTableName as STRING , _
                                   bTableShouldBeScenario as BOOLEAN , _
                                   optional bCheckDisplayBorder as BOOLEAN , _
                                   optional sBorderColor as STRING , _
                                   optional bCheckCopyBack as BOOLEAN , _
                                   optional sCopyStyles as STRING , _
                                   optional bCheckProtected as BOOLEAN , _
                                   optional sIsActive as STRING , _
                                   optional sScenarioRanges as STRING , _
                                   optional sComment as STRING)
                                   
'///<u><b>Check attibutes for scenarios in 'content.xml'</b></u>///
dim bTableIsScenario as BOOLEAN
    bTableIsScenario = FALSE
'///<ul>
    '///<li>Check correct table name</li>///                           
    if SAXGetAttributeValue( "table:name" ) = sTableName then
        printlog "Table name is as expected"
    else
        warnlog "Table name is " & SAXGetAttributeValue( "table:name" ) & " instead of " & sTableName
    endif
    '///<li>Find out if current table is a scenario</li>///
    try 
        SAXSeekElement( "table:scenario")
        bTableIsScenario = TRUE
        if bTableShouldBeScenario then
            printlog "OK, this table is a scenario!"
        else
            warnlog "OOPS, this table shouldn't be a scenario -> Check this out!"
        endif
    catch
        if bTableShouldBeScenario then
            warnlog "OOPS, this table should be a scenario but it isn't -> Check this out!"
        else
            printlog "Right, this table isn't a scenario"
        endif
    endcatch
    '///<li>Check scenario attributes</li>///
    if bTableShouldBeScenario AND bTableIsScenario then
        if bCheckDisplayBorder then 
            if SAXGetAttributeValue ( "table:display-border" ) = "false" then
                printlog "OK, attribute 'table:display-border' has expected value: 'false'"
            else
                warnlog "OOPS, attribute 'table:display-border' has unexpected value: " & SAXGetAttributeValue( "table:display-border" )
            endif
        else 
            if SAXGetAttributeValue ( "table:display-border" ) <> "" then
                warnlog "OOPS, attribute 'table:display-border' shouldn't exist here"
            endif
        endif

        if SAXGetAttributeValue( "table:border-color" ) = sBorderColor then
            printlog "OK, attribute 'table:border-color' has expected value"
        else
            warnlog "OOPS, attribute 'table:border-color' has unexpected value: " & SAXGetAttributeValue( "table:border-color" )
        endif
        
        if bCheckCopyBack then
            if SAXGetAttributeValue( "table:copy-back" ) = "false" then
                printlog "OK, attribute 'table:copy-back' has expected value: 'false'"
            else
                warnlog "OOPS, attribute 'table:copy-back' has unexpected value: " & SAXGetAttributeValue( "table:copy-back" )
            endif
        else 
            if SAXGetAttributeValue ( "table:copy-back" ) <> "" then
                warnlog "OOPS, attribute 'table:copy-back' shouldn't exist here"
            endif
        endif
        
        if SAXGetAttributeValue( "table:copy-styles" ) = sCopyStyles then
            printlog "OK, attribute 'table:copy-styles' has expected value"
        else
            warnlog "OOPS, attribute 'table:copy-styles' has unexpected value: " & SAXGetAttributeValue( "table:copy-styles" )
        endif
        
        if bCheckProtected then
            if SAXGetAttributeValue( "table:protected" ) = "true" then
                printlog "OK, attribute 'table:protected' has expected value: 'true'"
            else
                warnlog "OOPS, attribute 'table:protected' has unexpected value: " & SAXGetAttributeValue( "table:protected" )
            endif
        else 
            if SAXGetAttributeValue ( "table:protected" ) <> "" then
                warnlog "OOPS, attribute 'table:protected' shouldn't exist here"
            endif
        endif

        if SAXGetAttributeValue( "table:is-active" ) = sIsActive then
            printlog "OK, attribute 'table:is-active' has expected value"
        else
            warnlog "OOPS, attribute 'table:is-active' has unexpected value: " & SAXGetAttributeValue( "table:is-active" )
        endif

        if SAXGetAttributeValue( "table:scenario-ranges" ) = sScenarioRanges then
            printlog "OK, attribute 'table:scenario-ranges' has expected value"
        else
            warnlog "OOPS, attribute 'table:scenario-ranges' has unexpected value: " & SAXGetAttributeValue( "table:scenario-ranges" )
            qaErrorLog "Expected: " & sScenarioRanges
        endif

        if SAXGetAttributeValue( "table:comment" ) = sComment then
            printlog "OK, attribute 'table:comment' has expected value"
        else
            warnlog "OOPS, attribute 'table:comment' has unexpected value: " & SAXGetAttributeValue( "table:comment" )
            qaErrorLog "Expected: " & sComment
        endif
    else
        printlog "Checking scenario details was skipped!"
    endif
    
    if bTableIsScenario then
        SAXSeekElement( 0 )
    endif
'///</ul>
end sub


