'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_004_.inc,v $
'*
'*  $Revision: 1.30.2.1 $
'*
'*  last change: $Author: hde $ $Date: 2008/02/21 08:45:22 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :  Testcases with connection to the Insert-menu. 
'*
'\***********************************************************************

sub w_004_
    printLog Chr(13) + "---------  Insert Menu ( w_004_ ) ----------"

    Call tInsertManualBreak
    Call tInsertFields
    Call tInsertFieldsOther
    Call tInsertSpecialCharacter

    Call tInsertSection
    Call tInsertHyperlink

    Call tInsertFootnote
    Call tInsertCaption
    Call tInsertBookmark
    Call tInsertCrossReference
    Call tInsertNote
    Call tInsertScript
    Call tInsertIndexesEntry
    Call tInsertIndexesIndex
    Call tInsertIndexesBibliographyEntry

    Call tInsertEnvelope

    Call tInsertFrame
    Call tInsertTable
    Call tInsertHorizontalLine
    Call tInsertGraphicsFromFile
    Call tInsertAllGraphicsFromFile

    Call tInsertObjectOLEObject
    Call tInsertObjectPlugIn
    Call tInsertObjectSound
    Call tInsertObjectVideo
    Call tInsertObjectFormula
    Call tInsertObjectChart
    Call tInsertFile
end sub

'-----------------------------------------------------------

testcase tInsertManualBreak
    PrintLog "- Insert / Manual Break"

    Call hNewDocument
    '/// Open new document ///

    InsertManualBreak
    '/// Insert / Manual break ///

    Kontext "UmbruchEinfuegen"
    '/// Close 'Insert break' dialog with cancel ///
    Call DialogTest ( UmbruchEinfuegen )
    UmbruchEinfuegen.Cancel

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertFields
    PrintLog "- Insert / Fields"

    Call hNewDocument
    '/// Open new document ///

    try
        printlog "Insert / Fields / Date"
        InsertFieldsDate
    catch
       Warnlog "Unable to execute: Insert / Fields / Date "
    endcatch
    '/// Insert / Fields / Date ///
    Call wDokSchreiben (" <Return>")
    try
        printlog "Insert / Fields / Time"
        InsertFieldsTime
    catch
       Warnlog "Unable to execute: Insert / Fields / Time"
    endcatch
    '/// Insert / Fields / Time ///
    Call wDokSchreiben (" <Return>")
    try
        printlog "Insert / Fields / Page Number"
        InsertFieldsPageNumbers
    catch
       Warnlog "Unable to execute: Insert / Fields / Page numbers"
    endcatch
    '/// Insert / Fields / Page numbers ///
    Call wDokSchreiben (" <Return>")
    try
        printlog "Insert / Fields / Page Count"
        InsertFieldsPageCount
    catch
       Warnlog "Unable to execute: Insert / Fields / Page Count"
    endcatch
    '/// Insert / Fields / Page count ///
    Call wDokSchreiben (" <Return>")
    try
        printlog "Insert / Fields / Title"
        InsertFieldsTitle
    catch
       Warnlog "Unable to execute: Insert / Fields / Title"
    endcatch
    '/// Insert / Fields / Title ///
    Call wDokSchreiben (" <Return>")
    try
        printlog "Insert / Fields / Author"
        InsertFieldsAuthor
    catch
       Warnlog "Unable to execute: Insert / Fields / Author"
    endcatch
    '/// Insert / Fields / Author ///
    if gApplication <> "HTMLDOKUMENT" then
        try
            printlog "Insert / Fields / Subject"
            InsertFieldsSubject
        catch
            Warnlog "Unable to execute: Insert / Fields / Subject"
        endcatch
        '/// If document not HTML then  'Insert / Fields / Subject ///
        Call wDokSchreiben (" <Return>")
        '/// Press key 'enter' ///
    end if

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertFieldsOther
    Dim i, j as integer
    printlog "- Insert / Fields / Other"

    Call hNewDocument
    '/// Open new document ///

    InsertFieldsOther
    '/// Insert / Fields / Other ///
    Kontext
    '/// In dialog step through all tabpages ///
    Active.SetPage TabDokumentFeldbefehle
    Kontext "TabDokumentFeldbefehle"
    Call Dialogtest ( TabDokumentFeldbefehle )

    Kontext
    Active.SetPage TabDokumentinfoFeldbefehle
    Kontext "TabDokumentinfoFeldbefehle"
    Call Dialogtest ( TabDokumentinfoFeldbefehle )

    Kontext
    Active.SetPage TabVariablen
    Kontext "TabVariablen"
    Call Dialogtest ( TabVariablen )

    if gApplication <> "HTMLDOKUMENT" then
        Kontext
        Active.SetPage TabReferenzen
        Kontext "TabReferenzen"
        Call Dialogtest ( TabReferenzen )

        Kontext
        Active.SetPage TabFunktionen
        Kontext "TabFunktionen"
        Call Dialogtest ( TabFunktionen )
        for i=1 to Feldtyp.GetItemCount
            Feldtyp.Select i            
			if MakroButton.IsEnabled then
                MakroButton.Click
                ' if no JRE is installed a messagebox appears
                Do
                    j = j + 1
                    Kontext "Active"
                    if Active.Exists then
                        if Active.GetRT = 304 then
                            if j = 1 then Warnlog Active.Gettext    
                            Active.Ok
                        else
                            exit do
                        end if                    
                    else
                        exit do
                    end if
                Loop                                                              
                Sleep 5
                Kontext "ScriptSelector"
                Sleep 1
                ScriptSelector.Close
                Kontext "TabFunktionen"
                i=100
            end if
        next i

        Kontext
        Active.SetPage TabDatenbank
        Kontext "TabDatenbank"
        Call Dialogtest ( TabDatenbank )

        TabDatenbank.Close
    else
        TabVariablen.Close
    end if
    '/// Close dialog ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tInsertSpecialCharacter
    PrintLog "- Insert / Special Character"

    Call hNewDocument
    '/// Open new document ///

    InsertSpecialCharacterWriter
    '/// Insert / Special Character ///

    Kontext "Sonderzeichen"
    Call DialogTest (Sonderzeichen)
    Sonderzeichen.Cancel

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertSection
    PrintLog "- Insert / Section"

    Call hNewDocument
    '/// Open new document ///

    '/// Insert / Section ///
    InsertSection
    Kontext

    '///  In dialog step through all tabpages ///
    printlog "-  Tabpage Section"
    Active.Setpage TabBereiche
    Kontext "TabBereiche"
    Call DialogTest (TabBereiche)
    Verknuepfung.Check
    if gUseSysDlg = False then
        Auswaehlen.Click
        Kontext "OeffnenDlg"
        OeffnenDlg.Cancel
    end if
    Wait 500
    Kontext
    printlog "-  Tabpage Columns"
    Active.Setpage TabSpalten
    Kontext "TabSpalten"
    Call DialogTest (TabSpalten)

    Kontext
    printlog "-  Tabpage Background"
    Active.Setpage TabHintergrund
    Kontext "TabHintergrund"
    Call DialogTest (TabHintergrund)

    if gApplication <> "HTMLDOKUMENT" then
        printlog "Tabpage Indents"
        Kontext
        Active.Setpage TabSectionIndent
        Kontext "TabSectionIndent"
        Call DialogTest (TabSectionIndent)

        printlog "-  Tabpage Footnotes/Endnotes"
        Kontext
        Active.Setpage TabFussEndnoten
        Kontext "TabFussEndnoten"
        Call DialogTest (TabFussEndnoten)
        TabFussEndnoten.Cancel
    else
        TabHintergrund.Cancel
    end if
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tInsertHyperlink
    Dim i as integer
    PrintLog "- Insert / Hyperlink"

    Call hNewDocument
    '/// Open new document ///

    printlog "-  Internet"
    '/// Insert / Hyperlink ///
    InsertHyperlink
    '///  In 'Hyperlink' dialog step through all pages ///
    Call wEinfuegenHyperlink(1)
    Call DialogTest ( TabHyperlinkInternet )

    Kontext "Hyperlink"
    printlog "-  Mail & News"
    Call wEinfuegenHyperlink(2)
    wait 500
    Call DialogTest ( TabHyperlinkMailUndNews )

    Kontext "Hyperlink"
    printlog "-  Document"
    Call wEinfuegenHyperlink(3)
    wait 500
    Call DialogTest ( TabHyperlinkDokument )
    if gUseSysDlg = False then
        DateiOeffnen.Click
        Sleep 1
        Kontext "OeffnenDlg"
        OeffnenDlg.Cancel
        Sleep 1
    end if

    Kontext "Hyperlink"
    printlog "-  New Document"
    Call wEinfuegenHyperlink(4)
    wait 500
    Call DialogTest ( TabHyperlinkNeuesDokument )
    if gUseSysDlg = False then
        Pfad.Click
        Sleep 1
        Kontext "OeffnenDlg"
        OeffnenDlg.Cancel
    end if

    Kontext "TabHyperlinkNeuesDokument"
    TabHyperlinkNeuesDokument.Cancel
    '/// Close 'Hyperlink' dialog ///

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertFootnote
    PrintLog "- Insert / Footnote"

    Call hNewDocument
    '/// Open new document ///

    InsertFootnote
    '/// Insert / Footnote ///
    Kontext "FussnoteEinfuegen"
    Call DialogTest (FussnoteEinfuegen)
    Durchsuchen.Click
    '/// In 'Insert / Footnote' dialog click on browse button ///

    Kontext "Sonderzeichen"
    '/// Close 'Special Character' dialog ///
    Sonderzeichen.Cancel

    Kontext "FussnoteEinfuegen"
    FussnoteEinfuegen.Cancel
    '/// Close 'Insert Footnote' dialog ///

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertCaption
    PrintLog "- Insert / Caption"

    Call hNewDocument
    '/// Open new document ///


    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Insert graphic '..\writer\input\grafik\jolink.jpg ///
    try
        InsertCaption
        '/// Insert / Caption ///
        Kontext "Beschriftung"
        Call DialogTest ( Beschriftung )
        Sleep 1
        WeitereOptionen.Click
        '/// In 'Caption' dialog click 'Options' ///
        Kontext "NummernkreisOptionen"
        Call DialogTest ( NummernkreisOptionen )
        NummernkreisOptionen.Cancel
        '/// Close 'Number Range Options' dialog ///
        Sleep 1
        Kontext "Beschriftung"
        Beschriftung.Cancel
        '/// Close 'Caption' dialog ///
        Sleep 2
    catch
        Warnlog "Insert / Caption is disabled!"
    endcatch

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertBookmark
    PrintLog "- Insert / Bookmark"

    Call hNewDocument
    '/// Open new document ///

    InsertBookmark
    '/// Insert / Bookmark ///
    Kontext "TextmarkeEinfuegen"
    Call DialogTest (TextmarkeEinfuegen)
    wait 500
    '/// Close 'Insert Bookmark' dialog ///
    TextmarkeEinfuegen.Cancel

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertNote
    PrintLog "- Insert / Note"

    Call hNewDocument
    '/// Open new document ///

    InsertNoteWriter
    '/// Insert / Note ///
    Kontext "NotizEinfuegen"
    Call DialogTest (NotizEinfuegen)
    '/// Close 'Insert Note' dialog ///
    NotizEinfuegen.Cancel

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertCrossReference
    Dim i as integer, j as integer
    printlog "- Insert / Reference Field"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    end if
    Call hNewDocument
    '/// Open new document ///

    InsertReferenceField
    '/// Insert / Cross reference ///

    Kontext "TabReferenzen"
    if NOT TabReferenzen.IsVisible then Warnlog "Reference Tabpage isn't default!"
    '/// Step through all tabpages ///

    Kontext
    Active.SetPage TabFunktionen
    Kontext "TabFunktionen"
    for i=1 to Feldtyp.GetItemCount
        Feldtyp.Select i
        if MakroButton.IsEnabled then            
            MakroButton.Click
            ' if no JRE is installed a messagebox appears
            j = 0
            Do
                j = j + 1
                Kontext "Active"
                if Active.Exists then
                    if Active.GetRT = 304 then
                        if j = 1 then Warnlog Active.Gettext    
                        Active.Ok
                    else
                        exit do
                    end if                    
                else
                    exit do
                end if
            Loop
            Kontext "ScriptSelector"
            Sleep 1
            ScriptSelector.Close
            Kontext "TabFunktionen"
            i=100
        end if
    next i

    Kontext
    Active.SetPage TabDokumentinfoFeldbefehle
    Kontext "TabDokumentinfoFeldbefehle"

    Kontext
    Active.SetPage TabVariablen
    Kontext "TabVariablen"

    Kontext
    Active.SetPage TabDatenbank
    Kontext "TabDatenbank"

    Kontext
    Active.SetPage TabDokumentFeldbefehle
    Kontext "TabDokumentFeldbefehle"
    '/// Close dialog ///

    TabDokumentFeldbefehle.Close
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tInsertScript
    PrintLog "- Insert / Script"

    Call hNewDocument
    '/// Open new document ///

    InsertScript
    '/// Insert / Script ///
    Kontext "ScriptEinfuegen"
    Call DialogTest (ScriptEinfuegen)
    wait 500
    ScriptEinfuegen.Cancel

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertIndexesEntry
    PrintLog "- Insert / Indexes / Entry"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    end if
    Call hNewDocument
    '/// Open new document ///

    InsertIndexesEntry
    '/// Insert / Indexes and Tables / Entry ///
    Kontext "VerzeichniseintragEinfuegen"
    Call DialogTest (VerzeichniseintragEinfuegen)
    EintragNeu.Click
    '/// Click 'Insert' ///
    Kontext "BenutzerverzeichnisDefinieren"
    Call DialogTest (BenutzerverzeichnisDefinieren)
    BenutzerverzeichnisDefinieren.Cancel
    '/// Close dialog 'Insert Index Entry' ///
    Kontext "VerzeichniseintragEinfuegen"
    EinfuegenSchliessen.Click

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertIndexesIndex
    Dim i as integer
    Printlog "- Insert / Indexes / Index"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    end if
    Call hNewDocument
    '/// Open new document ///

    wait 500
    InsertIndexes
    '/// Insert / Indexes and Tables / Indexes and Tables ///
    Kontext "Active"
    Sleep 5
    if Active.Exists then
        if Active.GetRT = 304 then
            Warnlog Active.Gettext
            Active.Ok
        end if
    end if
    Sleep 2
    Kontext
    Active.Setpage TabVerzeichnisseVerzeichnis
    Kontext "TabVerzeichnisseVerzeichnis"
    '/// Step through all Tabpages ///

    printlog "-  TabPage Indexes"
    For i= 1 to VerzeichnisTyp.GetItemCount
        Sleep 1
        if i = 2 then printlog "Alphabetical index see bug #i33671 (ok in m54)"
		VerzeichnisTyp.Select i
        printlog "- " + VerzeichnisTyp.GetSelText
        Call DialogTest (TabVerzeichnisseVerzeichnis)
        printlog "-  Entry's to " + VerzeichnisTyp.GetSelText

        if i = 1 then    ' Inhaltsverzeichnis
            ErzeugenAusGliederung.Check
            Gliederung.Click
            Sleep 2
            Kontext
            Active.Setpage TabNumerierungKapitelnumerierung
            Kontext "TabNumerierungKapitelnumerierung"
            if Not TabNumerierungKapitelnumerierung.Exists then
                Warnlog "Outline couldn't be created!"
            else
                TabNumerierungKapitelnumerierung.Cancel
            end if
            Kontext "TabVerzeichnisseVerzeichnis"
            ErzeugenAusVorlagen.Check
            WelcheVorlage.Click
            Sleep 2

            Kontext "VorlageZuweisen"
            if VorlageZuweisen.Exists then
                VorlageZuweisen.Cancel
            else
                Warnlog "Dialog to create from styles not up!"
            end if
        end if

        if i = 2 then
            if gUseSysDlg = False then
                Konkordanzdatei.Check
                Kontext "KonkordanzdateiOeffnen"
                if KonkordanzdateiOeffnen.Exists then
                    KonkordanzdateiOeffnen.Cancel
                    Warnlog "Open-Dialog comes up at checking the checkbox!"
                end if
                Kontext "TabVerzeichnisseVerzeichnis"
                if KonkordanzAuswahl.IsEnabled then
                    KonkordanzAuswahl.Click
                    wait 500
                    Call hMenuSelectNr ( 1 )
                    Kontext "KonkordanzdateiOeffnen"
                    if KonkordanzdateiOeffnen.Exists then
                        KonkordanzdateiOeffnen.Cancel
                    else
                        Warnlog "No Open-Dialog selecting Concordance-File->Open!"
                    end if
                    Sleep 2
                    Kontext "TabVerzeichnisseVerzeichnis"
                    KonkordanzAuswahl.Click
                    wait 500
                    Call hMenuSelectNr ( 2 )
                    Kontext "SpeichernDlg"
                    if SpeichernDlg.Exists then
                        SpeichernDlg.Cancel
                    else
                        Warnlog "No Open-Dialog selecting Concordance-File->New!"
                    end if
                else
                    Warnlog "- Concordance-File couldn't be selected, though checkbox is checked!"
                end if
                Sleep 2
          end if
        end if

        Kontext
        Active.Setpage TabVerzeichnisseEintraege
        Kontext "TabVerzeichnisseEintraege"
        Call DialogTest (TabVerzeichnisseEintraege)
        Kontext
        Active.Setpage TabVerzeichnisseVerzeichnis
        Kontext "TabVerzeichnisseVerzeichnis"
    next i

    Kontext
    Sleep 1
    printlog "-  Tabpage Styles"
    Active.Setpage TabVerzeichnisseVorlagen
    Kontext "TabVerzeichnisseVorlagen"
    Call DialogTest (TabVerzeichnisseVorlagen)
    Sleep 1
    printlog "- Tabpage Columns"
    Kontext
    Active.Setpage TabSpalten
    Kontext "TabSpalten"
    Call DialogTest (TabSpalten)
    Sleep 1
    printlog "- Tabpage Background"
    Kontext
    Active.Setpage TabHintergrund
    Kontext "TabHintergrund"
    TabHintergrund.Cancel
    Sleep 3
    Call hCloseDocument
    '/// Close active document ///
    Sleep 5
    Call hNewDocument
    '/// Open new document ///

    Sleep 2
    ViewZoom
    '/// View Zoom ///
    Kontext "Massstab"
    '/// Check if 100% Zoom is checked ( Had a bug changed after opening Index dialog ) ///
    if Massstab.Exists then
        if Not Vergroesserung100.IsChecked then
            Warnlog "100% Zoom is not checked.Maybe Bug#95871! Set Zoom to 100%!"
            Vergroesserung100.Check
            Massstab.ok
        else
            Massstab.Cancel
            '/// Close 'Zoom' dialog ///
        end if
    else
        Warnlog "Dialog 'Zoom' does not exist!"
    end if
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tInsertIndexesBibliographyEntry
    Printlog "- Insert / Indexes / Bibliography Entry"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    end if
    Call hNewDocument
    '/// Open new document ///

    Sleep 2

    InsertIndexesBibliographyEntry
    '/// Insert / Indexes and Tables / Bibliography Entry  ///
    Kontext "Active"
    if Active.Exists then
        Do 
            try
                if Active.GetRT = 304 then
                    Warnlog Active.Gettext
                    Active.Ok
                end if
            catch
                exit do
            endcatch
        Loop
    end if
            
    Kontext "LiteratureintragEinfuegen"
    Call DialogTest ( LiteratureintragEinfuegen )
    EintragBearbeiten.Click
    '/// In dialog 'Insert Bibliography Entry' click 'Edit' ///

    Kontext "LiteratureintragDefinieren"
    Call DialogTest ( LiteratureintragDefinieren )
    '/// Close dialog 'Define Bibliography Entry' ///
    LiteratureintragDefinieren.Close
    Kontext "LiteratureintragEinfuegen"
    '/// Close dialog 'Insert Bibliography Entry' ///
    EintragSchliessen.Click
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tInsertEnvelope
    PrintLog "- Insert / Envelope"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    end if

    Call hNewDocument
    '/// Open new document ///

    InsertEnvelope
    '/// Insert / Envelope ///

    Kontext
    active.SetPage TabEnvelope
    Kontext "TabEnvelope"
    Call DialogTest (TabEnvelope)

    Kontext
    active.SetPage TabFormatEnvelope
    Kontext "TabFormatEnvelope"
    Call DialogTest (TabFormatEnvelope)
    '/// Step through all tabpages and click all buttons ///

    printlog "-  Edit Addressee"
    Sleep 1
    AddresseeEdit.Click
    wait 500
    Call hMenuSelectNr(1)
    Kontext
    Sleep 5
    Active.Setpage TabFont
    Kontext "TabFont"
    TabFont.Cancel

    Kontext "TabFormatEnvelope"
    Sleep 1
    SenderEdit.Click
    wait 500
    Call hMenuSelectNr(2)
    Kontext
    Sleep 5
    Active.Setpage TabEinzuegeUndAbstaende
    Kontext "TabEinzuegeUndAbstaende"
    TabEinzuegeUndAbstaende.Cancel

    Kontext "TabFormatEnvelope"
    printlog "-  Edit Sender"
    Sleep 1
    SenderEdit.Click
    wait 500
    Call hMenuSelectNr(1)
    Kontext
    Sleep 5
    Active.Setpage TabFont
    Kontext "TabFont"
    TabFont.Cancel

    Kontext "TabFormatEnvelope"
    Sleep 1
    SenderEdit.Click
    wait 500
    Call hMenuSelectNr(2)
    Kontext
    Sleep 5
    Active.Setpage TabEinzuegeUndAbstaende
    Kontext "TabEinzuegeUndAbstaende"
    TabEinzuegeUndAbstaende.Cancel

    Kontext
    Sleep 5
    active.SetPage TabDruckerBriefumschlag
    Kontext "TabDruckerBriefumschlag"
    Call DialogTest (TabDruckerBriefumschlag)
    if gPlatgroup = "w95" then
        Einrichten.Click
        Kontext "DruckerEinrichten"
        if DruckerEinrichten.Exists then
            DruckerEinrichten.Cancel
        else
            Warnlog "No Default-Printer!"
        end if
        Kontext "TabDruckerBriefumschlag"
    end if
    TabDruckerBriefumschlag.Close
    '/// Close dialog ///

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertFrame
    PrintLog "- Insert / Frame"

    Call hNewDocument
    '/// Open new document ///    
    
    InsertFrame
    '/// Insert / Frame ///
    Sleep 2
    Kontext
    active.SetPage TabType
    Kontext "TabType"
    Call DialogTest (TabType)
    Sleep 1
    '/// Step through all tabpages ///

    Kontext
    active.SetPage TabZusaetze
    Kontext "TabZusaetze"
    Call DialogTest (TabZusaetze)
    Sleep 1

    Kontext
    active.SetPage TabUmlauf
    Kontext "TabUmlauf"
    Call DialogTest (TabUmlauf)
    Sleep 1

    Kontext
    active.SetPage TabUmrandung
    Kontext "TabUmrandung"
    Call DialogTest (TabUmrandung)
    Sleep 1

    Kontext
    active.SetPage TabHintergrund
    Kontext "TabHintergrund"
    Call DialogTest2 (TabHintergrund, 1)
    Sleep 1
	try
		Als.Select (2)
		Call DialogTest2 (TabHintergrund, 2)
		Sleep 1
	catch
		Warnlog "Maybe missing combobox! (#i29517)"
	endcatch

    if gApplication <> "HTMLDOKUMENT" then
        Kontext
        active.SetPage TabHyperlinkRahmen
        Kontext "TabHyperlinkRahmen"
        Call DialogTest (TabHyperlinkRahmen)
        Durchsuchen.Click

        if gUSeSysDlg = False then
            Kontext "OeffnenDlg"
            OeffnenDlg.Cancel
        end if

        Kontext
        active.SetPage TabSpalten
        Kontext "TabSpalten"
        Call DialogTest (TabSpalten)
        TabSpalten.Cancel
    else
        TabHintergrund.Cancel
    end if
    '/// Close dialog ///

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertTable
    PrintLog "- Insert / Table"

    Call hNewDocument
    '/// Open new document ///       
    InsertTableWriter
    '/// Insert / Table ///
    Kontext "TabelleEinfuegenWriter"
    Call DialogTest (TabelleEinfuegenWriter)
    if Spalten.Gettext <> "2" then Warnlog "- Default for Size Columns isn't 2 , it is " + Spalten.Gettext
    if Zeilen.Gettext <> "2" then Warnlog "- Default for Size Row isn't 2, it is " + Zeilen.Gettext
    Autoformat.Click
    '/// In 'insert Table' dialog click 'AutoFormat' ///
    Kontext "AutoformatTabelle"
    Zusaetze.Click
    Call DialogTest ( AutoformatTabelle )
    '/// In 'AutoFormat' dialog click 'More' ///

    if Formatbox.GetItemCount > 2 then
        Formatbox.Select(3)
        Zusaetze.Open
        Umbenennen.Click
        Kontext "AutoformatHinzufuegenWriter"
        Call DialogTest ( AutoformatHinzufuegenWriter )
        TabellenName.SetText "Hallo"
        AutoformatHinzufuegenWriter.Cancel
        Kontext "AutoFormatTabelle"
    else
        Warnlog "Only " + Formatbox.GetItemCount + " Table formats to select ?"
    end if

    '/// Close dialog 'AutoFormat' ///
    Zusaetze.Close
    AutoformatTabelle.Cancel

    Kontext "TabelleEinfuegenWriter"
    TabelleEinfuegenWriter.Cancel
    '/// Close dialog '' ///

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tInsertHorizontalLine
    PrintLog "- Insert / Horizontal Line"

    Call hNewDocument
    '/// Open new document ///

    InsertHorizontalLine
    '/// Insert / Horizontal Line ///
    Kontext "HorizontaleLinieEinfuegen"
    Call DialogTest (HorizontaleLinieEinfuegen)
    HorizontaleLinieEinfuegen.Cancel
    '/// Close dialog 'Insert Horizontal Ruler' ///

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertGraphicsFromFile
    PrintLog "- Insert / Graphics / From File"
    Dim j as integer
    
    Call hNewDocument
    '/// Open new document ///

    InsertGraphicsFromFile
    '/// Insert / Graphics from file ///
    Kontext "GrafikEinfuegenDlg"
    Dateiname.Settext ConvertPath ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    Oeffnen.Click
    '/// Select as graphic to insert: '"...\writer\input\grafik\jolink.jpg" ///
    sleep 3

    Kontext "Active"
    if Active.Exists then
        Warnlog Active.Gettext
        Active.Ok
        Kontext "GrafikEinfuegenDlg"
        GrafikEinfuegenDlg.Cancel
        Call hCloseDocument
        goto endsub
    else
        '/// select again 'Insert / Grahics from file' ///
        InsertGraphicsFromFile
        Sleep 2
        '/// Step through all tabpages ///
        Kontext
        active.SetPage TabType
        wait 500
        Kontext "TabType"
        Call DialogTest ( TabType )

        Kontext
        active.SetPage TabZusaetze
        wait 500
        Kontext "TabZusaetze"
        Call DialogTest ( TabZusaetze )

        Kontext
        active.SetPage TabUmlauf
        wait 500
        Kontext "TabUmlauf"
        Call DialogTest ( TabUmlauf )

        Kontext
        active.SetPage TabHyperlinkRahmen
        wait 500
        Kontext "TabHyperlinkRahmen"
        Call DialogTest ( TabHyperlinkRahmen )

        Kontext
        active.SetPage TabGrafik
        wait 500
        Kontext "TabGrafik"
        Call DialogTest ( TabGrafik )

        Kontext
        active.SetPage TabUmrandung
        wait 500
        Kontext "TabUmrandung"
        Call DialogTest ( TabUmrandung )

        Kontext
        active.SetPage TabMakro
        ' if no JRE is installed a messagebox appears
        j = 0
        Do
            j = j + 1
            Kontext "Active"
            if Active.Exists then
                if Active.GetRT = 304 then
                    if j = 1 then Warnlog Active.Gettext    
                    Active.Ok
                else
                    exit do
                end if                    
            else
                exit do
            end if
        Loop        
        wait 500
        Kontext "TabMakro"
        Call DialogTest ( TabMakro )

        if gApplication <> "HTMLDOKUMENT" then
            Kontext
            active.SetPage TabZuschneiden
            wait 500
            Kontext "TabZuschneiden"
            Call DialogTest ( TabZuschneiden )

            Kontext
            active.SetPage TabHintergrund
            wait 500
            Kontext "TabHintergrund"
            Call DialogTest ( TabHintergrund )
            TabHintergrund.Cancel
        else
            TabMakro.Cancel
        end if
    end if
    '/// Close dialog ///

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertAllGraphicsFromFile
    Dim  i as integer, quellpfad as string, DieDatei as string
    Dim Ziel( 5000 ) as String
    printlog "Insert / Graphics / From File (all Formats)"
    Call hNewDocument
    '/// Open new document ///

    quellpfad = ConvertPath(gtesttoolpath + "global\input\graf_inp\")
    '/// Insert all graphic formats from directory: "global\input\graf_inp\" ///
    GetFileList(quellpfad, "*.*" , Ziel())
    for i=1 to ListCount(Ziel())
        printlog "- Graphic: " + Right(Ziel(i),3) + "-Format"
        Call hGrafikEinfuegen ( Ziel(i) )
        Sleep 5
        Call wDokSchreiben("<Delete>")
        Call gMouseDoubleClick (10,10)
        Sleep 5
    next i

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tInsertObjectOLEObject
    PrintLog "- Insert / Object / OLE-Objekt"

    Call hNewDocument
    '/// Open new document ///
    InsertObjectOLEObject
    '/// Insert / Object / OLE-Object ///
    Kontext "OLEObjektEinfuegen"
    '/// Check both radiobuttons 'Create now' and 'Create from file' ///
    NeuErstellen.Check
    Call DialogTest2 (OLEObjektEinfuegen, 1)
    AusDateiErstellen.Check
    Call DialogTest2 (OLEObjektEinfuegen, 2)
    OLEObjektEinfuegen.Cancel

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertObjectPlugIn
    PrintLog "- Insert / Object / Plug-In"

    Call hNewDocument
    '/// Open new document ///
    InsertObjectPlugIn
    '/// Close 'Plug in' dialog ///
    Kontext "PlugInEinfuegen"
    if PlugInEinfuegen.Exists then    
        Call DialogTest (PlugInEinfuegen)
        PlugInEinfuegen.Cancel
    else
        Warnlog "Dialog 'Plugin' is not up!"
    end if    

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tInsertObjectSound
    Printlog "- Insert / Object / Sound"
    Call hNewDocument
    '/// Open new document ///
    try
        if gUseSysDlg = False then
            InsertObjectSound
            '/// Insert / Object / Sound ///
            Kontext "OeffnenDlg"
            if OeffnenDlg.Exists then
                OeffnenDlg.Cancel
            else
                Warnlog "Dialog to insert Sound isn't up!"
            end if
        end if
    catch
        'Warnlog "- Menu disabled or no Sound-PlugIn installed !?"
    endcatch
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tInsertObjectVideo
    Printlog "- Insert / Object / Video"

    Call hNewDocument
    '/// Open new document ///
    try
        if gUseSysDlg = False then
            InsertObjectVideo
            '/// Insert / Object / Video ///
            Kontext "OeffnenDlg"
            if OeffnenDlg.Exists then
                OeffnenDlg.Cancel
            else
                Warnlog "Dialog to insert Video isn't up!"
            end if
        end if
    catch
        'Warnlog "- Menu disabled or no Video-PlugIn installed !?"
    endcatch
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tInsertObjectFormula
    PrintLog "- Insert / Object / Formula"

    Call hNewDocument
    '/// Open new document ///

    InsertObjectFormula
    '/// Insert / Object / Formular ///
    Sleep 2
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            Warnlog Active.Gettext
            Active.Ok
        end if
    end if
    Sleep 2

    '/// Click in 'Math' document ///
    Call gMouseClick(1,1)
    sleep 1
    '///  'Delete math-object in document ///
    Call wDokSchreiben("<Delete>")

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertObjectChart
    PrintLog "- Insert / Object / Chart"

    Call hNewDocument
    '/// Open new document ///
    ' Chart-Wizard will be invoked if data ranges exist
    ' Therefor a table will be inserted
    InsertTableWriter
    '/// Insert / Table ///
    Kontext "TabelleEinfuegenWriter"
    TabelleEinfuegenWriter.Ok
    
    InsertObjectChart
    '/// Insert / Object / Chart ///
    Kontext "ChartWizard"
    if ChartWizard.Exists then
        printlog "- Chart-Wizard is up=>OK"
        Call DialogTest ( ChartWizard )
        '/// Cancel Chart-Wizard
        ChartWizard.Cancel      
    else
        warnlog "Chart-Wizard is not up though a table has been inserted"
    end if    

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tInsertFile
    PrintLog "- Insert / File"

    Call hNewDocument
    '/// Open new document ///
    if gUseSysDlg = False then
        InsertFileWriter
        '/// Insert / File ///
        Sleep 3
        Kontext "OeffnenDlg"
        Sleep 2
        '/// Check 'File dialog' ///
        if OeffnenDlg.Exists then
            Call DialogTest ( OeffnenDlg )
            try
                Standard.Click
            catch
                Exceptlog
            endcatch

            Kontext "Active"
            if Active.Exists then
                Warnlog Active.Gettext
                Active.Ok
            else
                Kontext "OeffnenDlg"
                OeffnenDlg.Cancel
            end if
            Sleep 1
        end if
    end if

    Call hCloseDocument
    '/// Close active document ///

endcase
