'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_tools_autocorrection.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: hde $ $Date: 2006/12/07 15:06:43 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Test the AutoCorrect/AutoFormat/Word tools
'*
'************************************************************************
'*
' #0 fFormatCharacter
'*
'\***********************************************************************


function fAutocorrectOptions(Options as String)
    '/// Open Tools/Autocorrect/Autoformat diglog with tab page Options
    '///+ then choose the relevant Options and press 'space bar'

    ToolsAutocorrect
    Kontext
    Active.Setpage TabOptionenAutokorrektur
    Kontext "TabOptionenAutokorrektur"
    
    Einstellungen.TypeKeys "<Home>"

    Select case Options
        case "UseReplacementTable"         : wait 500
        case "CorrectTWoINitialCApitals"   : Einstellungen.TypeKeys "<Down>"
        case "CapitalizeFirstLetter"       : Einstellungen.TypeKeys "<Down>",2
        case "AutomaticBoldAndUnderline"   : Einstellungen.TypeKeys "<Down>",3
        case "URLRecognition"              : Einstellungen.TypeKeys "<Down>",4
        case "Replace1st"                  : Einstellungen.TypeKeys "<Down>",5
        case "Replace1/2"                  : Einstellungen.TypeKeys "<Down>",6
        case "ReplaceDashes"               : Einstellungen.TypeKeys "<Down>",7
        case "DeleteSpaceParagraph"        : Einstellungen.TypeKeys "<Down>",8
        case "DeleteSpaceLine"             : Einstellungen.TypeKeys "<Down>",9
        case "IgnoreDoulbeSpaces"          : Einstellungen.TypeKeys "<Down>",10
        case "ApplyNumbering"              : Einstellungen.TypeKeys "<Down>",11
        case "ApplyBorder"                 : Einstellungen.TypeKeys "<Down>",12
        case "CreateTable"                 : Einstellungen.TypeKeys "<Down>",13
        case "ApplyStyles"                 : Einstellungen.TypeKeys "<Down>",14
        case "RemoveBlankParagraphs"       : Einstellungen.TypeKeys "<Down>",15
        case "ReplaceCustomStyles"         : Einstellungen.TypeKeys "<Down>",16
        case "ReplaceBullets"              : Einstellungen.TypeKeys "<Down>",17
        case "ReplaceQuotes"               : Einstellungen.TypeKeys "<Down>",18
        case "CombineSingleLine"           : Einstellungen.TypeKeys "<End>"

    end select

    Einstellungen.TypeKeys "<SPACE>"
    TabOptionenAutokorrektur.OK
    
end function

'---------------------------------------------------------------

function fFormatCharacter(Options as string)
    '/// Open format/character diglog with Options.
    Kontext
    FormatCharacter
    
    Select case Options
        case "TabFont"                     : active.SetPage TabFont
        case "TabFontEffects"              : active.SetPage TabFontEffects
        case "TabFontPosition"             : active.SetPage TabFontPosition
        case "TabHyperlinkZeichen"         : active.SetPage TabHyperlinkZeichen
        case "TabHintergrund"              : active.SetPage TabHintergrund
    end select
    
    Kontext Options

end function

'-------------------------------------------------------------------------

function fFormatParagraph(Options as string)
    '/// Open format/paragraph diglog with Options
    Kontext
    FormatParagraph
    
    Select case Options
        case "TabUmrandung"                : active.SetPage TabUmrandung             'Borders
        case "TabEinzuegeUndAbstaende"     : active.SetPage TabEinzuegeUndAbstaende  'Indents & Spacing
    end select
    
    Kontext Options

end function

'-------------------------------------------------------------------------

function fDeleteAllEntries()
    '/// This function is to delete all entries in tools/autocorrect/Word completions.
    Dim i as Integer

    ToolsAutocorrect
    Kontext
    Active.Setpage TabWortergaenzung
    Kontext "TabWortergaenzung"
  
    if GesammelteWorte.GetItemCount > 0 then
        for i= 1 to GesammelteWorte.GetItemCount
            GesammelteWorte.Select 1
            if EintragLoeschen.IsEnabled then
                EintragLoeschen.Click
            else
                i = GesammelteWorte.GetItemCount + 1
            endif
        next i
    endif

    TabWortergaenzung.OK
end function

