'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_205_.inc,v $
'*
'*  $Revision: 1.10.10.1 $
'*
'*  last change: $Author: hde $ $Date: 2008/02/27 07:45:49 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Testing Number and Bullets
'*
'\***********************************************************************

sub w_205_
	
    Call tNumberingBullets_1
    Call tFormatNumberingBullets
    Call tFormatNumberingPosition
    Call tFormatNumberingOptions
    Call tFormatNumberingAll

end sub

testcase tNumberingBullets_1
	
    printlog "Turn several selected paragraphs into numbered list"
	'/// Open a new text document
    Call hNewDocument()
    '/// Insert 3 times dummy text
    Call wBlindTextEinfuegen()
    Call wBlindTextEinfuegen()
    Call wBlindTextEinfuegen()
    '/// Select all inserted text 
    Call wDokSchreiben "<shift mod1 home>"

    '/// Choose 'Numbering' on 'Objectbar'
    Kontext "TextObjectbar"
    try
        Numerierung.Click
	catch
      	warnlog "Objectbar is not accessible for numbering bullets"
	endcatch
    '/// Check if numbering has been created
    if (hIsNumberingBullets () <> True) then
        Warnlog " - Seems numbering has not been created"
    else
      	printlog " - Numbering has been created"
	endif

    '/// Turn numbereing off via Toolbar
    Printlog "Turn Numbering off"
    OL_Writer_Numerierung
    '/// Check if numbering has been turned off
    if (hIsNumberingBullets () <> False) then
        warnlog " - Seems numbering is still available"
    else
        printlog " - Numbering has been turned off"
    endif

    Printlog "'/// Restart counting via Format->Paragraph->Numbering ///"
    Call hFormatParagraphNumbering ("",1,-1)
    if (hIsNumberingBullets () <> True) then
      	Warnlog "Seems numbering has not been created"
    else
      printlog "Numbering has been created"
    endif

    Printlog "'/// +O+ restart numbering enable///"
    ' checked 'restart numbering' on tabpage toggles icon at Objectbar
    Kontext "NumObjectbar"
    if Not NumObjectBar.Exists then Call hToolbarSelect ( "BULLETSANDNUMBERING", true )
    
    ' Button in objectbar has to be checked
    if NeuStarten.GetState(2) <> 1 then
        warnlog "Button 'Restart Numbering' not pressed!"
        NeuStarten.Click
        sleep (1)
        if NeuStarten.GetState(2) <> 1 then
            warnlog "doesn't work"
        else
            printlog "     --- worked :-)"
        endif
    else
        ' Undo 'restart numbering'
        Printlog "'                          disable"
        NeuStarten.Click
        sleep (1)
        if NeuStarten.GetState(2) <> 0 then
            warnlog "doesn't work "
        else
            printlog "     --- worked :-)"
        endif
    endif
    
    Call hCloseDocument

endcase

'--------------------------------------------------

testcase tFormatNumberingBullets
	Dim i as Integer :
	PrintLog "- Format / Numbering and Bullets"
	
	'/// New document ///
	Call hNewDocument
	
	printlog "  - All bullet entries"
	'/// Insert all bullet entries ///
	for i=1 to 8
		FormatNumberingBullets
		Kontext
		Active.SetPage TabBullet
		Kontext "TabBullet"
		Auswahl.TypeKeys "<Right>", i
		TabBullet.OK
		Call wDokSchreiben "Bullet <Return><Return>"
	next i
	
	printlog "  - All Numbering entries"
	'/// Insert all numbering entries ///
	for i=1 to 8
		FormatNumberingBullets
		Kontext
		Active.SetPage TabNumerierungsart
		Kontext "TabNumerierungsart"
		Auswahl.TypeKeys "<Right>", i
		TabNumerierungsart.OK
		Call wDokSchreiben "Nummerierungsart <Return><Return>"
		Sleep 1
	next i
	
	printlog "  - All entries in Level"
	'/// Insert all level entries ///
	for i=1 to 8
		FormatNumberingBullets
		Kontext
		Active.SetPage TabGliederung
		Kontext "TabGliederung"
		Auswahl.TypeKeys "<Right>", i
		TabGliederung.OK
		Call wDokSchreiben "Gliederung <Return><Return>"
		Sleep 1
	next i
	
	printlog "  - All entries in graphic"
	'/// Insert all graphic entries ///
	for i=1 to 29
		FormatNumberingBullets
		Kontext
		Active.SetPage TabGrafiken
		Kontext "TabGrafiken"
		wait 500
		Auswahl.TypeKeys "<Right>", i
		TabGrafiken.OK
		Call wDokSchreiben "Grafik <Return><Return>"
		Sleep 1
	next i
	
	printlog "  - Save document and reload"
	'/// Save document, close and reopen previous saved document ///
	Call hSpeichernUnterKill ( gOfficePath + "user\work\format4." & WriterFilterExtension(0) )
	Sleep 2
	Call hCloseDocument
	Sleep 2
	Call hDateiOeffnen ( gOfficePath + "user\work\format4." & WriterFilterExtension(0) )
	Sleep 2
	'/// Close document ///
	Call hCloseDocument
endcase

'--------------------------------------------------
testcase tFormatNumberingPosition
    Dim V1 : Dim V2 :  Dim V3 : Dim V4 :  Dim V5 : Dim V6 :  Dim V7 : Dim V8 : Dim V9 : Dim V10
    Dim V11 : Dim V12 :  Dim V13 : Dim V14 :  Dim V15 : Dim V16

    printlog "  - adjust position of Numbering"
    '/// New document ///
    Call hNewDocument
    '/// Select Format / Numbering Bullets and adjust position for each level ///
    FormatNumberingBullets
    Kontext
    Active.SetPage TabPositionNumerierung
    Kontext "TabPositionNumerierung"
    Ebene.Select 1
    Ausrichtung.Select 2         ' Zentriert
    if Relativ.IsEnabled then Warnlog "Relativ is enabled with level1!"
    AbstandTextRand.More 5
    V1 = AbstandTextRand.GetText
    Einrueckung.More 1
    V2 = Einrueckung.GetText
    Ebene.Select 3
    Ausrichtung.Select 3         ' Rechts
    Relativ.Check
    AbstandTextRand.Less 5
    V3 = AbstandTextRand.GetText
    AbstandTextNumerierung.More 2
    V4 = AbstandTextNumerierung.GetText
    Ebene.Select 4
    Ausrichtung.Select 1         ' Links
    Relativ.Check
    V5 = AbstandTextRand.GetText
    V6 = AbstandTextNumerierung.GetText
    V7 = Einrueckung.GetText
    Ebene.Select 6
    Ausrichtung.Select 3         ' Rechts
    Relativ.Check
    AbstandTextRand.More 4
    V8 = AbstandTextRand.GetText
    AbstandTextNumerierung.Less 3
    V9 = AbstandTextNumerierung.GetText
    Einrueckung.Less 3
    V10 = Einrueckung.GetText
    Ebene.Select 9
    Ausrichtung.Select 1
    Relativ.Check
    AbstandTextRand.Less 2
    V11 = AbstandTextRand.GetText
    AbstandTextNumerierung.More 2
    V12 = AbstandTextNumerierung.GetText
    Einrueckung.More 3
    V13 = Einrueckung.GetText
    Ebene.Select 10
    Ausrichtung.Select 3
    Relativ.Check
    AbstandTextRand.More 4
    V14 = AbstandTextRand.GetText
    AbstandTextNumerierung.Less 3
    V15 = AbstandTextNumerierung.GetText
    Einrueckung.Less 3
    V16 = Einrueckung.GetText
    TabPositionNumerierung.OK

    printlog "  - write down numbering"
    '/// write down the numbering ///
    Call wDokSchreiben "Nummerierung 1. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 2. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 3. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 4. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 5. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 6. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 7. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 8. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung 9. Ebene<Return>"
    Call wDokSchreiben "<Tab>Nummerierung  10. Ebene<Return>"
    Call wDokSchreiben "<Tab>Immer noch 10. Ebene<Return>"
    Call wDokSchreiben "<Return><Return>Ende der Nummerierung"
    Call wDokSchreiben "<Up>", 5

    printlog "  - check numbering-position"
    '/// reopen Format / NumberingBullets and check settings made ///
    FormatNumberingBullets
    Kontext
    Active.SetPage TabPositionNumerierung
    Kontext "TabPositionNumerierung"
    Ebene.Select 1
    if Ausrichtung.GetSelIndex <> 2 then Warnlog "#i38904#Level 1: Wrong alignment:  Should = 2   Ist = "+ Ausrichtung.GetSelIndex
    if V1 <> AbstandTextRand.GetText then Warnlog "Level 1: Wrong Text <-> Rand:  Should = "+ V1+ "  Is = "+ AbstandTextRand.GetText
    if V2 <> Einrueckung.GetText then Warnlog "Level 1: Wrong indent:  Should = "+ V2+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 3
    if Not Relativ.IsChecked then Warnlog "Relativ is checked in Level 3!"
    if Ausrichtung.GetSelIndex <> 3 then Warnlog "#i38904#Level 3: Wrong alignment:  Should = 3   Is = "+ Ausrichtung.GetSelIndex
    if V3 <> AbstandTextRand.GetText then Warnlog "Level 3: Wrong Text <-> Spacing to text:  Should = "+ V3+ "  Is = "+ AbstandTextRand.GetText
    if V4 <> AbstandTextNumerierung.GetText then Warnlog "Level 3: Wrong indent:  Should = "+ V4+ "  Is = "+ AbstandTextNumerierung.GetText
    Ebene.Select 4
    if Not Relativ.IsChecked then Warnlog "Relativ is checked in Level 4!"
    if Ausrichtung.GetSelIndex <> 1 then Warnlog "#i38904#Level 4: Wrong alignment:  Should = 1   Is = "+ Ausrichtung.GetSelIndex
    if V5 <> AbstandTextRand.GetText then Warnlog "Level 4: Wrong Text <-> Spacing to text:  Should = "+ V5+ "  Is = "+ AbstandTextRand.GetText
    if V6 <> AbstandTextNumerierung.GetText then Warnlog "Level 4: Wrong indent:  Should = "+ V6+ "  Is = "+ AbstandTextNumerierung.GetText
    if V7 <> Einrueckung.GetText then Warnlog "Level 4: Wrong indent:  Should = "+ V7+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 6
    if Not Relativ.IsChecked then Warnlog "Relativ is checked in Level 6!"
    if Ausrichtung.GetSelIndex <> 3 then Warnlog "#i38904#Level 6: Wrong alignment:  Should = 3   Is = "+ Ausrichtung.GetSelIndex
    if V8 <> AbstandTextRand.GetText then Warnlog "Level 6: Wrong Text <-> Spacing to text:  Should = "+ V8+ "  Is = "+ AbstandTextRand.GetText
    if V9 <> AbstandTextNumerierung.GetText then Warnlog "Level 6: Wrong indent:  Should = "+ V9+ "  Is = "+ AbstandTextNumerierung.GetText
    if V10 <> Einrueckung.GetText then Warnlog "Level 6: Wrong indent:  Should = "+ V10+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 9
    if Not Relativ.IsChecked then Warnlog "Relativ is checked in Level 9!"
    if Ausrichtung.GetSelIndex <> 1 then Warnlog "#i38904#Level 9: Wrong alignment:  Should = 1   Is = "+ Ausrichtung.GetSelIndex
    if V11 <> AbstandTextRand.GetText then Warnlog "Level 9: Wrong Text <-> Spacing to text:  Should = "+ V11+ "  Is = "+ AbstandTextRand.GetText
    if V12 <> AbstandTextNumerierung.GetText then Warnlog "Level 9: Wrong indent:  Should = "+ V12+ "  Is = "+ AbstandTextNumerierung.GetText
    if V13 <> Einrueckung.GetText then Warnlog "Level 9: Wrong indent:  Should = "+ V13+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 10
    if Not Relativ.IsChecked then Warnlog "Relativ is checked in Level 10!"
    if Ausrichtung.GetSelIndex <> 3 then Warnlog "#i38904#Level 10: Wrong alignment:  Should = 3   Is = "+ Ausrichtung.GetSelIndex
    if V14 <> AbstandTextRand.GetText then Warnlog "Level 10: Wrong Text <-> Spacing to text:  Should = "+ V14+ "  Is = "+ AbstandTextRand.GetText
    if V15 <> AbstandTextNumerierung.GetText then Warnlog "Level 10: Wrong indent:  Should = "+ V15+ "  Is = "+ AbstandTextNumerierung.GetText
    if V16 <> Einrueckung.GetText then Warnlog "Level 10: Wrong indent:  Should = "+ V16+ "  Is = "+ Einrueckung.GetText
    TabPositionNumerierung.Ok

    printlog "  - check previous saved numbering"
    '/// save document, close it and reload previous saved document ///
    Sleep 1
    Call hSpeichernUnterKill ( gOfficePath + "user\work\tFormatNumberingPosition." & WriterFilterExtension(0) )
    Sleep 2
    Call hCloseDocument
    Sleep 2
    Call hDateiOeffnen ( gOfficePath + "user\work\tFormatNumberingPosition." & WriterFilterExtension(0) )

    '/// check settings on Format / NumberingBullets ///
    FormatNumberingBullets
    Kontext
    Active.SetPage TabPositionNumerierung
    Kontext "TabPositionNumerierung"
    Ebene.Select 1
    
    if Ausrichtung.GetSelIndex <> 2 then Warnlog "#i38904#Level 1: Wrong alignment:  Should = 2   Ist = "+ Ausrichtung.GetSelIndex
    if V1 <> AbstandTextRand.GetText then Warnlog "Level 1: Wrong Text <-> Rand:  Should = "+ V1+ "  Is = "+ AbstandTextRand.GetText
    if V2 <> Einrueckung.GetText then Warnlog "Level 1: Wrong indent:  Should = "+ V2+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 3
    if Not Relativ.IsChecked then Relativ.Check
    if Ausrichtung.GetSelIndex <> 3 then Warnlog "#i38904#Level 3: Wrong alignment:  Should = 3   Is = "+ Ausrichtung.GetSelIndex
    if V3 <> AbstandTextRand.GetText then Warnlog "Level 3: Wrong Text <-> Spacing to text:  Should = "+ V3+ "  Is = "+ AbstandTextRand.GetText
    if V4 <> AbstandTextNumerierung.GetText then Warnlog "Level 3: Wrong indent:  Should = "+ V4+ "  Is = "+ AbstandTextNumerierung.GetText
    Ebene.Select 4
    if Not Relativ.IsChecked then Relativ.Check
    if Ausrichtung.GetSelIndex <> 1 then Warnlog "#i38904#Level 4: Wrong alignment:  Should = 1   Is = "+ Ausrichtung.GetSelIndex
    if V5 <> AbstandTextRand.GetText then Warnlog "Level 4: Wrong Text <-> Spacing to text:  Should = "+ V5+ "  Is = "+ AbstandTextRand.GetText
    if V6 <> AbstandTextNumerierung.GetText then Warnlog "Level 4: Wrong indent:  Should = "+ V6+ "  Is = "+ AbstandTextNumerierung.GetText
    if V7 <> Einrueckung.GetText then Warnlog "Level 4: Wrong indent:  Should = "+ V7+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 6
    if Not Relativ.IsChecked then Relativ.Check
    if Ausrichtung.GetSelIndex <> 3 then Warnlog "#i38904#Level 6: Wrong alignment:  Should = 3   Is = "+ Ausrichtung.GetSelIndex
    if V8 <> AbstandTextRand.GetText then Warnlog "Level 6: Wrong Text <-> Spacing to text:  Should = "+ V8+ "  Is = "+ AbstandTextRand.GetText
    if V9 <> AbstandTextNumerierung.GetText then Warnlog "Level 6: Wrong indent:  Should = "+ V9+ "  Is = "+ AbstandTextNumerierung.GetText
    if V10 <> Einrueckung.GetText then Warnlog "Level 6: Wrong indent:  Should = "+ V10+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 9
    if Not Relativ.IsChecked then Relativ.Check
    if Ausrichtung.GetSelIndex <> 1 then Warnlog "#i38904#Level 9: Wrong alignment:  Should = 1   Is = "+ Ausrichtung.GetSelIndex
    if V11 <> AbstandTextRand.GetText then Warnlog "Level 9: Wrong Text <-> Spacing to text:  Should = "+ V11+ "  Is = "+ AbstandTextRand.GetText
    if V12 <> AbstandTextNumerierung.GetText then Warnlog "Level 9: Wrong indent:  Should = "+ V12+ "  Is = "+ AbstandTextNumerierung.GetText
    if V13 <> Einrueckung.GetText then Warnlog "Level 9: Wrong indent:  Should = "+ V13+ "  Is = "+ Einrueckung.GetText
    Ebene.Select 10
    if Not Relativ.IsChecked then Relativ.Check
    if Ausrichtung.GetSelIndex <> 3 then Warnlog "#i38904#Level 10: Wrong alignment:  Should = 3   Is = "+ Ausrichtung.GetSelIndex
    if V14 <> AbstandTextRand.GetText then Warnlog "Level 10: Wrong Text <-> Spacing to text:  Should = "+ V14+ "  Is = "+ AbstandTextRand.GetText
    if V15 <> AbstandTextNumerierung.GetText then Warnlog "Level 10: Wrong indent:  Should = "+ V15+ "  Is = "+ AbstandTextNumerierung.GetText
    if V16 <> Einrueckung.GetText then Warnlog "Level 10: Wrong indent:  Should = "+ V16+ "  Is = "+ Einrueckung.GetText
    TabPositionNumerierung.Cancel
    Sleep 1
    '/// Close document ///
    Call hCloseDocument
endcase

'--------------------------------------------------

testcase tFormatNumberingOptions
    Dim V1 : Dim V2 : Dim V3 : Dim V4 : Dim V5 : Dim V6 : Dim V7 : Dim V8 : Dim V9 : Dim V10
    Dim i as integer

    printlog "  - adjust numbering properties"
    '/// New document ///
    Call hNewDocument
    '/// Select Format / Numbering Bullets and adjust properties for each level ///
    FormatNumberingBullets

    Kontext
    Active.SetPage TabOptionenNumerierung
    Kontext "TabOptionenNumerierung"

    Ebene.Select 1
    Numerierung.Select 11           ' Keine
    Davor.SetText "Vorher "
    Dahinter.SetText "sp�ter "

    Ebene.Select 3
    Numerierung.Select 2            ' A,B,C,...
    Davor.SetText "��� "
    Dahinter.SetText "��� "
    Zeichenvorlage.Select 2
    V9 = Zeichenvorlage.GetSelText
    Vollstaendig.Less 1
    V1 = Vollstaendig.GetText
    BeginnBei.More 4
    V2 = BeginnBei.GetText

    Ebene.Select 5
    Numerierung.Select 8            ' Bullets
    if Davor.IsVisible then Warnlog "'Before' is visible on Bullet-Options"
    if Dahinter.IsVisible then Warnlog "'After' is visible on Bullet-Options"
    Zeichenvorlage.Select 1

    Ebene.Select 7
    Numerierung.Select 9            ' Grafik
    if Davor.IsVisible then Warnlog "'Before' is visible on Graphic-Options"
    if Dahinter.IsVisible then Warnlog "'After' is visible on Graphic-Options"
    Auswahl.Click
    Call hMenuSelectNr (1)
    Kontext "OeffnenDlg"
    Dateiname.Settext Convertpath(gtesttoolpath + "writer\input\grafik\bullet.gif")
    Oeffnen.Click
    wait 500
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            Warnlog Active.Gettext
            Active.Ok
        endif
    endif

    Kontext "TabOptionenNumerierung"
    Breite.More 4
    V3 = Breite.GetText
    Hoehe.More 3
    V4 = Hoehe.GetText
    Ausrichtung.Select 4

    Ebene.Select 9
    Numerierung.Select 1            ' 1,2,3,...
    Zeichenvorlage.Select 3
    V10 = Zeichenvorlage.GetSelText

    Ebene.Select 10
    Numerierung.Select 3            ' a,b,c,...
    V5 = Davor.GetText
    V6 = Dahinter.GetText
    Vollstaendig.More 9
    V7 = Vollstaendig.GetText
    BeginnBei.More 3
    V8 = BeginnBei.GetText
    TabOptionenNumerierung.OK

    printlog "  - write down numbering"
    '/// write down numbering ///
    Call wDokSchreiben "Hallo 1. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 2. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 3. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 4. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 5. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 6. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 7. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 8. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 9. Ebene<Return>"
    Call wDokSchreiben "<Tab>Hallo 10. Ebene<Return>"
    Call wDokSchreiben "<Tab>Immer noch 10. Ebene<Return>"
    Call wDokSchreiben "<Return><Return>Ende der Numerierung"
    Call wDokSchreiben "<Up>", 5

    FormatNumberingBullets
    Kontext
    Active.SetPage TabOptionenNumerierung
    Kontext "TabOptionenNumerierung"
    Ebene.Select 1
    if Numerierung.GetSelIndex <> 11 then Warnlog "Level 1: Wrong Numbering type : Should 11     Is " + Numerierung.GetSelIndex
    if Davor.GetText <> "Vorher " then Warnlog "Level 1: Wrong Text in 'After': Should 'Vorher '    Is " + Davor.GetText
    if Dahinter.GetText <> "sp�ter " then Warnlog "Level 1: Wrong Text in 'Before': Should 'sp�ter '    Is " + Dahinter.GetText
    Ebene.Select 3
    if Numerierung.GetSelIndex <> 2 then Warnlog "Level 3: Wrong Numbering type : Should 2     Is " + Numerierung.GetSelIndex
    if Davor.GetText <> "��� " then Warnlog "Level 3: Wrong Text in 'Before': Should '��� '    Is " + Davor.GetText
    if Dahinter.GetText <> "��� " then Warnlog "Level 3: Wrong Text in 'After': Should '��� '    Is " + Dahinter.GetText
    if Zeichenvorlage.GetSelText <> V9 then Warnlog "Level 3: Wrong Character Style: Should " + V9 + "    Is " + Zeichenvorlage.GetSelText
    if V1 <> Vollstaendig.GetText then Warnlog "Level 3: 'Show Sublevels' Is wrong: Should " + V1 + "   Is: " + Vollstaendig.GetText
    if V2 <> BeginnBei.GetText then Warnlog "Level 3: 'Start at'  Is wrong: Should " + V2 + "   Is: " + BeginnBei.GetText
    Ebene.Select 5
    if Numerierung.GetSelIndex <> 8 then Warnlog "Level 5: Wrong Numbering type : Should 8     Is " + Numerierung.GetSelIndex
    if Zeichenvorlage.GetSelIndex <> 1 then Warnlog "Level 5: Wrong Character Style: Should 1    Is " + Zeichenvorlage.GetSelIndex
    Ebene.Select 7
    if Numerierung.GetSelIndex <> 9 then
        Warnlog "Level 7: Wrong Numbering type : Should 9     Is " + Numerierung.GetSelIndex
    else
        if V3 <> Breite.GetText then Warnlog "Level 7: Wrong graphic width: Should " + V3 + "   Is: " + Breite.GetText
        if V4 <> Hoehe.GetText then Warnlog "Level 7: Wrong graphic height: Should " + V4 + "   Is: " + Hoehe.GetText
        if Ausrichtung.GetSelIndex <> 4 then Warnlog "Level 7: Alignment Is not 4 but " + Ausrichtung.GetSelIndex
    endif
    Ebene.Select 9
    if Numerierung.GetSelIndex <> 1 then Warnlog "Level 9: Wrong Numbering type : Should 1     Is " + Numerierung.GetSelIndex
    if Zeichenvorlage.GetSelText <> V10 then Warnlog "Level 9: Wrong Character Style: Should " + V10 +"    Is " + Zeichenvorlage.GetSelText
    Ebene.Select 10
    if Numerierung.GetSelIndex <> 3 then Warnlog "Level 10: Wrong Numbering type : Should 3     Is " + Numerierung.GetSelIndex
    if Davor.GetText <> V5 then Warnlog "Level 10: Wrong Text in 'Before': Should "+ V5 + "    Is " + Davor.GetText
    if Dahinter.GetText <> V6 then Warnlog "Level 10: Wrong Text in 'After': Should "+ V6 + "    Is " + Dahinter.GetText
    if V7 <> Vollstaendig.GetText then Warnlog "Level 10: 'Show Sublevels' Is wrong: Should " + V7 + "   Is: " + Vollstaendig.GetText
    if V8 <> BeginnBei.GetText then Warnlog "Level 10: 'Start at'  Is wrong: Should " + V8 + "   Is: " + BeginnBei.GetText
    TabOptionenNumerierung.Cancel

    printlog "  - check previous saved numbering"
    '/// save document, close it and reload previous saved document ///
    Call hSpeichernUnterKill ( gOfficePath + "user\work\format6." & WriterFilterExtension(0) )
    Sleep 2
    Call hCloseDocument
    Sleep 2
    Call hDateiOeffnen ( gOfficePath + "user\work\format6." & WriterFilterExtension(0) )
    For i = 1 to 15
        Call wDokSchreiben "<Up>"
        Wait 500
    next i
    Call wDokSchreiben "<Home>"

    '/// check settings in Format / Numbering Bullets ///
    FormatNumberingBullets
    Kontext
    Active.SetPage TabOptionenNumerierung
    Kontext "TabOptionenNumerierung"
    Ebene.Select 1
    if Numerierung.GetSelIndex <> 11 then Warnlog "Level 1: Wrong Numbering type : Should 11     Is " + Numerierung.GetSelIndex
    if Davor.GetText <> "Vorher " then Warnlog "Level 1: Wrong Text in 'After': Should 'Vorher '    Is " + Davor.GetText
    if Dahinter.GetText <> "sp�ter " then Warnlog "Level 1: Wrong Text in 'Before': Should 'sp�ter '    Is " + Dahinter.GetText
    Ebene.Select 3
    if Numerierung.GetSelIndex <> 2 then Warnlog "Level 3: Wrong Numbering type : Should 2     Is " + Numerierung.GetSelIndex
    if Davor.GetText <> "��� " then Warnlog "Level 3: Wrong Text in 'Before': Should '��� '    Is " + Davor.GetText
    if Dahinter.GetText <> "��� " then Warnlog "Level 3: Wrong Text in 'After': Should '��� '    Is " + Dahinter.GetText
    if Zeichenvorlage.GetSelText <> V9 then Warnlog "Level 3: Wrong Character Style: Should " + V9 + "    Is " + Zeichenvorlage.GetSelText
    if V1 <> Vollstaendig.GetText then Warnlog "Level 3: 'Show Sublevels' Is wrong: Should " + V1 + "   Is: " + Vollstaendig.GetText
    if V2 <> BeginnBei.GetText then Warnlog "Level 3: 'Start at'  Is wrong: Should " + V2 + "   Is: " + BeginnBei.GetText
    Ebene.Select 5
    if Numerierung.GetSelIndex <> 8 then Warnlog "Level 5: Wrong Numbering type : Should 8     Is " + Numerierung.GetSelIndex
    if Zeichenvorlage.GetSelIndex <> 1 then Warnlog "Level 5: Wrong Character Style: Should 1    Is " + Zeichenvorlage.GetSelIndex
    Ebene.Select 7
    if Numerierung.GetSelIndex <> 9 then
        Warnlog "Level 7: Wrong Numbering type : Should 9     Is " + Numerierung.GetSelIndex
    else
        if V3 <> Breite.GetText then Warnlog "Level 7: Wrong graphic width: Should " + V3 + "   Is: " + Breite.GetText
        if V4 <> Hoehe.GetText then Warnlog "Level 7: Wrong graphic height: Should " + V4 + "   Is: " + Hoehe.GetText
        if Ausrichtung.GetSelIndex <> 4 then Warnlog "Level 7: Alignment Is not 4 but " + Ausrichtung.GetSelIndex
    endif
    Ebene.Select 9
    if Numerierung.GetSelIndex <> 1 then Warnlog "Level 9: Wrong Numbering type : Should 1     Is " + Numerierung.GetSelIndex
    if Zeichenvorlage.GetSelText <> V10 then Warnlog "Level 9: Wrong Character Style: Should " + V10 +"    Is " + Zeichenvorlage.GetSelText
    Ebene.Select 10
    if Numerierung.GetSelIndex <> 3 then Warnlog "Level 10: Wrong Numbering type : Should 3     Is " + Numerierung.GetSelIndex
    if Davor.GetText <> V5 then Warnlog "Level 10: Wrong Text in 'Before': Should "+ V5 + "    Is " + Davor.GetText
    if Dahinter.GetText <> V6 then Warnlog "Level 10: Wrong Text in 'After': Should "+ V6 + "    Is " + Dahinter.GetText
    if V7 <> Vollstaendig.GetText then Warnlog "Level 10: 'Show Sublevels' Is wrong: Should " + V7 + "   Is: " + Vollstaendig.GetText
    if V8 <> BeginnBei.GetText then Warnlog "Level 10: 'Start at'  Is wrong: Should " + V8 + "   Is: " + BeginnBei.GetText
    TabOptionenNumerierung.Cancel

    '/// Close document ///
    Call hCloseDocument
endcase

'--------------------------------------------------
testcase tFormatNumberingAll
	Dim i as Integer
	Dim Wert( 20 ) as Integer
	printlog "- Format / Numbering -Bullets in detail"
	printlog "  - adjust different Numbering and check the properties"
	'/// New document ///
	Call hNewDocument
	'/// Select Format / NumberingBullets and adjust different numbering ///
	FormatNumberingBullets
	
	Kontext
	Active.SetPage TabBullet
	Kontext "TabBullet"
	Sleep 1
	Auswahl.TypeKeys "<Right><Down>"
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 1 select a bullet ///
	Ebene.Select 1                                               ' 1. Ebene ein Bullet einstellen
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 2 select a numbering ///
	Ebene.Select 2                                               ' 2. Ebene eine Numerierungsart einstellen
	
	Kontext
	Active.SetPage TabNumerierungsart
	Kontext "TabNumerierungsart"
	Sleep 1
	Auswahl.TypeKeys "<Down>", 2
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 3 select a numbering ///
	Ebene.Select 3                                               ' 3. Ebene eine Numerierungsart einstellen
	
	Kontext
	Active.SetPage TabNumerierungsart
	Kontext "TabNumerierungsart"
	Sleep 1
	Auswahl.TypeKeys "<Down><Right>", 2
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 4 select a graphic ///
	Ebene.Select 4                                               ' 4. Ebene eine Grafik einstellen
	
	Kontext
	Active.SetPage TabGrafiken
	Kontext "TabGrafiken"
	Sleep 1
	Auswahl.TypeKeys "<Right>"
															' 5. und 6. Ebene werden nicht besonders eingestellt
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 7 select a graphic ///
	Ebene.Select 7                                               ' 7. Ebene eine Grafik einstellen
	
	Kontext
	Active.SetPage TabGrafiken
	Kontext "TabGrafiken"
	Sleep 1
	Auswahl.TypeKeys "<Right><Down>"
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 8 select a graphic ///
	Ebene.Select 8                                               ' 8. Ebene eine Grafik einstellen
	
	Kontext
	Active.SetPage TabGrafiken
	Kontext "TabGrafiken"
	Sleep 1
	Auswahl.TypeKeys "<Right>", 5
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 9 select a bullet ///
	Ebene.Select 9                                               ' 9. Ebene ein Bullet einstellen
	
	Kontext
	Active.SetPage TabBullet
	Kontext "TabBullet"
	Sleep 1
	Auswahl.TypeKeys "<Down>"
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	'/// Level 10 select a numbering ///
	Ebene.Select 10                                              ' 10. Ebene eine Numerierungsart einstellen
	
	Kontext
	Active.SetPage TabNumerierungsart
	Kontext "TabNumerierungsart"
	Sleep 1
	Auswahl.TypeKeys "<Right>", 2
	
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	
	for i=1 to 10
		Ebene.Select i
		Wert (i) = Numerierung.GetSelIndex
	next i
	'/// check settings made ///
	
	if Wert(1)  <> 8 then Warnlog "Selected entry => 1. Level Is not Bullets (8. Entry) but entry " + Wert(1)
	if Wert(2)  <> 2 then Warnlog "Selected entry => 2. Level Is not Numbering 1 but entry " + Wert(2)
	if Wert(3)  <> 3 then Warnlog "Selected entry => 3. Level Is not Numbering 2 but entry " + Wert(3)
	if Wert(4)  <> 9 then Warnlog "Selected entry => 4. Level Is not Graphic (9. Entry) but entry " + Wert(4)
	if Wert(5)  <> 8 then Warnlog "Selected entry => 5. Level Is not Bullets (8. Entry) but entry " + Wert(5)
	if Wert(6)  <> 8 then Warnlog "Selected entry => 6. Level Is not Bullets (8. Entry) but entry " + Wert(6)
	if Wert(7)  <> 9 then Warnlog "Selected entry => 7. Level Is not Graphic (9. Entry) but entry " + Wert(7)
	if Wert(8)  <> 9 then Warnlog "Selected entry => 8. Level Is not Graphic (9. Entry) but entry " + Wert(8)
	if Wert(9)  <> 8 then Warnlog "Selected entry => 9. Level Is not Bullets (8. Entry) but entry " + Wert(9)
	if Wert(10) <> 1 then Warnlog "Selected entry => 10. Level Is not Numbering 1 but entry " + Wert(10)
	
	TabOptionenNumerierung.OK
	
	printlog "  - create numbering and check them"
	'/// create numbering and check it ///
	Call wDokSchreiben "Hallo 1. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 2. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 3. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 4. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 5. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 6. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 7. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 8. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 9. Ebene<Return>"
	Call wDokSchreiben "<Tab>Hallo 10. Ebene<Return>"
	Call wDokSchreiben "<Tab>Immer noch 10. Ebene<Return>"
	Call wDokSchreiben "<Return><Return>Ende der Numerierung"
	Call wDokSchreiben "<Up>", 5
	
	FormatNumberingBullets
	'/// reopen dialog and check settings ///
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	for i=1 to 10
		Ebene.Select i
		if Numerierung.GetSelIndex <> Wert(i) then 
			Warnlog "After creating: => Level " + i + " has not numbering " + Wert (i) + " but " + Numerierung.GetSelIndex
		endif
	next i
	TabOptionenNumerierung.Cancel
	
	printlog "  - check previous saved numbering"
	'/// save document, close and reload previous saved document ///
	Sleep 2
	Call hSpeichernUnterKill ( gOfficePath + "user\work\format7." & WriterFilterExtension(0) )
	Sleep 2
	Call hCloseDocument
	Sleep 2
	Call hDateiOeffnen ( gOfficePath + "user\work\format7." & WriterFilterExtension(0) )
	Sleep 2
	FormatNumberingBullets
	'/// reopen Format / NumberingBullets and check saved settings ///
	Kontext
	Active.SetPage TabOptionenNumerierung
	Kontext "TabOptionenNumerierung"
	for i=1 to 10
		Ebene.Select i
		if Numerierung.GetSelIndex <> Wert(i) then Warnlog "After saving: => Level " + i + " has not Numbering " + Wert (i) + " but " + Numerierung.GetSelIndex
	next i
	TabOptionenNumerierung.Cancel
	
	'/// close document ///
	Call hCloseDocument
endcase
