'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_219_.inc,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: hde $ $Date: 2008/01/02 14:02:35 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : CROSS-APPLICATIONS CLIPBOARD TEST (Writer)
'*
'\***********************************************************************

sub w_219_

    Call HTMLToIMPRESSText
    Call HTMLToIMPRESSField
    Call HTMLToIMPRESSTable
    Call HTMLToIMPRESSGraphicLinked
    Call HTMLToIMPRESSControl
    Call HTMLToIMPRESSFloatingFrame

end sub

' ---------------------------------------------------------------------------------

testcase HTMLToIMPRESSText
  gApplication = "HTMLDOKUMENT"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
  '///+ Jump to beginning of document ///
  '///+ Select first paragraph ///
  '///+ Copy selected text ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
  '/// Jump to beginning of document ///
  Call wDokSchreiben "<Mod1 Home>"
  Call wDokSchreiben "<Shift Down><Shift End>"
  EditCopy

  gApplication = "IMPRESS"
  '///+ Open new document ///
  Call hNewDocument
  '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
   Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"text")
   '///+ Write Clipboard format under pasted content ///
   Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\html_to_impress_text.odp", gImpressFilter)
   '///+ Save document as "..\user\work\html_to_impress_text.odp" ///
   Wait 500
   Call hCloseDocument
   '///+ Close saved document ///
   wait 500
   Call hDateiOeffnen (gOfficepath + "user\work\html_to_impress_text.odp",true)
   '///+ Reopen saved document ///
   Wait 500
   Call hCloseDocument
   '///+ Close saved document ///
  else
   Warnlog "Dialog 'Paste Special' is not up!"
   Call hCloseDocument
   goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///

endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToIMPRESSField
  gApplication = "HTMLDOKUMENT"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
  '///+ Jump to beginning of document ///
  '///+ Select paragraph with 'Date Field' ///
  '///+ Copy selected text ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
  '/// Jump to beginning of document ///
  Call wDokSchreiben "<Mod1 Home>"
  Call wDokSchreiben "<Down>",2
  Call wDokSchreiben "<Home><Shift End>"
  EditCopy

    gApplication = "IMPRESS"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Field' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"field")
    '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\html_to_impress_field.odp", gImpressFilter)
     '///+ Save document as "..\user\work\html_to_impress_field.odp" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\html_to_impress_field.odp",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  '/// Close active document ///
  Call hCloseDocument

endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToIMPRESSTable
  gApplication = "HTMLDOKUMENT"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Table' ///
  '///+ Copy selected table ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
  '/// Jump to beginning of document ///
  Call wDokSchreiben "<Mod1 Home>"
  Call wDokSchreiben "<Down>",5
  Call wDokSchreiben "<Mod1 A>",2
  EditCopy

  gApplication = "IMPRESS"
  '///+ Open new document ///
  Call hNewDocument
  '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
  Wait 500
  '/// Paste 'Table' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
   if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"table")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\html_to_impress_table.odp", gImpressFilter)
     '///+ Save document as "..\user\work\html_to_impress_table.odp" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\html_to_impress_table.odp",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
   else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
   endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToIMPRESSGraphicLinked
    gApplication = "HTMLDOKUMENT"
    '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
    '///+ Jump to beginning of document ///
    '///+ Select 'Linked Graphic' ///
    '///+ Copy selected Linked Graphic ///
    Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
    '/// Jump to beginning of document ///
    Call wDokSchreiben "<Mod1 Home>"
    Call wDokSchreiben ( "<Shift F4>" )
    EditCopy
    
    gApplication = "IMPRESS"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Linked Graphic' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
        Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"graphicL")
        '///+ Write Clipboard format under pasted content ///
        Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\html_to_impress_graphic1.odp", gImpressFilter)
        '///+ Save document as "..\user\work\html_to_impress_graphic1.odp" ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
        wait 500
        Call hDateiOeffnen (gOfficepath + "user\work\html_to_impress_graphic1.odp",true)
        '///+ Reopen saved document ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
    else
        Warnlog "Dialog 'Paste Special' is not up!"
        Call hCloseDocument
        goto endsub
    endif
    '/// Close active document ///
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToIMPRESSControl
    gApplication = "HTMLDOKUMENT"
    '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
    '///+ Jump to beginning of document ///
    '///+ Select 'Control' ///
    '///+ Copy selected Control ///
    Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
    '/// Jump to beginning of document ///
    Call wDokSchreiben "<Mod1 Home>"
    Call wDokSchreiben ( "<Shift F4>" )
    Call wDokSchreiben "<Tab>"
    EditCopy
    
    gApplication = "IMPRESS"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Control' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
        Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"control")
        '///+ Write Clipboard format under pasted content ///
        Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\html_to_impress_control.odp", gImpressFilter)
        '///+ Save document as "..\user\work\html_to_impress_control.odp" ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
        wait 500
        Call hDateiOeffnen (gOfficepath + "user\work\html_to_impress_control.odp",true)
        '///+ Reopen saved document ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
    else
        Warnlog "Dialog 'Paste Special' is not up!"
        Call hCloseDocument
        goto endsub
    endif
    '/// Close active document ///
    Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase HTMLToIMPRESSFloatingFrame
    gApplication = "HTMLDOKUMENT"
    '/// Open File '..\\writer\\level1\\input\\clipboard\\html.html' ///
    '///+ Jump to beginning of document ///
    '///+ Select 'Floating Frame' ///
    '///+ Copy selected Floating Frame ///
    Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\html.html")
    '/// Jump to beginning of document ///
    Call wDokSchreiben "<Mod1 Home>"
    Call wDokSchreiben ( "<Shift F4>" )
    Call wDokSchreiben "<Tab>",2
    try
        EditCopy
    catch
        Warnlog "Edit / Copy is disabled ! Maybe object not selected!"
        Call hCloseDocument
        goto endsub
    endcatch
    gApplication = "IMPRESS"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Floating Frame' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
        Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"control")
        '///+ Write Clipboard format under pasted content ///
        Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\html_to_impress_float.odp", gImpressFilter)
        '///+ Save document as "..\user\work\html_to_impress_float.odp" ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
        wait 500
        Call hDateiOeffnen (gOfficepath + "user\work\html_to_impress_float.odp",true)
        '///+ Reopen saved document ///
        Wait 500
        Call hCloseDocument
        '///+ Close saved document ///
    else
        Warnlog "Dialog 'Paste Special' is not up!"
        Call hCloseDocument
        goto endsub
    endif
    '/// Close active document ///
    Call hCloseDocument
endcase
