'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_215_.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: hde $ $Date: 2008/01/02 14:02:35 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : CROSS-APPLICATIONS CLIPBOARD TEST (Writer)
'*
'\***********************************************************************

sub w_215_

    Call CalcToWriterText1
    Call CalcToWriterText2
    Call CalcToWriterCalculation
    Call CalcToWriterHyperlink1
    Call CalcToWriterHyperlink2
    Call CalcToWriterDrawObject
    Call CalcToWriterOLE

end sub


testcase CalcToWriterText1
  gApplication = "CALC"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\calc.sxc' ///
  '///+ Jump to beginning of document ///
  '///+ Select cell <A2> ///
  '///+ Copy selected text ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\calc.sxc")
  Kontext "DocumentCalc"
  '/// Jump to beginning of document ///
  DocumentCalc.TypeKeys "<Mod1 Home>"
  DocumentCalc.TypeKeys "<Down>"
  EditCopy
  gApplication = "WRITER"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
     Call hCloseDocument
     Call hCloseDocument
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"ctext")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_writer_textformat_wholecell.odt", gWriterFilter)
    '///+ Save document as "..\user\work\writer_to_writer_textformat_wholecell.odt" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_textformat_wholecell.odt",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

' ---------------------------------------------------------------------------------

testcase CalcToWriterText2
  gApplication = "CALC"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\calc.sxc' ///
  '///+ Jump to beginning of document ///
  '///+ Select cell <A1>, press F2 and select all ///
  '///+ Copy selected text ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\calc.sxc")
  Kontext "DocumentCalc"
  '/// Jump to beginning of document ///
  DocumentCalc.TypeKeys "<Mod1 Home>"
  DocumentCalc.TypeKeys "<Down>"
  DocumentCalc.TypeKeys "<F2>"
  DocumentCalc.TypeKeys "<Mod1 A>"
  EditCopy
  gApplication = "WRITER"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
     Call hCloseDocument
     Call hCloseDocument
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"text")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_writer_textformat_cellcontent.odt", gWriterFilter)
    '///+ Save document as "..\user\work\writer_to_writer_textformat_cellcontent.odt" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_textformat_cellcontent.odt",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

' ---------------------------------------------------------------------------------

testcase CalcToWriterCalculation
  gApplication = "CALC"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\calc.sxc' ///
  '///+ Jump to beginning of document ///
  '///+ Select cell <A5:C5> ///
  '///+ Copy selected text ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\calc.sxc")
  Kontext "DocumentCalc"
  '/// Jump to beginning of document ///
  DocumentCalc.TypeKeys "<Mod1 Home>"
  DocumentCalc.TypeKeys "<Down>",4
  DocumentCalc.TypeKeys "<Shift Right>", 2
  EditCopy
  gApplication = "WRITER"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
     Call hCloseDocument
     Call hCloseDocument
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"ctext")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_writer_calculation_cellformat.odt", gWriterFilter)
    '///+ Save document as "..\user\work\writer_to_writer_calculation_cellformat.odt" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_calculation_cellformat.odt",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

' ---------------------------------------------------------------------------------

testcase CalcToWriterHyperlink1
  gApplication = "CALC"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\calc.sxc' ///
  '///+ Jump to beginning of document ///
  '///+ Select cell <A8> ///
  '///+ Copy selected text ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\calc.sxc")
  Kontext "DocumentCalc"
  '/// Jump to beginning of document ///
  DocumentCalc.TypeKeys "<Mod1 Home>"
  DocumentCalc.TypeKeys "<Down>",7
  EditCopy
  gApplication = "WRITER"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
     Call hCloseDocument
     Call hCloseDocument
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"ctext")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_writer_hyperlink_wholecell.odt", gWriterFilter)
    '///+ Save document as "..\user\work\writer_to_writer_hyperlink_wholecell.odt" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_hyperlink_wholecell.odt",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

' ---------------------------------------------------------------------------------

testcase CalcToWriterHyperlink2
  gApplication = "CALC"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\calc.sxc' ///
  '///+ Jump to beginning of document ///
  '///+ Select cell <A8> ///
  '///+ Copy selected text ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\calc.sxc")
  Kontext "DocumentCalc"
  '/// Jump to beginning of document ///
  DocumentCalc.TypeKeys "<Mod1 Home>"
  DocumentCalc.TypeKeys "<Down>",7
  DocumentCalc.TypeKeys "<F2>"
  DocumentCalc.TypeKeys "<Mod1 A>"
  EditCopy
  gApplication = "WRITER"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
     Call hCloseDocument
     Call hCloseDocument
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"text")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_writer_hyperlink_cellcontent.odt", gWriterFilter)
    '///+ Save document as "..\user\work\writer_to_writer_hyperlink_cellcontent.odt" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_hyperlink_cellcontent.odt",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

' ---------------------------------------------------------------------------------

testcase CalcToWriterDrawObject
  gApplication = "CALC"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\calc.sxc' ///
  '///+ Jump to beginning of document ///
  '///+ Select Drawing object ///
  '///+ Copy selected object ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\calc.sxc")
  Kontext "DocumentCalc"
  '/// Jump to beginning of document ///
  Call wNavigatorAuswahl(8,1)
  EditCopy
  gApplication = "WRITER"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
     Call hCloseDocument
     Call hCloseDocument
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"ctext")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_writer_draw.odt", gWriterFilter)
    '///+ Save document as "..\user\work\writer_to_writer_draw.odt" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_draw.odt",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

' ---------------------------------------------------------------------------------

testcase CalcToWriterOLE
  gApplication = "CALC"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\calc.sxc' ///
  '///+ Jump to beginning of document ///
  '///+ Select OLE-Object ///
  '///+ Copy selected object ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\calc.sxc")
  Kontext "DocumentCalc"
  '/// Jump to beginning of document ///
  Call wNavigatorAuswahl(6,1)
  EditCopy
  gApplication = "WRITER"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special'! Test failed!"
     Call hCloseDocument
     Call hCloseDocument
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"ctext")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_writer_ole.odt", gWriterFilter)
    '///+ Save document as "..\user\work\writer_to_writer_ole.odt" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_ole.odt",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

