'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_212_.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: hde $ $Date: 2008/01/02 14:02:35 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : CROSS-APPLICATIONS CLIPBOARD TEST (Writer)
'*
'\***********************************************************************

sub w_212_

    Call wDisableImpressAutopilot
    Call WriterToImpressText
    Call WriterToImpressField
    Call WriterToImpressTable
    Call WriterToImpressFrame
    Call WriterToImpressDrawingObject
    Call WriterToImpressGraphicLinked
    Call WriterToImpressGraphicEmbedded
    Call WriterToImpressOLEObject
    Call WriterToImpressControl

end sub

' ---------------------------------------------------------------------------------

testcase WriterToImpressText
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select first paragraph ///
  '///+ Copy selected text ///
  if wSetClipboardtestDefaults("text") = True then
    gApplication = "IMPRESS"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Text' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"text")
    '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_impress_text.odp", gImpressFilter)
     '///+ Save document as "..\user\work\writer_to_impress_text.odp" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_impress_text.odp",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Impress -> 'Text' failed !"
  endif
  Call hCloseDocument
  '/// Close active document ///

endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToImpressField
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select paragraph with 'Date Field' ///
  '///+ Copy selected text ///
  if wSetClipboardtestDefaults("field") = True then
    gApplication = "IMPRESS"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Field' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"field")
    '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_impress_field.odp", gImpressFilter)
     '///+ Save document as "..\user\work\writer_to_impress_field.odp" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_impress_field.odp",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Impress -> 'Field' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument

endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToImpressTable
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Table' ///
  '///+ Copy selected table ///
  if wSetClipboardtestDefaults("table") = True then
    gApplication = "IMPRESS"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"table")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_impress_table.odp", gImpressFilter)
     '///+ Save document as "..\user\work\writer_to_impress_table.odp" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_impress_table.odp",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Impress -> 'Table' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToImpressFrame
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Frame' ///
  '///+ Copy selected frame ///
  if wSetClipboardtestDefaults("frame") = True then
    gApplication = "IMPRESS"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"frame")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_impress_frame.odp", gImpressFilter)
     '///+ Save document as "..\user\work\writer_to_impress_frame.odp" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_impress_frame.odp",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Impress -> 'Frame' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToImpressDrawingObject
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Drawing Object' ///
  '///+ Copy selected Drawing Object ///
  if wSetClipboardtestDefaults("draw") = True then
    gApplication = "IMPRESS"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"draw")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_impress_draw.odp", gImpressFilter)
     '///+ Save document as "..\user\work\writer_to_impress_draw.odp" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_impress_draw.odp",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Impress -> 'Drawing Object' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToImpressGraphicLinked
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Linked Graphic' ///
  '///+ Copy selected Linked Graphic ///
  if wSetClipboardtestDefaults("graphicL") = True then
    gApplication = "IMPRESS"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Linked Graphic' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"graphicL")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_impress_graphic1.odp", gImpressFilter)
     '///+ Save document as "..\user\work\writer_to_impress_graphic1.odp" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_impress_graphic1.odp",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Impress -> 'Linked Graphic' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToImpressGraphicEmbedded
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Embedded Graphic' ///
  '///+ Copy selected Embedded Graphic ///
  if wSetClipboardtestDefaults("graphicE") = True then
    gApplication = "IMPRESS"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Embedded Graphic' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"graphicE")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_impress_graphic2.odp", gImpressFilter)
     '///+ Save document as "..\user\work\writer_to_impress_graphic2.odp" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_impress_graphic2.odp",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Impress -> 'Embedded Graphic' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToImpressOLEObject
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'OLE Object' ///
  '///+ Copy selected OLE Object ///
  if wSetClipboardtestDefaults("ole") = True then
    gApplication = "IMPRESS"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'OLE object' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"ole")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_impress_ole.odp", gImpressFilter)
     '///+ Save document as "..\user\work\writer_to_impress_ole.odp" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_impress_ole.odp",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Impress -> 'OLE object' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToImpressControl
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Control' ///
  '///+ Copy selected Control ///
  if wSetClipboardtestDefaults("control") = True then
    gApplication = "IMPRESS"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecial
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Control' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"control")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\writer_to_impress_control.odp", gImpressFilter)
     '///+ Save document as "..\user\work\writer_to_impress_control.odp" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_impress_control.odp",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Impress -> 'Control' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase
