#!/bin/bash

#*************************************************************************
#*
#*  OpenOffice.org - a multi-platform office productivity suite
#*
#*  $RCSfile: ooo_screenshots.sh,v $
#*
#*  $Revision: 1.1 $
#*
#*  last change: $Author: tbo $ $Date: 2007/01/10 15:20:53 $
#*
#*  The Contents of this file are made available subject to
#*  the terms of GNU Lesser General Public License Version 2.1.
#*
#*
#*    GNU Lesser General Public License Version 2.1
#*    =============================================
#*    Copyright 2005 by Sun Microsystems, Inc.
#*    901 San Antonio Road, Palo Alto, CA 94303, USA
#*
#*    This library is free software; you can redistribute it and/or
#*    modify it under the terms of the GNU Lesser General Public
#*    License version 2.1, as published by the Free Software Foundation.
#*
#*    This library is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#*    Lesser General Public License for more details.
#*
#*    You should have received a copy of the GNU Lesser General Public
#*    License along with this library; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#*    MA  02111-1307  USA
#*
#########################################################################
#
# Owner : petr.dudacek@sun.com
#
# short description : create ~750 screenshots of dialogs
#
# note: in order to create screenshots, add the generic
#       TestTool configuration item: Screenshot
#       
#        values:
#         True / 1 : Enable screenshots
#         False / 0 : Disable screenshots
#
#
# more info at: http://qa.openoffice.org/files/documents/77/3247/essen2006testtool2.pdf
#
#########################################################################

# set location of testscripts
# (the directory, where directory 'qatesttool' exists)
sLocation=/testtool

# set location of TestTool
# (full path including executable 'testtool')
sTestTool=/testtool/linux/testtool

# set location of close-office file
# (see cvs)
sExitOfficeBas="$sLocation/qatesttool/global/tools/closeoffice.bas"

# insert tests here
testList=("

  /qatesttool/writer/update/w_updt.bas\
  /qatesttool/calc/update/c_updt.bas\
  /qatesttool/graphics/update/d_updt.bas\
  /qatesttool/graphics/update/i_updt_1.bas\
	/qatesttool/graphics/update/i_updt_2.bas\
  /qatesttool/base/update/b_updt.bas\
  /qatesttool/math/update/m_updt.bas\
  /qatesttool/framework/update/f_updt_help.bas\
	/qatesttool/framework/update/f_updt_templates.bas\
	/qatesttool/framework/update/f_updt_toolbars.bas\
	/qatesttool/framework/update/f_updt_spadmin.bas\
	/qatesttool/framework/update/f_updt_faxwizard.bas\
	/qatesttool/framework/update/f_updt_letterwizard.bas\
	/qatesttool/framework/update/f_updt_firsttimewizard.bas\
	/qatesttool/framework/update/f_updt_agendawizard.bas\
	/qatesttool/framework/update/f_updt_basic.bas\
	/qatesttool/framework/update/f_updt_basicorganizer.bas\
	/qatesttool/framework/update/f_updt_presentationwizard.bas\
	/qatesttool/framework/update/f_updt_documentconverter.bas\
	/qatesttool/framework/update/f_updt_euroconverter.bas\
	/qatesttool/framework/update/f_updt_wizard_webpage.bas\
	/qatesttool/framework/update/f_updt_scriptnames.bas\
	/qatesttool/framework/update/f_updt_autotext.bas\
	/qatesttool/framework/update/f_updt_customize.bas\
	/qatesttool/framework/update/f_updt_optionitems.bas\
	/qatesttool/framework/update/f_updt_windowfuncs.bas\
	/qatesttool/framework/update/f_updt_pkgmgr.bas\

")

echo "****************************************************"
echo "************ STARTING ************"
echo "****************************************************"

for x in $testList ;
do
    echo $x
done

# check if there is a virtual display available

 echo "DISPLAY is set to: " $DISPLAY
 echo "My name is: " $USER
 i=0

        for x in $testList ;
        do
                echo "Running soffices' prozesses: "
               # kill office, if exists
                  #killall -9 soffice.bin
                  pkill -9 soffice.bin
                ps -fe | grep $USER | grep "soffice.bin" | grep -v "grep"
        
                echo "****************************************************"
                echo "Will run: " $x

                sTest="$sLocation$x"
                for z in "1" "2" ;
                do
                        $sTestTool -run $sTest &
                        sleep 1
                        echo " "

                        ######### save the PID from the last BackGround job
                        testtoolpid=$!
                        echo "PID of Testtool: " $testtoolpid

                         if ps -p $testtoolpid > /dev/null ; then
                            echo " Sucksessfull started"
                         else
                            echo " There might be something wrong with starting the Testtool!"
                         fi

                        ######### wait until Testtool has finished & closed
                         while ps -p $testtoolpid > /dev/null ; 
                         do
                             sleep 2
                             i=$((i+2))
                         done

                         ####### for the second run use the office exit script!
                         sTest=$sExitOfficeBas
                done
        done

        echo "Duration:" $((i/60)) "min" $((i%60)) "sec " 

echo "****************************************************"
echo "************ FINISHED ************"
echo "****************************************************"
