'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: gallery2.inc,v $
'*
'*  $Revision: 1.43.2.3 $
'*
'*  last change: $Author: wg $ $Date: 2008/03/20 12:09:48 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : wolfram.garten@sun.com
'*
'* short description : Checking all gallery themes
'*
'*****************************************************************
'*
' #1 tLoad100GalleryGraphicFiles  'Inserting 100 gallery graphics and checking the sizes
' #1 tCheckAllGalleryGraphicFiles 'Checking the size ( > 0 Byte ) of all gallery-files.
' #1 tInsertGalleryObjects        'Inserting random objects via contextmenu-insert-copy.
' #0 LoadGraphic
' #0 CheckGraphic
' #0 makeNumOutOfText
' #1 tSettingsToCM 'Measurement unit for textdocuments to cm
' #1 tResetSettings 'Resetting the measurement unit for textdocuments.
'*
'\****************************************************************

testcase tLoad100GalleryGraphicFiles
    '/// Inserting all gallery graphics in a Writer document and checking the sizes.
    Dim lsFiles (3000) as String
    Dim lsGraphics (3000) as String
    Dim i as Integer
    Dim y as Integer
    Dim t as Integer
    Dim iCount as Integer
    Dim corLoad as Boolean
    Dim x as boolean

    '/// Geting all installed gallery objects out of the installation in a list.
    if gNetzInst = TRUE then
        GetAllFileList ( ConvertPath ( gNetzOfficePath + "share\gallery\" ), "*.*", lsFiles () )
    else
        GetAllFileList ( ConvertPath ( gOfficePath + "share\gallery\" ), "*.*", lsFiles () )
    end if
    call GetOnlyGraphics ( lsFiles (), lsGraphics() )
    iCount = ListCount ( lsGraphics() )
    printlog "   We have " + iCount + " graphics in the our gallery!"
    '/// + Open a new document
    call hNewDocument

    for i = 1 to 100
        for y = 1 to 1
            randomize
            t = Int((iCount*Rnd))
            if (t<1) then 'just so we get it between 1 and the amount of items.
                y = y - 1
            end if
        next y

        corLoad = FALSE
        try
            '/// <i>Loop begin</i>
            '/// + Inserting all gallery files and checking the sizes
            '/// +- Iinsert / graphic / from file
            '/// +- Check the size in 'format / graphics' on the <i>Type</i> tabpage
            '/// +-- The size should noz be smaler than 17*25cm / photos 21*25cm
            '///    + Deleting the graphic with &lt;delete&gt; of the keyboard
            '/// <i>Loop ends</i>
            x = LoadGraphic ( lsGraphics(t), corLoad )
            printlog
        catch
            ExceptLog
            if corLoad = FALSE then
                warnlog "Problems with " + lsGraphics(t)
                ResetApplication
                call hNewDocument
            end if
        endcatch
        if (not x) then
            printlog "   Tested nr: " + t + " : " + lsGraphics(t)
        end if
    next i

    '/// Close the gallery ///'
    ToolsGallery
    WaitSlot (2000)
    '/// Close the document ///'
    call hCloseDocument
endcase 'tLoadAllGalleryGraphicFiles

'-------------------------------------------------------------------------

testcase tCheckAllGalleryGraphicFiles
'/// Checking the filesize of all gallery graphics.
    Dim lsFiles (3000) as String
    Dim lsGraphics (3000) as String
    Dim i as Integer
    Dim y as Integer
    Dim t as Integer
    Dim iCount as Integer
    Dim corLoad as Boolean
    Dim x as boolean

    '/// Geting all installed gallery objects out of the installation in a list.
    if gNetzInst = TRUE then
        GetAllFileList ( ConvertPath ( gNetzOfficePath + "share\gallery\" ), "*.*", lsFiles () )
    else
        GetAllFileList ( ConvertPath ( gOfficePath + "share\gallery\" ), "*.*", lsFiles () )
    end if
    call GetOnlyGraphics ( lsFiles (), lsGraphics() )
    iCount = ListCount ( lsGraphics() )
    printlog "   We have " + iCount + " graphics in the our gallery!"
    '/// Open a new document
    call hNewDocument

    for i=1 to iCount
        corLoad = FALSE
        try
            '/// <i>Loop begin</i>
            '///+ Inserting all gallery files and checking the sizes
            '///+- Iinsert / graphic / from file
            '///+- Check the size in 'format / graphics' on the <i>Type</i> tabpage
            '///+-- The size should noz be smaler than 17*25cm / photos 21*25cm
            '///+ Deleting the graphic with &lt;delete&gt; of the keyboard
            '/// <i>Loop ends</i>
            x = CheckGraphic ( lsGraphics(i), corLoad )
        catch
            ExceptLog
            if corLoad = FALSE then
                warnlog "Problems with " + lsGraphics(i)
                ResetApplication
                call hNewDocument
            end if
        endcatch
        if (not x) then
            printlog "   Tested nr: " + i + " : " + lsGraphics(i)
        end if
    next i
    '/// Close the gallery ///'
    ToolsGallery
    WaitSlot (2000)
    '/// Close the document ///'
    call hCloseDocument
endcase 'tLoadAllGalleryGraphicFiles

'-------------------------------------------------------------------------

testcase tInsertGalleryObjects
    Dim lsFiles (3000) as String
    Dim lsGraphics (3000) as String
    Dim CountOfThemes
    Dim HowManyItems as Integer
    Dim WhichOne as Integer
    Dim CountOfItems as Integer
    Dim ct as Integer
    Dim i as Integer
    Dim d as Integer
    Dim iCount as Integer
    Dim corLoad, x as Boolean

    '/// 1. Select theme ///'
    Call hNewDocument
    call hOpenGallery
    kontext "Gallery"
        CountOfThemes = Gallerys.GetItemCount
        for ct = 27 to CountOfThemes
            Gallerys.Select ct
            printlog "   Selected Gallery-Theme nr: " + ct + ": " + Gallerys.GetSelText
            kontext "Gallery"
                CountOfItems = View.GetItemCount()
                '/// 2. Choose if we should test 3,4 or 5 objects. ///'
                for d = 1 to 1
                    randomize
                    HowManyItems=Int((5*Rnd)+(3*Rnd))
                    if CountOfItems = 0 then
                        QaErrorLog "   There were no objects in the the gallery-theme on position: " + ct
                    else
                        if (HowManyItems<3) then 'just so we get it between 3 and 5.
                            d = d - 1
                        else
                            printlog "   Will now select and copy " + HowManyItems + " items from this Theme."
                        end if
                        for i = 1 to HowManyItems
                            '/// 3. Select the objects ///'
                            for x = 1 to 1
                                randomize
                                WhichOne=Int(CountOfItems*RND) '(5*Rnd)+(CountOfItems*Rnd))
                                if (WhichOne<1) then 'just so we get it between 1 and the amount of items.  '>(CountOfItems + 1)) OR (WhichOne<1) then '
                                    x = x - 1
                                end if
                            next x
                            printlog "   Will copy object nr: " + WhichOne
                            View.Mousemove (1,1)
                            View.TypeKeys "<HOME>"
                            View.TypeKeys "<RIGHT>", (WhichOne)
                            kontext "GraphicObjectBar"
                                if GraphicObjectBar.Exists then
                                    if GraphicObjectBar.IsDocked = False then GraphicObjectBar.Dock
                                end if
                            kontext "Gallery"
                                sleep (1)
                                View.TypeKeys("<shift f10>")
                                sleep (1)
                                try
                                    dim number as integer
                                    number = MenuGetItemCount
                                    if (number > 2) AND (number < 10) then
                                        '/// 4. Copy the selected item into our document. ///'
                                        hMenuSelectNr (1) 'Insert
                                        hMenuSelectNr (1) 'As Copy
                                        sleep (1)
                                    else
                                        Warnlog "   The contextmenu came up, but the number of entries were strange."
                                        printlog "   Number of entries:" + number
                                        MenuSelect(0)
                                    end if
                                catch
                                    warnlog "   A contextmenu didnt come up for the gallery-theme on position: " + ct
                                    i = HowManyItems
                                endcatch
                            '/// 5. Repeat 3.-5. until 2. is fulfilled. ///'
                        next i
                    end if 'if the theme didnt have any objects, we landed here.
        next d
        '/// 6. Change Theme. ///'
        '/// 7. Repeat 2. - 8. until all themes are done. ///'
    next ct

    Kontext "Gallery"
        if Gallery.Exists(2) then
            ToolsGallery
            WaitSlot (2000)
        end if

    '/// Remove the last copied object. ///'
    hTypeKeys "<DELETE>"
    call hCloseDocument
endcase 'tInsertGalleryObjects

'-------------------------------------------------------------------------

