'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: t_spreadsheet_tools1.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: oc $ $Date: 2007/07/09 07:38:31 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/***********************************************************************
'*
'* owner : oliver.craemer@sun.com
'*
'* short description : Global tools for spreadsheet
'*
'************************************************************************
'*
' #1 fGotoCell     ' Set active cell in a spreadhseet to a defined cell adress
' 
'*
'\***********************************************************************

function fGotoCell (sCelladdress as String) as integer
'/// The function sets the active cell in a spreadsheet to a defined cell address.
'/// Input: sCelladdress as String
'/// Output: <ul><li>0 = active cell has changed successfully</li>
'///+ <li>1 = active cell hasn't changed</li> 

    Dim sActualPlace as string

    const CFN = "qa:qatesttool:global:tools:inc:t_spreadsheet_tools1.inc:fGotoCell: "
    
    'function will return 1 if something goes wrong
    fGotoCell = 1
    Kontext "RechenleisteCalc"
    '/// If the spreadsheet <i>formula toolbar</i> isn't available make them
    '/// + available with View / Toolbars / Formula Bar 
    if NOT RechenleisteCalc.Exists(1) then    
        ViewToolbarsFormulaBar
    end if
    try
        Kontext "RechenleisteCalc"
        sActualPlace = AktiverZellbereich.GetSelText
        if UCase(sActualPlace) = UCase(sCelladdress) then
            fGotocell = 0            
            exit function
        else
            sActualPlace = ""
            '/// Type the cell address into the <i>name box</i>            
            AktiverZellbereich.SetText sCelladdress
            '///+ and press RETURN
            AktiverZellbereich.TypeKeys "<RETURN>"
            sleep(1)        
            '/// If the <i>name box<i>' address has been changed to the expected
            '///+ cell address the function was successfull.
            sActualPlace = AktiverZellbereich.GetSelText
            if UCase(sActualPlace) = UCase(sCelladdress) then
                fGotocell = 0
            else
                warnlog CFN & "The cell address has not been changed!"
            end if
        end if
    catch
        warnlog CFN & "Something unexpected happened! The cell address has not been changed!"
        fGotocell = 1
    endcatch
end function

