'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: t_proxy_info.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: jsk $ $Date: 2006/08/22 08:49:08 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Tools to retrieve auxilary environment information
'*
'*******************************************************************************
'**
' #1 hGetProxyInfo ' Retrieve the names and ports of the proxies
' #0 hPrintProxyInstructions ' print instructions to the log
'**
'\******************************************************************************

function hGetProxyInfo( sSection as string, sItem as string ) as string


    '///<h3>Retrieve the names and ports of the proxies</h3>
    '///<i>This function retrieves the names and ports of the proxies used
    '///+ in your local network. The data is taken from a textfile that is
    '///+ not visible on OpenOffice.org (Sun security policy)<br>
    '///+ If the file is not found a message is printed to the log that
    '///+ gives instructions on how to create and format such a file and
    '///+ what other steps must be taken to make this work for your local
    '///+ network (don't panic, it's simple!).</i><br><br>

    '///<u>Input values:</u><br>
    '///<ol>

    '///+<li>Section (string). Valid options:</li>
    '///<ul>
    '///+<li>&quot;http_proxy&quot;</li>
    '///+<li>&quot;ftp_proxy&quot;</li>
    '///+<li>&quot;socks_proxy&quot;</li>
    '///+<li>&quot;no_proxy_for&quot;</li>
    '///</ul>
    
    '///+<li>Item (string). Valid options:</li>
    '///<ul>
    '///+<li>&quot;Name&quot;</li>
    '///+<li>&quot;Port&quot; (not for &quot;no_proxy_for&quot)</li>
    '///</ul>    

    '///</ol>


    '///<u>Return Value:</u><br>
    '///<ol>
    '///+<li>Name or port of an item (string)</li>
    '///<ul>
    '///+<li>Empty String on error</li>
    '///</ul>
    '///</ol>

    const CFN = "hGetProxyInfo::"

    dim irc as integer ' some integer returnvalue
    dim crc as string  ' some string returnvalue
        
    ' This is the workfile. Make sure it exists and contains valid data
    dim cFile as string
        cFile = gTesttoolPath & "sun_global\input\proxies.txt"
        ' cFile = gTesttoolPath & "global\input\proxies.txt"
        cFile = convertpath ( cFile )
       
    ' this is a temporary list that holds the workfile 
    dim acList( 50 ) as string

    '///<u>Description:</u>
    '///<ul>
    '///+<li>Open the file, read the section, abort on error</li>
    irc = hGetDataFileSection( cFile, acList(), sSection , "" , "" )
    if ( irc = 0 ) then
        qaerrorlog( CFN & "File or section not found" )
        hGetProxyInfo() = ""
        hPrintProxyInstructions()
        exit function
    endif
    
    '///+<li>Isolate the key</li>
    crc = hGetValueForKeyAsString( acList(), sItem )
    if ( instr( crc , "Error:" ) > 0 ) then
        qaerrorlog( CFN & "The requested item could not be found" )
        hGetProxyInfo() = ""
        hPrintProxyInstructions()
        exit function
    endif
    
    '///+<li>Return the requested item</li>
    
    '///</ul>

    hGetProxyInfo() = crc 

end function

'*******************************************************************************

function hPrintProxyInstructions()

    printlog( "" )
    printlog( "How to configure proxy settings for your local network" )
    printlog( "" )
    printlog( "1. Edit the sample configuration file" )
    printlog( "   Location: global/input/proxies.txt" )
    printlog( "   Replace servernames and ports with valid entries" )
    printlog( "" )
    printlog( "2. Edit the function hGetProxyInfo" )
    printlog( "   Make the first line with cFile = ... a comment"
    printlog( "   Make the second line with cFile = ... active"
    printlog( "   Save the file" )
    printlog( "" )
   
end function
