'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: t_doc2.inc,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: jsi $ $Date: 2007/06/01 06:41:45 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : Global Routines for Document Handling; Part two
'*
'************************************************************************
' #1 hTabelleEinfuegen
' #1 ZellenMarkieren
' #1 hRechteckErstellen
' #1 hTextrahmenErstellen
' #1 SchreibenInMathdok
' #1 sMakeReadOnlyDocumentEditable
' #1 fSelectFirstOLE                'Selecting the first OLE object
'\***********************************************************************

sub hTabelleEinfuegen
'/// <b>WRITER only </b>///'
'///  hTabelleEinfuegen hInsertTable ///'
'/// insert a dummy table in writer/writerweb/masterdocument ///'
   TableInsertTable
   sleep(2)
   Kontext "TabelleEinfuegenWriter"
   wait 500
   TabelleEinfuegenWriter.OK
   sleep(1)

   Kontext "TableObjectbar"
   sleep(1)
   if TableObjectbar.NotExists then
      Kontext "TextObjectbar"
      TextObjectbar.SetNextToolBox
   end if

   Select Case gApplication
      Case "WRITER"
         Kontext "DocumentWriter"
      Case "MASTERDOC"
         Kontext "DocumentMasterDoc"
      Case "HTMLDOKUMENT"
         Kontext "DocumentWriterWeb"
   end select
   sleep(1)
end sub

'-------------------------------------------------------------------------

sub ZellenMarkieren ( Down%, Right% )
'/// <b>CALC only</b> ///'
'/// ZellenMarkieren ( Down%, Right% ) : mark the cells ///'
   Dim Anzahl as Integer

   Kontext "DocumentCalc"
   Anzahl = Right% - 1
   DocumentCalc.TypeKeys "<Shift Right>", Anzahl
   Anzahl = Down% - 1
   DocumentCalc.TypeKeys "<Shift Down>", Anzahl
end sub

'-------------------------------------------------------------------------

sub hRechteckErstellen ( BeginX%, BeginY%, EndX%, EndY% )
'/// <b>IMPRESS/DRAW only</b> ///'
'/// hRechteckErstellen ( BeginX, BeginY, EndX, EndY ) : create a rectangle ///'
   WL_DRAW_Rechteck
   gMouseMove ( BeginX%, BeginY%, EndX%, EndY% )
end sub

'-------------------------------------------------------------------------

sub hTextrahmenErstellen ( TextEingabe$, BeginX%, BeginY%, EndX%, EndY% )
'/// <b>IMPRESS/DRAW only</b> ///'
'/// hTextrahmenErstellen ( String, BeginX, BeginY, EndX, EndY ) : create a textbox with a textstring ///'
   WL_SD_TextEinfuegenDraw
   gMouseMove ( BeginX%, BeginY%, EndX%, EndY% )
   hTypeKeys TextEingabe$
end sub

'-------------------------------------------------------------------------

sub SchreibenInMathdok ( Eingabe as String )
'/// <b>MATH only</b> ///'
'/// SchreibenInMathDok ( String ) : write text in a mathdocument ( with clipboard ) ///'
   if Eingabe <> "Unsinn" then
      SetClipboard Eingabe
   else
      SetClipboard "NROOT <?> <?><over b==<?>"
   endif
   if (GetClipboard() <> Eingabe) then
      warnlog "--No Clipboard available :-(--"
      printlog "---ClipTest--- should: "+Eingabe +", is: "+GetClipboard
   endif
   EditPaste
   sleep(3)
end sub

'-------------------------------------------------------------------------

sub sMakeReadOnlyDocumentEditable
    If IsItLoaded() then
        '/// After the document has been loaded...
        Kontext "Standardbar"
        if Bearbeiten.IsEnabled then
            '/// ...check if the button is enabled. 
            if Bearbeiten.getState(2) = 0 then                
                '/// Check if the document has been loaded read-only and if yes    
                Bearbeiten.Click()
                '/// click on the 'Edit'-button
                sleep (2)
                Kontext
                if Active.Exists(5) then
                    '/// If there is a messagebox coming up, click on Yes/OK
                    Active.Yes
                end if
                sleep (2)        
                Kontext
                if Active.Exists(1) then
                    ' Sometimes an messagebox will be opened that the file does
                    ' not exists. 
                    QAErrorLog Active.GetText
                    Active.OK
                end if
                sleep (2)
            end if
        else
            printlog "Document opened with write access."
        end if
    else
        warnlog "The document has not been loaded correctly."
    end if
end sub
'
'-------------------------------------------------------------------------------
'
function fSelectFirstOLE() as integer
'Select first visible OLE object using Navigator
'Returns error-code:
'+ 0 := Sucess
'- 1 := unknown application

    dim bNavigatorWasVisible as boolean
        bNavigatorWasVisible = FALSE
    dim iIndex

    fSelectFirstOLE = -1
    
    select case lcase(gApplication)
        case "calc"                     :   Kontext "NavigatorCalc"
                                            'First check if Navigator is visible and remember result
                                            if NavigatorCalc.exists (10) then
                                                bNavigatorWasVisible = TRUE
                                            else
                                                try
                                                    'Invoke Navigator if not visible
                                                    EditNavigator
                                                catch
                                                    'If inside chart or elsewhere the call
                                                    'will fail. Again trying the slot after
                                                    'switching to the document.
                                                    Kontext "DocumentCalc"
                                                    DocumentCalc.TypeKeys "<Escape>"
                                                    EditNavigator
                                                endcatch
                                            end if
                                            Kontext "NavigatorCalc"
                                            if NavigatorCalc.exists (10) then
                                                'Select first OLE in list
                                                Liste.TypeKeys "<HOME>"
                                                for iIndex = 1 to 8
                                                    Liste.TypeKeys "-<DOWN>"
                                                next iIndex
                                                Liste.select(6)
                                                Liste.TypeKeys "+<DOWN><RETURN>"
                                                fSelectFirstOLE = 0
                                            else
                                                QAErrorLog "Navigator did not occoured!"
                                            end if
        case "draw" , "impress"         :   Kontext "NavigatorDraw"
                                            if NavigatorDraw.Exists(10) then
                                                bNavigatorWasVisible = TRUE
                                            else
                                                try
                                                    'Invoke Navigator if not visible
                                                    EditNavigator
                                                catch
                                                    'If inside chart or elsewhere the call
                                                    'will fail. Again trying the slot after
                                                    'switching to the document.
                                                    Kontext "DocumentDraw"
                                                    DocumentDraw.TypeKeys "<Escape>"
                                                    EditNavigator
                                                endcatch
                                                Kontext "NavigatorDraw"
                                                if NavigatorDraw.exists(10) then
                                                    'Select first OLE in list
                                                    Liste.TypeKeys "<HOME>"
                                                    Liste.select(1)
                                                    Liste.TypeKeys "+<DOWN><RETURN>"
                                                    fSelectFirstOLE = 0                                                
                                                else
                                                    QAErrorLog "Navigator did not occoured!"
                                                end if
                                            end if
                                                
        case "writer" , "htmldokument" , "masterdoc" :
                                            select case lcase(gApplication)
                                                case "masterdoc"    :   Kontext "NavigatorGlobalDoc"                                                                                  
                                                                        if NavigatorGlobalDoc.Exists(10) then 
                                                                            bNavigatorWasVisible = TRUE                                                                            
                                                                        else
                                                                            EditNavigator
                                                                        end if
                                                                        wait 500
                                                                        Kontext "NavigatorGlobalDoc"
                                                                        if Liste.IsVisible then
                                                                            Kontext "GlobaldokumentToolbox"
                                                                            Umschalten.Click                                                                            
                                                                        endif                                                                        
                                                case else           :   Kontext "NavigatorWriter"
                                                                        'First check if Navigator is visible and remember result
                                                                        if NavigatorWriter.Exists (10) then
                                                                            bNavigatorWasVisible = TRUE
                                                                        else
                                                                            try
                                                                                'Invoke Navigator if not visible                                                
                                                                                EditNavigator
                                                                            catch
                                                                                'If inside chart or elsewhere the call
                                                                                'will fail. Again trying the slot after
                                                                                'switching to the document.                                                
                                                                                Kontext "DocumentWriter"
                                                                                call gMouseclick (99,99) 
                                                                                call gMouseclick (50,50)
                                                                                EditNavigator
                                                                            endcatch
                                                                        end if   
                                            end select
                                            Kontext "NavigatorWriter"
                                            if NavigatorWriter.Exists(10) then
                                                'Select first OLE in list
                                                Auswahlliste.TypeKeys "<HOME>"
                                                for iIndex = 1 to 13
                                                    Auswahlliste.TypeKeys "-<DOWN>"
                                                next iIndex
                                                Auswahlliste.select(5)
                                                Auswahlliste.TypeKeys "+<DOWN><RETURN>"
                                                fSelectFirstOLE = 0
                                            else
                                                QAErrorLog "Navigator did not occoured!"
                                            end if
        case else                       :   QAErrorLog "Application not supported"                                            
    end select                        
    
    'Close navigator if it was invisible by entering the routine
    if bNavigatorWasVisible = TRUE then
        printlog "Leaving navigator open as initially found"
    else
        if fSelectFirstOLE = 0 then
            EditNavigator
            printlog "Closing navigator as initially found"
        else
            printlog "Closing navigator not needed. It was not possible to open it."
        end if
    end if    
end function
