'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: performance.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: jsk $ $Date: 2008/02/14 13:14:52 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2006 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Tools to speed up test case performance
'*
'*******************************************************************************
'**
' #1 hWaitForObject ' Wait for any object for a specified time
'**
'\******************************************************************************

function hWaitForObject( oControl as object, iTime as integer ) as integer


    '///<h3>Wait for a control to get ready</h3>
    '///<i>Wait for a control on a toolbar to get ready for a specified amount 
    '///+ of time. Note that this function runs silent, you have to test the 
    '///+ return value!</i><br><br>

    '///<u>Parameter(s):</u><br>
    '///<ol>

    '///+<li>The control to wait for (Object)</li>
    '///<ul>
    '///+<li>Kontext must be set prior to using this function</li>
    '///+<li>The control must exist</li>
    '///+<li>This function works on most, but not all, controls</li>
    '///</ul>

    '///+<li>Maximum time to wait in milliseconds (Integer)</li>
    '///<ul>
    '///+<li>Must be &gt; 0</li>
    '///+<li>Must be &le; 10000 ms (10 seconds)</li>
    '///</ul>

    '///</ol>


    '///<u>Returns:</u><br>
    '///<ol>
    '///+<li>Time to readiness in milliseconds(Integer)</li>
    '///<ul>
    '///+<li>-1: Control not ready within given timeframe</li>
    '///+<li>-2: Control appears not to exist</li>
    '///+<li>-&ge; 0: Time to readiness </li>
    '///</ul>
    '///</ol>

    const MAX_WAIT = 10000
    const CFN = "hWaitForObject::"
    
    dim _time as integer
    dim _loop as integer
    

    '///<u>Description:</u>
    '///<ul>
    '///+<li>Verify function parameter validity</li>
    if ( iTime > MAX_WAIT or iTime < 1 ) then
        _time = MAX_WAIT
    else
        _time = iTime 
    endif

    '///+<li>Verify that the control exists and wait</li>
    _loop = 0
    if ( oControl.exists() ) then
        do while( not oControl.isEnabled() )
            _loop = _loop + 1
            wait( 1 )
            if ( _loop = MAX_WAIT ) then
                qaerrorlog( CFN & "Timeout reached. Exiting." )
                hWaitForObject() = -1
                exit function
            endif
        loop
        
        ' We get here when all went well.
        printlog( CFN & "Object was enabled within " & _loop & " milliseconds" )
        hWaitForObject() = _loop
        
    else
        ' This message might appear but can - under certain conditions - be 
        ' incorrect. Some toolbars simply do not react to the .exists() method.
        printlog( CFN & "Non existing control. Exiting." )
        hWaitForObject() = -2
        exit function
    endif
    '///</ul>


end function







