'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_tools.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: jsk $ $Date: 2006/10/31 16:47:29 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2006 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Special tasks on filedialogs
'*
'*******************************************************************************
'**
' #1 hFileOpenMultiSelect ' Multiselect files with the fileopen dialog
'**
'\******************************************************************************

function hFileOpenMultiSelect( iArray() as integer ) as integer


    '///<h3>Multiselect files with the fileopen dialog</h3>
    '///<i>This function uses keyboard navigation to select a number of files
    '///+ (multiselection).</i><br>
    '///<u>Starting point</u>: FileOpen dialog has context, workdirectory is 
    '///+ open<br><br>

    '///<u>Input value(s):</u><br>
    '///<ol>
    '///+<li>Array (integer)</li>
    '///<ul>
    '///+<li>if ( array( n ) = 1 ) select the file at pos n, starting at n = 1</li>
    '///+<li>Any other value: Do not select, preferably preset with 0!</li>
    '///+<li>The size of the array must less or equal the number of files in the filepicker<br>
    '///+ Array( 0 ) is ignored</li>
    '///</ul>
    '///</ol>

    '///<u>Return Value:</u><br>
    '///<ol>
    '///+<li>Number of selected files (integer)</li>
    '///<ul>
    '///+<li>= 0: any error</li>
    '///+<li>&gt; 0: Number of selected files (Sum of Array( n ) = 1)</li>
    '///</ul>
    '///</ol>

    const CFN = "hFileOpenMultiSelect::"
    dim brc as boolean 'a multi purpose boolean returnvalue
    
    dim iArraySize as integer
    dim iCurrentFile as integer
    dim cCurrentFile as string
    dim iSelectedFilesCount as integer
        iSelectedFilesCount = 0

    '///<u>Description:</u>
    '///<ul>
    '///+<li>Get the size of the array</li>
    iArraySize = ubound( iArray() )
    
    '///+<li>Get the number of items from the filepicker</li>
    kontext "OeffnenDlg"
    iFileCount = Dateiauswahl.getItemCount()
    
    '///+<li>Verify that the array size is equal or less the number of files<br>
    '///+ Exit with rc = 0 on error</li>
    ' Note: This can be done because it is quite simply expected that we know the
    '       number of files within the workdirectory. Take one input-dir.
    if ( iFileCount < iArraySize ) then
        qaerrorlog( CFN & "Array too large. Array must be <= file count" )
        printlog( CFN & "Files present in dialog: " & iFileCount )
        printlog( CFN & "Arraysize..............: " & iArraySize )
        hFileOpenMultiSelect() = 0
        exit function
    endif

    '///+<li>Select the first object in the filelist</li>
    kontext "OeffnenDlg"
    DateiAuswahl.typeKeys( "<HOME>" )
    
    '///+<li>Run through the filelist and select all items that are marked in the array</li>
    '///<ul>
    for iCurrentFile = 1 to iArraySize

        '///+<li>Select a file with CTRL+SPACE</li>
        if ( iArray( iCurrentFile ) = 1 ) then
            DateiAuswahl.typeKeys( "<MOD1 SPACE>" )
            cCurrentFile = DateiAuswahl.getSelText() ' does this work?
            printlog( CFN & "Select: " & cCurrentFile & " at pos: " & iCurrentFile )
            iSelectedFilesCount = iSelectedFilesCount + 1
        endif
    
        '///+<li>Move one down with CTRL key pressed</li>
        DateiAuswahl.typekeys( "<MOD1 DOWN>" )
        
    next iCurrentFile
    '///</ul>
    '///</ul>
    hFileOpenMultiSelect() = 0

end function
