'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: arrayfuncs.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/05 13:06:43 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : misc functions for simpler listhandling. uses t_lists.inc
'*
'*******************************************************************************
' **
' #0 listdebug         ' print the content of a list wit optional comment
' #0 initlistdebug     ' helper for debugging lists to logfiles
' #0 listmoveitem      ' move listitem from a to b updating both lists
' #0 listconvertpath   ' execute convertpath on a list
' #0 listInsertSection ' create a list that has a section -> hGetDataFileSection
' **
'\******************************************************************************

function listdebug( lsList() as string , cComment as string ) as integer

   '///<h3>Write the content of a list plus a comment out to a file.</h3>
   '///<i>It is required that following global variables are defined</i>
   '///<ul>
   '///+<li>LDN = ListDebugName (char) = the basename of the debugfiles</li>
   '///+<li>LDC = ListDebugCounter (int) = a number added to the filename</li>
   '///</ul>

   dim cFile as string

       LDC = LDC + 1
       cFile = LDN & LDC & ".log"

   dim sList( 5 ) as string
   sList( 0 ) = "5"
   sList( 1 ) = ""
   sList( 2 ) = "---------------------------------------------------------------"
   sList( 3 ) = cComment & " - Listsize: " & listcount( lsList() )
   sList( 4 ) = "---------------------------------------------------------------"
   sList( 5 ) = ""

   ListWrite( sList() , cFile , "utf8" )
   ListWriteAppend( lsList() , cFile , "utf8" )

end function

'*******************************************************************************

function initlistdebug( cComment as string ) as integer

    '///<h3>Print leading text to a file and an index of the current debug session</h3>
    '///<i>It is required that following global variables are defined</i>
    '///<ul>
    '///+<li>LDN = ListDebugName (char) = the basename of the debugfiles</li>
    '///+<li>LDC = ListDebugCounter (int) = a number added to the filename</li>
    '///</ul>
    dim cFile as string
        cFile = LDN & ".log"

    dim sList( 5 ) as string
    sList( 0 ) = "5"
    sList( 1 ) = ""
    sList( 2 ) = "==============================================================="
    sList( 3 ) = cComment & " ---- Debug-Offset is at: " & LDC
    sList( 4 ) = "==============================================================="
    sList( 5 ) = ""

    ListWrite( sList() , cFile , "utf8" )

    printlog( "" )
    printlog( " *** Debug is enabled ***" )
    printlog( "" )

end function

'*******************************************************************************

function listmoveitem( source() as string, _
                       target() as string, _
                       itemid as integer ) as integer
                       
    '///<h3>Move one item from one list to another by index</h3>                       
    '///<ul>

    '///+<li>copy the list-item from list A to the end of list B, update listcount</li>
    listappend( target() , source( itemid ) )
    
    '///+<li>Delete the entry from the old list, reindex and update listcount</li>
    listdelete( source() , itemid )
    
    '///+<li>Return then updated listcount of the <i>source</i> list</li>
    listmoveitem() = listcount( source() )
    
    '///</ul>

end function

'*******************************************************************************

function listconvertpath( lsList() as string ) as integer

    '///<h3>Execute <i>convertpath</i> on a list containing filepaths</h3>
    '///<ul>

    dim iCurrentPath as integer

    '///+<li>Convert all listitems with <i>convertpath</i></li>
    for iCurrentPath = 1 to listcount( lsList() )
        lsList( iCurrentPath ) = convertpath( lsList( iCurrentPath ) )
    next iCurrentPath

    '///+<li>Return the number of processed paths (listcount)</li>
    listconvertpath() = listcount( lsList() )
   
    '///</ul>

end function

'*******************************************************************************

function listInsertSection( lsList() as string, _
                            cSection as string ) as integer
                            
    '///<h3>Appends a section (as ordinary list element) to a list</h3>
    '///<ul>
                            
    dim iPos as integer
    dim sSectionString as string
    
    '///+<li>Get the current number of entries from the list</li>
    iPos = listcount( lsList() )
    
    '///+<li>Insert a blank list-entry if we are not at the beginning of the list</li>
    if ( iPos > 2 ) then
        listappend( lsList() , "" )
    end if                            
    
    '///+<li>Build the section string of type [section-name]</li>
    sSectionString = "[" & cSection & "]"
    
    '///+<li>Append the new section to the list</li>
    listappend( lsList() , sSectionString )
    
    '///+<li>Return the new number of entries in the list (listcount)</li>
    listInsertSection() = listcount( lsList() )
    
    '///</ul>

end function   
