'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_sec_trusted_path.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: jsk $ $Date: 2007/04/18 08:38:13 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Execute macros from trusted path
'*
'*******************************************************************************
'**
' #1 tSecTrustedPath ' Execute macros from trusted path
'**
'\******************************************************************************

testcase tSecTrustedPath( cWorkFile as string, iSecLevel as integer )

    use "framework\tools\inc\stringtools.inc"

    '///<h1>Execute macros from a trusted path</h1>
    '///<i>This testcase takes parameters and requires a number of settings
    '///+ to run. See the calling .bas-file for details. <br>
    '///+ Furthermore a number of
    '///+ workfiles are used that have a documentbound macro as payload which is 
    '///+ executed at the &quot;On document load&quot; event.<br>
    '///<ul>

    dim brc as boolean
    dim cMsg as string

    '///+<li>Click &quot;FileOpen&quot; or go to the dialog via menu</li>
    '///+<li>Enter the path to a file with macros within the trusted path</li>
    '///+<li>Open the file</li>
    hLoadFile( cWorkFile )
    
    ' We have quite a bunch of possible combinations here. Some trigger a security warning
    ' others do not. Files within a trusted path should never prompt.
    
    '         |---------------------------------------------------------|
    '         | Trusted |     Security Level / Warning displayed        |
    '         |  Path   |   Low     |  Medium   |   High    | Very High |
    '         |---------------------------------------------------------|
    '         |  Yes    |     No    |    No     |     No    |    No     |
    '         |---------------------------------------------------------|
    '         |   No*)  |     No    |    Yes    |  Blocked  |  Blocked  |
    '         |---------------------------------------------------------|
    ' *) Covered by test "f_sec_macrosecurity.bas"
       

    '///+<li>Test for security-warning, warn if it pops up</li>
    brc = hAllowMacroExecution()
    if ( brc ) then
        warnlog( "Macro Security Warning was not expected at this point" )
    endif

    '///+<li>Verify that the macro is executed</li>
    printlog( "Verify that the macro is executed" )
    kontext "Active"
    if ( active.exists() ) then
        cMsg = active.getText()
        cMsg = hRemoveLineBreaks( cMsg )
        if ( cMsg = "TTMacro3" ) then
            printlog( "Macro was executed" )
        else
            warnlog( "Invalid messagebox is open, please check" )
        endif

        '///+<li>Close the macro</li>
        active.ok()

    endif

    '///+<li>Close the document</li>
    hDestroyDocument()

    '///</ul>


endcase

