'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_readonly_cb.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: jsk $ $Date: 2007/07/26 13:22:00 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( 1. part )
'*
'************************************************************************
'**
' #1 tFiledlgReadOnly_cb ' Load files read-only (checkbox on File-Open dialog)
'**
'\***************************************************************************

testcase tFiledlgReadOnly_cb

    '///<h1>Load files read-only (checkbox on File-Open dialog)</h1>
    '///<ul>
    '///+<li>Open the File-Opendialog by clicking on the item on the standardbar</li>
    '///+<li>Navigate to the test directory : [TesttoolPath]\framework\filedlg\input\readonly</li>

    dim BASEPATH as string
        BASEPATH = gTesttoolPath + "framework\filedlg\input\alldocs\"
        
    const FORMAT_COUNT = 15
    dim caFile( FORMAT_COUNT ) as string
    dim caType( FORMAT_COUNT ) as string
    dim iaID  ( FORMAT_COUNT ) as integer
    dim iCurrentFormat as integer
    dim cCurrentFormat as string
    dim brc as boolean
    
    'OpenOffice.org 1.x formats
    caFile(  1 ) = BASEPATH & "fdlg.sxw" : iaID(  1 ) = 1 : caType(  1 ) = "OpenOffice.org 1.x Writer"
    caFile(  2 ) = BASEPATH & "fdlg.sxc" : iaID(  2 ) = 2 : caType(  2 ) = "OpenOffice.org 1.x Calc"
    caFile(  3 ) = BASEPATH & "fdlg.sxi" : iaID(  3 ) = 3 : caType(  3 ) = "OpenOffice.org 1.x Impress"
    caFile(  4 ) = BASEPATH & "fdlg.sxd" : iaID(  4 ) = 4 : caType(  4 ) = "OpenOffice.org 1.x Draw"
    caFile(  5 ) = BASEPATH & "fdlg.sxm" : iaID(  5 ) = 6 : caType(  5 ) = "OpenOffice.org 1.x Math"
    caFile(  6 ) = BASEPATH & "fdlg.sxg" : iaID(  6 ) = 1 : caType(  6 ) = "OpenOffice.org 1.x Global Document"
    
    'StarOffice 5.x formats
    caFile(  7 ) = BASEPATH & "erwin.sdw"   : iaID(  7 ) = 1 : caType(  7 ) = "StarOffice 5.x Writer"
    caFile(  8 ) = BASEPATH & "bereich.sdc" : iaID(  8 ) = 2 : caType(  8 ) = "StarOffice 5.x Calc"
    caFile(  9 ) = BASEPATH & "schach.sdd"  : iaID(  9 ) = 3 : caType(  9 ) = "StarOffice 5.x Impress"
    caFile( 10 ) = BASEPATH & "aendern.sda" : iaID( 10 ) = 4 : caType( 10 ) = "StarOffice 5.x Draw"
    caFile( 11 ) = BASEPATH & "ffortpf.smf" : iaID( 11 ) = 6 : caType( 11 ) = "StarOffice 5.x Formula"
    
    ' Graphics formats    
    caFile( 12 ) = BASEPATH & "columbia.dxf" : iaID( 12 ) = 4 : caType( 12 ) = "Drawing Exchange Format (DXF)"
    caFile( 13 ) = BASEPATH & "borabora.jpg" : iaID( 13 ) = 4 : caType( 13 ) = "Joint Picture Experts Group (JPEG/JPG)"
    
    ' Web formats
    caFile( 14 ) = BASEPATH & "body.htm"  : iaID( 14 ) = 1 : caType( 14 ) = "HTML (htm)"
    caFile( 15 ) = BASEPATH & "fdlg.html" : iaID( 15 ) = 1 : caType( 15 ) = "HTML (html)"


    printlog "Load files read-only (checkbox on File-Open dialog)"
    
    '///+<li>Open a Writer-File</li>
    '///+<li>Open a Calc-File</li>
    '///+<li>Open a Impress-File</li>
    '///+<li>Open a Draw-File</li>
    '///+<li>Open a Math-File</li>
    '///+<li>Open a Master-Document-File</li>
    '///+<li>Open an Image-File ( JPG )</li>
    '///+<li>Open an Image-File ( DXF )</li>
    '///+<li>Open a Writer-File ( 5.2 )</li>
    '///+<li>Open a Calc-File ( 5.2 )</li>
    '///+<li>Open a Impress-File ( 5.2 )</li>
    '///+<li>Open a Draw-File ( 5.2 )
    '///+<li>Open a Math-File ( 5.2 )</li>
    '///+<li>Open a HTML-File ( with extension 'htm' )</li>
    '///+<li>Open a HTML-File ( with extension 'html' )
    
    for iCurrentFormat = 1 to FORMAT_COUNT

        cCurrentFormat = ConvertPath ( caFile( iCurrentFormat ) )
        printlog ( "Open: " & caType( iCurrentFormat ) & ":" & cCurrentFormat )
    
        select case iCurrentFormat
        case 9 : qaerrorlog( "#i65703# - excluding SDD file" )
        case else
        
            brc = LoadDocumentReadOnly ( cCurrentFormat, iaID() , TRUE )
            if ( brc ) then
                hDestroyDocument()
            else
                printlog( "LoadDocumentReadOnly returned a bad status" )
            endif
        end select

    next iCurrentFormat
    '///</ul>


endcase


