'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_passwords.inc,v $
'*
'*  $Revision: 1.15 $
'*
'*  last change: $Author: jsk $ $Date: 2007/12/10 13:26:48 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : save and load passworded files
'*
'*******************************************************************************
'**
' #1 tFiledlgPasswords ' save and load passworded files
'**
'\******************************************************************************

testcase tFiledlgPasswords( filetypeID as string )

    '///<h1>Test saving/loading passworded files in three different formats</h1>

    dim workfile as string
        workfile = "password" & hGetSuffix( filetypeID )
        printlog( "Name of workfile: " & workfile )

    dim workpath as string
        workpath = hGetWorkPath()
        printlog( "Save file to....: " & workpath )

    dim filetype as string
        filetype = hGetFilter( filetypeID )
        printlog( "Using fileformat: " & filetype )
        
        printlog( "" )

    dim cMsg as string

    '///<ul>
    '///+<li>open a new document</li>
    hCreateDocument()
    
    '///+<li>Close the navigator - if present</li>
    hCloseNavigator()

    '///+<li>enter some random text</li>
    call hChangeDoc()

    '///+<li>Open file-save dialog</li>
    printlog( "Open file-save dialog" )
    if ( gApplication = "IMPRESS" ) then
        printlog( "   IMPRESS is slower than other apps, delaying for 2 sec." )
        sleep( 2 )
    endif
    
    FileSave

    Kontext "SpeichernDlg"
    if ( Speicherndlg.exists( 2 ) ) then
        '///+<li>Uncheck automatic extension</li>
        printlog( "Uncheck automatic extension" )

        '///+<li>Name the file and select filter</li>
        printlog( "Name the file and select filter" )
        Dateiname.settext( workpath & workfile )
        try
            Dateityp.select( filetype )
        catch
            warnlog( "#i48165# - incorrect filternames in localized versions" )
            printlog( "Defaulting filetype" )
        endcatch

        '///+<li>Check password</li>
        printlog( "Check password" )
        if ( passwort.isenabled() ) then
            Passwort.check()
        else
            warnlog( "#i36663# Password checkbox is disabled" )
        endif

        '///+<li>Save the file</li>
        printlog( "Save the file" )
        Speichern.click()

        kontext "active"
        if ( active.exists( 2 ) ) then
           printlog( "Handle overwrite warning (if any)" )
           active.yes()
        endif
        

        '///+<li>Enter the filename as password and confirm</li>
        Kontext "PasswordDlg"
        printlog( "Enter the name of the file as password and confirm" )
        if ( passwordDlg.exists() ) then
            Password.settext( workfile )
            PasswordConfirm.settext( workfile )
            PasswordDlg.ok()
        else
            warnlog( "No password dialog is displayed" )
        endif
        
        kontext "AlienWarning"
        if ( AlienWarning.exists( 2 ) ) then
            if ( FileTypeID <> "current" ) then
                printlog( "Handle alienwarning (expected)" )
                AlienWarning.ok()
            else
                warnlog( "Handle alienwarning (unexpected)" )
                AlienWarning.ok()
             endif         
        endif    

        '///+<li>Close the document</li>
        hDestroyDocument()

        '///+<li>Open the file via file-open</li>
        printlog( "Open the file via file-open" )
        FileOpen

        Kontext "OeffnenDlg"
        if ( OeffnenDlg.exists( 2 ) ) then
            Dateiname.settext( workfile )

            Oeffnen.click()

            Kontext "PasswordFileOpen"
            '///+<li>Enter the filename as password</li>
            printlog( "Enter the filename as password" )
            if ( PasswordFileOpen.exists( 4 ) ) then
                PasswortName.settext( workfile )
                PasswordFileOpen.ok()
            else
                kontext "Active"
                if ( Active.exists( 2 ) ) then
                    cMsg = active.getText()
                    cMsg = hRemoveLineBreaks( cMsg )
                    printlog( cMsg )
	                warnlog( "#i65889# - CWS Warnings01: Cannot read password protected files" )
                    active.ok()
                    goto endsub
                else
                    warnlog( "No password dialog is displayed" )
                endif
            endif

            '///+<li>Verify that the document is loaded</li>
            printlog( "Verify that the document is loaded" )
            call IsItLoaded()

            '///+<li>Close the navigator if present</li>
            Kontext "Navigator"
            if ( Navigator.exists( 1 ) ) then
    	        qaerrorlog( "Navigator should not be visible - setting not saved?" )
    	    endif
	    else
	        warnlog( "Second file open failed" )
        endif
    else
        warnlog( "File Open dislog did not come up" )
    endif

    '///+<li>Close navigator if present</li>
    hCloseNavigator()

    '///+<li>Close the document</li>
    hDestroyDocument()

    '///+<li>Delete the file</li>    
    hDeleteFile( workpath & workfile )

    '///+<li>Close navigator if present</li>
    hCloseNavigator()

    '///</ul>


endcase
