'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_document_properties.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsk $ $Date: 2007/11/22 10:43:22 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2006 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Access document properties
'*
'*******************************************************************************
'**
' #1 tFiledlgDocumentProperties() ' Access document properties
'**
'\******************************************************************************

testcase tFiledlgDocumentProperties()

    '///<h3>Access document properties</h3>

    use "framework\tools\inc\stringtools.inc"
    
    dim cFileName as string
        cFileName = "DigitalSignature" & hGetSuffix( "current" )
        
    dim cFilePath as string
        cFilePath = gTesttoolPath & "framework\security\input"
        cFilePath = convertpath( cFilePath )
        
    dim cFileURL as string
        cFileURL = cFilePath & gPathSigne & cFileName
        
    dim iFileSize as long
    dim cFileSize as string
    dim iFileSizeInfo as long
    dim cSignatureCreator as string
    
    dim cTestExpression as string
    
    dim cSelectAll as string
    dim cCopy as string

    dim brc as boolean
        
    '///<ul>
    printlog( "Using filename: " & cFileName )
    printlog( "Using filepath: " & cFilePath )
    
    '///+<li>Retrieve the size from the workfile using direct BASIC calls</li>
    if ( FileExists( cFileURL ) ) then
    	iFileSize = FileLen( cFileURL )
        printlog( "Testfile size is: " & iFileSize & " Bytes" )
    else
    	warnlog( "The workfile does not exist. aborting test" )
    	goto endsub
    endif
    
    '///+<li>Load the workfile (framework/security/input/DigitalSignature.???)</li>
    hLoadFile( cFileURL )
    
    '///+<li>open the file properties dialog</li>
    FileProperties
    
    '///+<li>Document-Tab: Verify that the filename is correct</li>
    brc = hDocumentInfoSelectTab( "General" )
    if ( not brc ) then
        warnlog( "Unable to switch to the requested tabpage, trying to recover" )
        kontext "TabDokument"
        TabDokument.cancel()
        hDestroyDocument()
    endif
        
    cTestExpression = hGetStringFromStaticTextField( FileLocationInfo )
    if ( cTestExpression = cFilePath ) then
    	printlog( "Path is correct" )
    else
        warnlog( "The path string is incorrect: " & cTestExpression )
    endif

    '///+<li>Verify the filesize info</li>
    kontext "TabDokument"
    cFileSize = hGetStringFromStaticTextField( FileSizeInfo )
    iFileSizeInfo =  hConvertStringToLong( cFileSize )
    if ( iFileSize <> iFileSizeInfo ) then	
        warnlog( "Filesize does not match, please check" )
        printlog( "Found...: " & iFileSizeInfo )
        printlog( "Expected: " & iFileSize    )
    else
        printlog( "Filesize is correct" )
    endif
    
    kontext "TabDokument"
    TabDokument.cancel()
    
    hDestroyDocument()
    
    '///</ul>

endcase

