'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_extension_update.inc,v $
'*
'*  $Revision: 1.2.4.1 $
'*
'*  last change: $Author: jsk $ $Date: 2008/02/20 14:07:47 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2006 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Hit update button for an extension
'*
'*******************************************************************************
'**
' #1 tExtensionUpdate ' Hit update button for an extension
'**
'\******************************************************************************

testcase tExtensionUpdate

    '///<h3>Hit update button for an extension</h3>
    '///<ul>
    
    'warnlog( "#i81543# Office crashes when Testtool executes .exists() method on some objects" )
    'goto skiptest
    
    const EXTENSION_NAME = "ShortLicense.oxt"
    
    dim cSampleExtension as string
        cSampleExtension = gTesttoolPath & "framework\basic\input\extensions\" 
        cSampleExtension = cSampleExtension & "simpleLicense\" & EXTENSION_NAME
        cSampleExtension = convertpath( cSampleExtension )
        
    dim iDocumentsBefore as integer
    dim iDocumentsAfter as integer
    
    printlog( "" )
    
    if ( dir( cSampleExtension ) <> "" ) then
        printlog( "Using extension: " & cSampleExtension )
    else
        warnlog( "Fatal: Sample extension could not be found: " & cSampleExtension )
        goto endsub
    endif
    printlog( "" )
    
    
    '///+<li>Create a new writer document</li>
    hCreateDocument()
    
    '///+<li>get the number of open documents (should be 2)</li>
    iDocumentsBefore = getDocumentCount()
    
    '///+<li>Add sample extension &quot;ShortLicense&quot;</li>
    hExtensionAddGUI( cSampleExtension , true )
    
    '///+<li>Reopen the Extension Manager</li>
    printlog( "Reopen Extension Manager" )
    ToolsPackageManager
    
    '///+<li>Click the &quot;Update&quot;-button</li>
    printlog( "Click the update-button" )
    kontext "PackageManager"
    updates.click()
    
    '///+<li>verif y that the update-Dialog is present</li>
    kontext "ExtensionUpdate"
    if ( ExtensionUpdate.exists() ) then
        printlog( "Close update-dialog. Good." )
        ExtensionUpdate.cancel()
    else
        warnlog( "Extension update dialog is missing" )
    endif
    
    '///+<li>Close the Extension Manager"
    kontext "PackageManager"
    if ( PackageManager.exists() ) then
        printlog( "Close Extension Manager" )
        PackageManager.close()
    endif

    '///+<li>verify that we still have the correct number of documents open</li>
    iDocumentsAfter = getDocumentCount()
    if ( iDocumentsAfter <> iDocumentsBefore ) then
        warnlog( "Incorrect number of documents open. Please verify" )
    else
        printlog( "Correct number of documents are open. Good" )
    endif
    
    '///+<li>Close the second document</li>
    hDestroyDocument()
    
    '///+<li>Remove the extension</li>
    hExtensionRemoveGUI( EXTENSION_NAME )
    
    '///</ul>

endcase

