'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_extension_options1.inc,v $
'*
'*  $Revision: 1.7.2.1 $
'*
'*  last change: $Author: jsk $ $Date: 2008/02/29 13:27:25 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2006 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Options for extensions
'*
'*******************************************************************************
'**
' #1 tExtensionOptions1 ' Options for extensions
'**
'\******************************************************************************

testcase tExtensionOptions1

    '///<h3>Options for extensions</h3>
    '///<ul>

    use "global\tools\inc\extension_manager_tools.inc"
    use "framework\tools\inc\treelist_tools.inc"
    use "framework\tools\inc\control_objects.inc"

    const EXTENSION_NAME = "leaf1.oxt" 
    const OPTIONS_ITEM   = "Writer leaf1 en-US"
    const ITEM_POS_1       = 2
    const ITEM_POS_2       = 35
    const ITEM_POS_2_ASIAN = 38
    
    dim cExtensionName as string

    dim cExtensionPath as string
        cExtensionPath = gTesttoolPath & "framework\basic\input\extensions\options\"

    dim cExtensionFile as string
        cExtensionFile = convertpath( cExtensionPath & EXTENSION_NAME )
        
    dim irc as integer
    dim brc as boolean

    '///+<li>Create one single writer document, the node will be merged into it</li>
    hInitSingleDoc()
    
    '///+<li>Open the Extension Manager, click Add</li>
    '///+<li>Load the sample extension &quot;leaf1.oxt&quot;</li>    
    '///+<li>Close the Extension Manager</li>
    printlog( "Add sample extension" )
    hExtensionAddGUI( cExtensionFile, false )

    '///+<li>Reopen the Extension Manager</li>
    printlog( "Reopen the Extension Manager" )
    ToolsPackageManager
    kontext "PackageManager"
    
    '///+<li>Test some control states for the first node</li>
    printlog( "Verify control states" )
    '///<ul>
    '///+<li>Add... (enabled)</li>
    if ( not Add.isEnabled() ) then
        warnlog( "Add button should be enabled" )
    endif
    
    '///+<li>Remove (disabled)</li>
    if ( Remove.isEnabled() ) then  
        warnlog( "Remove button should be disabled" )
    endif

    '///+<li>Enable (disabled)</li>
    if ( Enable.isEnabled() ) then  
        warnlog( "Enable button should be disabled" )
    endif    

    '///+<li>Disable (disabled)</li>
    if ( Disable.isEnabled() ) then  
        warnlog( "Disable button should be disabled" )
    endif    

    '///+<li>Export... (disabled)</li>
    if ( Export.isEnabled() ) then  
        warnlog( "Export button should be disabled" )
    endif    

    '///+<li>Updates... (enabled)</li>
    if ( not Updates.isEnabled() ) then  
        warnlog( "Updates button should be enabled" )
    endif    

    '///+<li>Options... (disabled)</li>
    if ( Options.isEnabled() ) then  
        warnlog( "Options button should be disabled" )
    endif    
    '///</ul>


    '///+<li>Select the extension by name</li>
    printlog( "Move from the top node to the sample extension" )
    hSelectExtensionName( EXTENSION_NAME )

    '///+<li>Test some control states for leaf1.oxt node</li>
    printlog( "Verify control states" )
    '///<ul>
    '///+<li>Add... (disabled)</li>
    if ( Add.isEnabled() ) then  
        warnlog( "Add button should be disabled" )
    endif    
    
    '///+<li>Remove (enabled)</li>
    if ( not Remove.isEnabled() ) then
        warnlog( "Remove button should be enabled" )
    endif

    '///+<li>Enable (disabled)</li>
    if ( Enable.isEnabled() ) then  
        warnlog( "Enable button should be disabled" )
    endif    

    '///+<li>Disable (enabled)</li>
    if ( not Disable.isEnabled() ) then
        warnlog( "Disable button should be enabled" )
    endif

    '///+<li>Export... (enabled)</li>
    if ( not Export.isEnabled() ) then
        warnlog( "Export button should be enabled" )
    endif

    '///+<li>Updates... (enabled)</li>
    if ( not Updates.isEnabled() ) then
        warnlog( "Updates button should be enabled" )
    endif

    '///+<li>Options... (enabled)</li>
    if ( not Options.isEnabled() ) then
        warnlog( "Options button should be enabled" )
    endif
    '///</ul>

    '///+<li>Click on the Options... button</li>
    printlog( "Open Options dialog from Extension Manager" )
    kontext "PackageManager" 
    if ( options.exists() ) then
        options.click()
        
        '///+<li>Verify that the node &quot;leaf1&quot; is at pos 2 (absolute)</li>
        printlog( "Verify presence and position of the leaf node" )
        irc = hSelectOptionsItem( OPTIONS_ITEM , ITEM_POS_1 )
        if ( irc > 0 ) then
            warnlog( "Test failed" )
        endif
        
        '///+<li>Close Options dialog (cancel)
        printlog( "Cancel Options dialog to get back to the Extension Manager" )
        OptionenDlg.cancel()
        
    else
        warnlog( "Options button does not exist/implemented in CWS jl61" )
    endif

    '///+<li>Close the Extension Manager</li>
    kontext "PackageManager"
    printlog( "Close the Extension Manager" )
    PackageManager.close()
    
    '///+<li>Open Tools/Options</li>
    printlog( "From the document open Tools/Options" )
    ToolsOptions
    
    printlog( "Verify presence and position of the leaf node" )
    if ( bAsianLan ) then
        irc = hSelectOptionsItem( OPTIONS_ITEM , ITEM_POS_2_ASIAN )
    else
        irc = hSelectOptionsItem( OPTIONS_ITEM , ITEM_POS_2 )
    endif
    if ( irc > 0 ) then
        warnlog( "Node <" & OPTIONS_ITEM & "> was not found in Tools/Options" )
    else
        printlog( "Node is present. Good." )
    endif
    
    Kontext "OptionenDlg"
    printlog( "Cancel Tools/Options to get back to the document" )
    OptionenDlg.cancel()

    '///+<li>Cleanup: Remove the sample extension</li>
    printlog( "Remove sample extension" )
    hExtensionRemoveGUI( EXTENSION_NAME )
    
    '///+<li>Cleanup: Close document</li>
    hInitbackingMode()

    '///<ul>
endcase

