'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_003_.inc,v $
'*
'*  $Revision: 1.14 $
'*
'*  last change: $Author: jsi $ $Date: 2007/07/02 13:32:20 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Check all resources for menuitem View
'*
'*************************************************************************************************
'*
' #1 C_003_ ' Initial routine
' #1 tViewNormal
' #1 tViewPageBreakPreview
' #1 tViewToolbars
' #1 tViewToolbarsCustomize
' #1 tViewFormulaBar
' #1 tViewStatusBar
' #1 tViewColumnAndRowHeaders
' #1 tViewValueHighlighting
' #1 tViewDataSources
' #1 tViewFullScreen
' #1 tViewZoom
'*
'\************************************************************************************************

sub C_003_

Printlog "----------------------- C_003_ (View menu) --------------------------"

    call ExitRestartTheOffice
    call tViewNormal
    call tViewPageBreakPreview
    Call tViewToolbars
    Call tViewToolbarsCustomize
    Call tViewFormulaBar
    Call tViewStatusBar
    Call tViewColumnAndRowHeaders
    Call tViewValueHighlighting
    call tViewDataSources
    Call tViewFullScreen
    Call tViewZoom

end sub
'
'-----------------------------------------------------------
'
testcase tViewNormal
'///<u><b>View / Normal AND View / Page Break Preview</b></u>    
    '/// Open new document
    Call hNewDocument
    '/// Invoke slot 'View / Page Break Preview'
    ViewPageBreakPreview
    '/// Invoke slot 'View / Normal'
    ViewNormalView
    '/// Close document
    Call hCloseDocument   
endcase

'
'-----------------------------------------------------------
'
testcase tViewPageBreakPreview
'///<u><b>View / Page Break Preview</b></u>
'///<b>Tested as 'side effect' in 'tViewNormal'</b>///
    printlog "This slot has already been tested in previous testcase 'tViewNormal'"
endcase
'
'-----------------------------------------------------------
'
testcase tViewToolbars
'///<u><b>View / Toolbars / *</b></u>
    '/// Open new document
    Call  hNewDocument
    '/// Show and Hide for all available toolbars in sub-menu
    '/// View / Toolbars / 3D-Settings
    ViewToolbarsThreeDSettings
    ViewToolbarsThreeDSettings
    '/// View / Toolbars / Align
    ViewToolbarsAlign
    ViewToolbarsAlign
    '/// View / Toolbars / BasicShapes
    ViewToolbarsBasicShapes
    ViewToolbarsBasicShapes
    '/// View / Toolbars / Controls
    ViewToolbarsFormControls
    ViewToolbarsFormControls
    '/// View / Toolbars / Drawing
    ViewToolbarsDrawing
    ViewToolbarsDrawing
    '/// View / Toolbars / Fontwork
    ViewToolbarsFontwork
    ViewToolbarsFontwork
    '/// View / Toolbars / Form Design
    ViewToolbarsFormDesign
    ViewToolbarsFormDesign    
    '/// View / Toolbars / Formatting
    ViewToolbarsFormatting
    ViewToolbarsFormatting
    '/// View / Toolbars / Insert
    ViewToolbarsInsert
    ViewToolbarsInsert
    '/// View / Toolbars / Insert Cell
    ViewToolbarsInsertCell
    ViewToolbarsInsertCell
    '/// View / Toolbars / Media Playback
    ViewToolbarsMediaPlayback
    ViewToolbarsMediaPlayback
    '/// View / Toolbars / Picture
    ViewToolbarsPicture
    ViewToolbarsPicture
    '/// View / Toolbars / Standard
    ViewToolbarsStandard
    ViewToolbarsStandard
    '/// View / Toolbars / Text Formatting
    ViewToolbarsTextFormatting
    ViewToolbarsTextFormatting    
    '/// View / Toolbars / Tools
    ViewToolbarsTools
    ViewToolbarsTools
    '/// View / Toolbars / Hyperlink bar
    ViewToolbarsInsertHyperlink
    ViewToolbarsInsertHyperlink
    '/// View / Toolbars / Formula Bar
    ViewToolbarsFormulaBar
    ViewToolbarsFormulaBar    
    '/// Close document
    Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tViewFormulaBar
'///<u><b>View / Formula Bar</b></u>
    '/// Open new document
    Call  hNewDocument
    '/// Invoke 'View / Formula Bar' twice to toggle both states
    ViewToolbarsFormulaBar
    ViewToolbarsFormulaBar    
    '/// Close document
    Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tViewToolbarsCustomize
'///<u><b>View / Toolbars / Customize</b></u>
    '/// Open new document
    Call  hNewDocument
    '/// Invoke View / Toolbars / Customize
    ViewToolbarsCustomize
    '/// Tabpages are Tab pages are tested in-depth in testcase 'tToolsCustomize'
    printlog "Tab pages are tested in-depth in testcase 'tToolsCustomize'"
    Kontext
    Messagebox.SetPage TabCustomizeToolbars
    '/// Check existence of dialog
    Call DialogTest ( TabCustomizeToolbars )
    '/// Leave dialog without in-depth tests (see above)
    TabCustomizeToolbars.cancel
    '/// Close document
    Call hCloseDocument   
endcase
'
'-----------------------------------------------------------
'
testcase tViewStatusBar
'///<u><b>View / Status Bar</b></u>
    '/// Open new document
    Call  hNewDocument
    '/// Invoke 'View / Status Bar' twice to toggle off/on
    ViewToolbarsStatusbar
    ViewToolbarsStatusbar    
    '/// Close document
    Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tViewColumnAndRowHeaders
'///<u><b>View / Column & Row Headers</b></u>
    '/// Open new document
    Call  hNewDocument    
    '/// Invoke 'View / Column & Row Headers' twice to toggle off/on
    ViewColumnAndRowHeaders
    ViewColumnAndRowHeaders    
    '/// Close document
    Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tViewValueHighlighting
'///<u><b>View / Value Highlighting</b></u>
    '/// Open new document
    Call  hNewDocument
    '/// Invoke 'View / Value Highlighting' twice to toggle off/on
    ViewValueHightlighting
    ViewValueHightlighting    
    '/// Close document
    Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tViewDataSources
'///<u><b>View / Data Sources</b></u>
    '/// Open new document
    Call  hNewDocument
    '/// Invoke 'View / Data Sources' twice to toggle off/on
    ViewDataSources
    ViewDataSources    
    '/// Close document
    Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tViewFullScreen
'///<u><b>View / Full Screen</b></u>
    '/// Open new document
    Call  hNewDocument
    '/// Invoke 'View / Full Screen' twice to toggle off/on
    kontext
    DocumentCalc.typekeys "13<RETURN>"
    ViewFullScreen
    kontext
    DocumentCalc.typekeys "13<RETURN>"
    ViewFullScreen    
    '/// Close document
    Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tViewZoom
'///<u><b>View / Zoom</b></u>
    '/// Open new document
    Call  hNewDocument
    '/// Invoke View / Zoom
    ViewZoom
    Kontext "Massstab"
    '/// Check if zoom dialog is visible
    DialogTest ( Massstab )
    '/// Close zoom  dialog
    Massstab.Close
    '/// Close document
    Call hCloseDocument
endcase

