'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: tools.inc,v $
'*
'*  $Revision: 1.18 $
'*
'*  last change: $Author: oc $ $Date: 2006/12/12 08:51:41 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Tools for Keyboard Accessibility
'*
'************************************************************************
'*
' #1 fDrawObjects
' #1 fPositionAndSize
' #1 fTestPosition
' #1 fCalculateTolerance
' #1 MeasurementConfiguration
'*
'\***********************************************************************

function fDrawObjects ( Object, xStart%, yStart%, xEnd%, yEnd% )
'///This function will draw some objects in Calc
 '///+ After drawing , you need to re-set the focus

   Call hToolbarSelect("DRAWING", true)

   Object = UCase( Object )
   select case Object
      case "RECHTECK" : Rechteck.Click
      case "LINIE"    : Linie.Click
      case "ELLIPSE"  : Ellipse.Click
      case "TEXT"     : Textobjekt.Click
      case "VTEXT"    :
        try
          VerticalText.Click
        catch
          Warnlog "Unable to insert Vertical Text! Asian Support in Options activated ?"
        endcatch
      case "LAUFTEXT" : Lauftext.Click
      case "LEGENDE"  : Legende.Click
      case "VLEGENDE" :
        try
          VerticalCallout.Click
        catch
          Warnlog "Unable to insert Vertical Callout! Asian Support in Options activated ?"
        endcatch
   end select
   sleep(2)
   Kontext "DocumentCalc"
   call gMouseMove (xStart%, yStart%, xEnd%, yEnd%)
   sleep(2)   
   Kontext "Drawbar"
   Drawbar.Close
   if Object <> "TEXT" then
       Kontext "DocumentCalc"
          DocumentCalc.MouseDown 40, 10
          sleep 3
          DocumentCalc.MouseUp   40, 10
          sleep 3
   end if

end function
'
'-------------------------------------------------------------------------------
'
function fPositionAndSize(Options as string)
'/// Open Format/Position and Size diglog with Options
  sleep(2)  
  FormatPositionAndSize
  sleep(2)
  Kontext
  Select case Options
    case "TabPositionAndSize"     : active.SetPage TabPositionAndSize
    case "TabDrehung"             : active.SetPage TabDrehung
    case "TabSchraegstellen"      : active.SetPage TabSchraegstellen
  end Select

  Kontext Options

end function
'
'-------------------------------------------------------------------------------
'
function fTestPosition( sPositionX , sPositionY , sWidth , sHeight )
'/// Check the A point's position and recover to default
    Call fPositionAndSize("TabPositionAndSize")
     if fCalculateTolerance(PositionX.Gettext , sPositionX) > 0.03 then Warnlog "Position X is wrong, should be " + sPositionX + " but get " + PositionX.Gettext
     if fCalculateTolerance(PositionY.Gettext , sPositionY) > 0.03 then Warnlog "Position Y is wrong, should be " + sPositionY + " but get " + PositionY.Gettext
     if fCalculateTolerance(Width.Gettext     , sWidth)     > 0.03 then Warnlog "Width is wrong, should be " + sWidth + " but get " + Width.Gettext
     if fCalculateTolerance(Width.Gettext     , sWidth)     > 0.03 then Warnlog "Height is wrong, should be " + sHeight + " but get " + Height.Gettext

     sPositionX  = "4" + gSeperator + "00" + gMeasurementUnit
     sPositionY  = "2" + gSeperator + "00" + gMeasurementUnit
     sWidth      = "10"+ gSeperator + "00" + gMeasurementUnit
     sHeight     = "8" + gSeperator + "00" + gMeasurementUnit

     PositionX.Settext sPositionX
     PositionY.Settext sPositionY
     Width.Settext     sWidth
     Height.Settext    sHeight

    TabPositionAndSize.OK
end function

'-------------------------------------------------------------------------

function fCalculateTolerance( sNumber1 , sNumber2 )
'/// change 2 parameters to number , then Compare them and return the result.

   Dim dNumber1        , dNumber2         as Single
   Dim iCommaLocation1 , iCommaLocation2  as Integer

  'the code below 4 lines is set "2,00cm" to "2.00"cm if needed
   iCommaLocation1 = InStr(sNumber1 , ",")
   if iCommaLocation1 > 0 then
      sNumber1 = Left(sNumber1 , iCommaLocation1-1) + "." + Right(sNumber1,Len(sNumber1) - iCommaLocation1)
   end if

   iCommaLocation2 = InStr(sNumber2 , ",")
   if iCommaLocation2 > 0 then
      sNumber2 = Left(sNumber2 , iCommaLocation2-1) + "." + Right(sNumber2,Len(sNumber2) - iCommaLocation2)
   end if

   dNumber1 = Val( Left(sNumber1, Len(sNumber1)-Len(gMeasurementUnit) ))
   dNumber2 = Val( Left(sNumber2, Len(sNumber2)-Len(gMeasurementUnit) ))
  fCalculateTolerance = Abs( dNumber1 - dNumber2 )

end function
'
'-------------------------------------------------------------------------------
'
sub MeasurementConfiguration

    'Software Configuration:
    'Getting the decimal seperator from global function
    gSeperator = GetDecimalSeperator() 
    'Saving value of measurementunit
    Call hNewDocument
    ToolsOptions
    Call hToolsOptions("SPREADSHEET","GENERAL")
    Redim Preserve gMeasurementunitindex as Integer
    gMeasurementunitindex = Masseinheit.GetSelIndex
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    Call hCloseDocument
    'Setting the measurement unit to centimeters.
    gMeasurementUnit = fSetMeasurementToCM()
    gMeasurementConfiguration = True    'Configuration has been run
    
end sub
