'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: coption5.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/16 12:33:51 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description : Check Tools->Options->Spreadsheet->Changes
'*
'************************************************************************
'*
' #1 cOption5                        ' Initial Routine
' #1 tOptionsChanges_save            ' Check all Options for 'Changes'
' #1 tOptionsChanges_reload          ' Check if changes persist after exit and restart the office
' #1 tOptionsChangesRestore_settings ' Restore default settings
'*
'\***********************************************************************

Global curr_Changes as integer, stat_Changes as integer, curr_Del as integer, stat_Del as integer
Global curr_Ins as integer, stat_Ins as integer, curr_Ent as integer, stat_Ent as integer

sub cOption5

	printLog Chr(13) + "--------- cOption5 ---------"
	printlog "Tools|Options|Spreadsheet|Changes"

	call tOptionsChanges_save
	call tOptionsChanges_reload
	call tOptionsChangesRestore_settings

end sub

'*********************************************************************************************************

testcase tOptionsChanges_save
'/// This test invokes the "Tools|Options|Spreadsheet|Changes" dialog 
'/// A check for the default settings is run ///'
'/// The tester will be warned about any item with unexpected value ///'
'/// All settings will be modified and the dialog is saved & closed using <OK> ///'
'/// After a restart of the office the persistence of the changes is verified ///'
'/// Finally the original settings are restored. ///'
'/// A testcase for the functionality cannot be run because all options in this section only have a visual impact ///'

	' Initialize the variables
	curr_Changes = 1
	curr_Del = 1
	curr_Ins = 1
	curr_Ent = 1
	stat_Changes = 4
	stat_Del = 5
	stat_Ins = 3
	stat_Ent = 8

	Call hNewDocument

	' Modify all parameters in this tabpage
  	ToolsOptions
  	hToolsOptions("SPREADSHEET", "CHANGES")

	' Changes
    if Aenderungen.GetSelIndex = curr_Changes then
    	printlog "OK, the current value of <Changes> is correct"
    else
    	warnlog "The current value of <Changes> is " & Aenderungen.GetSelIndex & " instead of " & curr_Changes
    end if
    Aenderungen.Select stat_Changes

    ' Deletions
    if Loeschungen.GetSelIndex = curr_Del then
    	printlog "OK, the current value of <Deletions> is correct"
    else
    	warnlog "The current value of <Deletions> is " & Loeschungen.GetSelIndex & " instead of " & curr_Del
    end if
    Loeschungen.Select stat_Del

    ' Insertions
    if Einfuegungen.GetSelIndex = curr_Ins then
    	printlog "OK, the current value of <Insertions> is correct"
    else
    	warnlog "The current value of <Insertions> is " & Einfuegungen.GetSelIndex & " instead of " & curr_Ins
    end if
    Einfuegungen.Select stat_Ins

    ' Moved entries
   	if Verschiebungen.GetSelIndex = curr_Ent then
    	printlog "OK, the current value of <Moved entries> is correct"
    else
    	warnlog "The current value of <Moved entries> is " & Verschiebungen.GetSelIndex & " instead of " & curr_Ent
    end if
    Verschiebungen.Select stat_Ent

    Kontext "OptionenDlg"
   	OptionenDlg.OK
    sleep 5
   	Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsChanges_reload
'/// Documentation is summarized in tOptionsChanges_save

    sleep 5
	'Restart the complete office
	ExitRestartTheOffice

	Call hNewDocument

	' Check all parameters in this tabpage
  	ToolsOptions
  	hToolsOptions("SPREADSHEET", "CHANGES")

	' Changes
	if Aenderungen.GetSelIndex = stat_Changes then
		printlog "OK, the changed value of <Changes> is persistent"
	else
		warnlog "The changed value of <Changes> was not saved"
	end if

	' Deletions
	if Loeschungen.GetSelIndex = stat_Del then
		printlog "OK, the changed value of <Deletions> is persistent"
	else
		warnlog "The changed value of <Deletions> was not saved"
	end if

	' Insertions
	if Einfuegungen.GetSelIndex = stat_Ins then
		printlog "OK, the changed value of <Insertions> is persistent"
	else
		warnlog "The changed value of <Insertions> was not saved"
	end if

	' Moved entries
   	if Verschiebungen.GetSelIndex = stat_Ent then
		printlog "OK, the changed value of <Moved entries> is persistent"
	else
		warnlog "The changed value of <Moved entries> was not saved"
	end if

	Kontext "OptionenDlg"
   	OptionenDlg.Cancel

   	Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsChangesRestore_settings
'/// Documentation is summarized in tOptionsChanges_save

	Call hNewDocument

	' restore the default settings
  	ToolsOptions
  	hToolsOptions("SPREADSHEET", "CHANGES")

	' Changes
	Aenderungen.Select curr_Changes

	' Deletions
	Loeschungen.Select curr_Del

	' Insertions
	Einfuegungen.Select curr_Ins

	' Moved entries
   	Verschiebungen.Select curr_Ent

   	Kontext "OptionenDlg"
   	OptionenDlg.OK

   	Call hCloseDocument

endcase



