// $Id: FloatSetting.hh 11587 2010-07-13 21:55:48Z mthuurne $

#ifndef FLOATSETTING_HH
#define FLOATSETTING_HH

#include "SettingRangePolicy.hh"
#include "SettingImpl.hh"

namespace openmsx {

class FloatSettingPolicy : public SettingRangePolicy<double>
{
protected:
	FloatSettingPolicy(double minValue, double maxValue);
	std::string toString(double value) const;
	double fromString(const std::string& str) const;
	std::string getTypeString() const;
};

/** A Setting with a floating point value.
  */
class FloatSetting : public SettingImpl<FloatSettingPolicy>
{
public:
	FloatSetting(CommandController& commandController,
	             const std::string& name, const std::string& description,
	             double initialValue, double minValue, double maxValue);
	FloatSetting(CommandController& commandController,
	             const char* name, const char* description,
	             double initialValue, double minValue, double maxValue);
};

} // namespace openmsx

#endif
