// $Id: MidiOutConnector.hh 4489 2005-06-16 20:51:54Z m9710797 $

#ifndef MIDIOUTCONNECTOR_HH
#define MIDIOUTCONNECTOR_HH

#include "Connector.hh"
#include "SerialDataInterface.hh"
#include "MidiOutDevice.hh"

namespace openmsx {

class PluggingController;

class MidiOutConnector : public Connector, public SerialDataInterface
{
public:
	MidiOutConnector(PluggingController& pluggingController,
	                 const std::string& name);
	virtual ~MidiOutConnector();

	// Connector
	virtual const std::string& getDescription() const;
	virtual const std::string& getClass() const;
	virtual MidiOutDevice& getPlugged() const;

	// SerialDataInterface
	virtual void setDataBits(DataBits bits);
	virtual void setStopBits(StopBits bits);
	virtual void setParityBit(bool enable, ParityBit parity);
	virtual void recvByte(byte value, const EmuTime& time);

private:
	PluggingController& pluggingController;
};

} // namespace openmsx

#endif
