# $Id: win_resource.py 9306 2009-03-01 05:15:33Z mfeingol $
# Generates Windows resource header.

from outpututils import rewriteIfChanged
from version import extractRevision, packageVersion

import sys

def iterResourceHeader():
	if '-' in packageVersion:
		versionNumber = packageVersion[ : packageVersion.index('-')]
	else:
		versionNumber = packageVersion
	versionComponents = versionNumber.split('.') + [ extractRevision() ]
	assert len(versionComponents) == 4, versionComponents

	yield '#define OPENMSXDEBUGGER_VERSION_INT %s' % ', '.join(versionComponents)
	yield '#define OPENMSXDEBUGGER_VERSION_STR "%s\\0"' % packageVersion

if __name__ == '__main__':
	if len(sys.argv) == 2:
		rewriteIfChanged(sys.argv[1], iterResourceHeader())
	else:
		print >> sys.stderr, \
			'Usage: python win-resource.py RESOURCE_HEADER'
		sys.exit(2)
