// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _V2d_View_HeaderFile
#define _V2d_View_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_V2d_View_HeaderFile
#include <Handle_V2d_View.hxx>
#endif

#ifndef _Handle_Aspect_WindowDriver_HeaderFile
#include <Handle_Aspect_WindowDriver.hxx>
#endif
#ifndef _V2d_ViewerPointer_HeaderFile
#include <V2d_ViewerPointer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Graphic2d_ViewMapping_HeaderFile
#include <Handle_Graphic2d_ViewMapping.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Handle_Graphic2d_Buffer_HeaderFile
#include <Handle_Graphic2d_Buffer.hxx>
#endif
#ifndef _Viewer_View_HeaderFile
#include <Viewer_View.hxx>
#endif
#ifndef _Handle_V2d_Viewer_HeaderFile
#include <Handle_V2d_Viewer.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Quantity_Ratio_HeaderFile
#include <Quantity_Ratio.hxx>
#endif
#ifndef _Quantity_Factor_HeaderFile
#include <Quantity_Factor.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Graphic2d_DisplayList_HeaderFile
#include <Handle_Graphic2d_DisplayList.hxx>
#endif
#ifndef _Graphic2d_PickMode_HeaderFile
#include <Graphic2d_PickMode.hxx>
#endif
#ifndef _V2d_TypeOfWindowResizingEffect_HeaderFile
#include <V2d_TypeOfWindowResizingEffect.hxx>
#endif
#ifndef _Handle_PlotMgt_PlotterDriver_HeaderFile
#include <Handle_PlotMgt_PlotterDriver.hxx>
#endif
#ifndef _Aspect_TypeOfColorSpace_HeaderFile
#include <Aspect_TypeOfColorSpace.hxx>
#endif
#ifndef _Handle_Graphic2d_View_HeaderFile
#include <Handle_Graphic2d_View.hxx>
#endif
#ifndef _Quantity_NameOfColor_HeaderFile
#include <Quantity_NameOfColor.hxx>
#endif
#ifndef _Aspect_FillMethod_HeaderFile
#include <Aspect_FillMethod.hxx>
#endif
class Aspect_WindowDriver;
class Graphic2d_ViewMapping;
class Graphic2d_GraphicObject;
class Graphic2d_Buffer;
class Viewer_BadValue;
class V2d_Viewer;
class Graphic2d_DisplayList;
class PlotMgt_PlotterDriver;
class Graphic2d_View;
class Quantity_Color;


//! Defines the application object view for the 2D Viewer, <br>
//! V2d_Viewer. The functions in this framework manage <br>
//! the origin and the size of the scene displayed in the view (zoom, panning, etc.). <br>
class V2d_View : public Viewer_View {

public:

  //! Creates a view which represents a portion of the user space. <br>
//!          This portion is defined by  the point (aXCenter,aYCenter) <br>
//!          which will be represent at the center of the window and by aSize. <br>
//!          aWindowDriver defines a window and a driver. <br>
  Standard_EXPORT   V2d_View(const Handle(Aspect_WindowDriver)& aWindowDriver,const Handle(V2d_Viewer)& aViewer,const Quantity_Length aXCenter = 0,const Quantity_Length aYCenter = 0,const Quantity_Length aSize = 1000);
  //! Defines the default position aXCenter, aYCenter and <br>
//! the size aSize used in the Reset function. <br>
  Standard_EXPORT     void SetDefaultPosition(const Quantity_Length aXCenter = 0,const Quantity_Length aYCenter = 0,const Quantity_Length aSize = 1000) ;
  //! Automatic Zoom-Panning. Objects visible in the view are <br>
//!      visualised so as to occupy the maximum amount of space <br>
//!      while respecting the initial height/width ratio. <br>
//!      Updates the view. The resulting space also takes into account a default <br>
//!      margin that can be modified with SetFitallRatio. The view is updated. <br>
  Standard_EXPORT     void Fitall() ;
  //! The point of the graphic view corresponding to the <br>
//!          middle of the window aX1,aY1,aX2,aY2 (in pixel coordinates) <br>
//!          comes to the center of the window. <br>
//!          Updates the view <br>//!  Warning! raises BadValue from Viewer if aX1 = aX2 or aY1 = aY2; <br>
  Standard_EXPORT     void WindowFit(const Standard_Integer aX1,const Standard_Integer aY1,const Standard_Integer aX2,const Standard_Integer aY2) ;
  //! The point of the graphic view corresponding to the <br>
//!          middle of the window aX1,aY1,aX2,aY2 (in user coordinates) <br>
//!          comes to the center of the window. <br>
//!          If UseMinimum is true the smallest dimension of the rectangle <br>
//!          will be zoom to occupy the view. If not the greatest dimension wiil be used. <br>
//!          Updates the view <br>//!  Warning! raises BadValue from Viewer if aX1 = aX2 or aY1 = aY2; <br>
  Standard_EXPORT     void Fit(const Quantity_Length aX1,const Quantity_Length aY1,const Quantity_Length aX2,const Quantity_Length aY2,const Standard_Boolean UseMinimum = Standard_True) ;
  //! Sets the 10 mm default margin aRatio which is taken <br>
//! into account by the Fitall function. <br>
//! Exceptions <br>
//! Viewer_BadValue if aRatio is less than 0 or greater than or equal to 1. <br>
  Standard_EXPORT     void SetFitallRatio(const Quantity_Ratio aRatio) ;
  //! Increases the size of the portion of user-space <br>
//!          by a factor of Zoom and updates the view. <br>//!  Warning! raises BadValue from Viewer if aRatio <= 0. <br>
  Standard_EXPORT     void Zoom(const Quantity_Factor Zoom) ;
  //! Increases the size of the portion of user-space by <br>
//! a zoom factor which is calculated from the two <br>
//! screen points aX1, aY1 and aX2, aY2 so that Z = 1/(1 + C x D) where: <br>
//! -   C is the coefficient aCoefficient and <br>
//! -   D is the distance between the two points aX1,aY1 and aX2,aY2. <br>
  Standard_EXPORT     void Zoom(const Standard_Integer aX1,const Standard_Integer aY1,const Standard_Integer aX2,const Standard_Integer aY2,const Quantity_Ratio aCoefficient = 0.005) ;
  //! Increases the size of the portion of user-space by <br>
//! a zoom factor which is calculated from the current <br>
//! point aX,aY and the screen center. The default factor is 0.005. <br>
  Standard_EXPORT     void Zoom(const Standard_Integer aX,const Standard_Integer aY,const Quantity_Ratio aCoefficient = 0.005) ;
  //! Defines the default view mapping from two screen <br>
//! points in a previous view anOriginView. The view is updated. <br>
  Standard_EXPORT     void Magnify(const Handle(V2d_View)& anOriginView,const Standard_Integer X1,const Standard_Integer Y1,const Standard_Integer X2,const Standard_Integer Y2) ;
  //! Translates the dx,dy center of the objects space. <br>
  Standard_EXPORT     void Translate(const Quantity_Length dx,const Quantity_Length dy) ;
  //! places the point of the view corresponding <br>
//!          at the pixel position x,y at the center of the window <br>
//!          and updates the view. <br>
  Standard_EXPORT     void Place(const Standard_Integer x,const Standard_Integer y,const Quantity_Factor aZoomFactor = 1) ;
  //! Places the center of the object's space in the center <br>
//! of the window according to the zoom factor. The view is updated. <br>
  Standard_EXPORT     void ScreenPlace(const Quantity_Length x,const Quantity_Length y,const Quantity_Factor aZoomFactor = 1) ;
  //! Translates the center of the object's space and <br>
//! updates the view. The translation is specified in screen coordinates. <br>
  Standard_EXPORT     void Pan(const Standard_Integer dx,const Standard_Integer dy) ;
  //! Converts a screen value into the view space value V. <br>
  Standard_EXPORT     Quantity_Length Convert(const Standard_Integer V) const;
  //! Converts the screen space coordinates X, Y into the <br>
//! view space coordinates ViewX, ViewY. <br>
  Standard_EXPORT     void Convert(const Standard_Integer X,const Standard_Integer Y,Quantity_Length& ViewX,Quantity_Length& ViewY) const;
  //! Converts the view space coordinates ViewX, ViewY <br>
//! into the screen space coordinates X, Y. <br>
  Standard_EXPORT     void Convert(const Quantity_Length ViewX,const Quantity_Length ViewY,Standard_Integer& X,Standard_Integer& Y) const;
  //! returns a view size from a driver size. <br>
  Standard_EXPORT     Quantity_Length Convert(const Quantity_Length aDriverSize) const;
  //! Resets the viewmapping of the view and updates the view. <br>
  Standard_EXPORT     void Reset() ;
  //! switches the view to its previous viewmapping <br>
//!          and updates the view. <br>
  Standard_EXPORT     void Previous() ;
  //! Disables the Previous function in this framework. <br>
  Standard_EXPORT     void DisableStorePrevious() ;
  //! Enables the Previous function in this framework. <br>
  Standard_EXPORT     void EnableStorePrevious() ;
  //! Clears the window and redraws all primitives. <br>
  Standard_EXPORT     void Update() const;
  //! draws the objects created since the last update. <br>
  Standard_EXPORT     void UpdateNew() const;
  //! Restores The Window Area defined by his center <br>
//!         and PIXEL size from the BackingStored Window <br>
//! Warning <br>
//! This function only works if the window is double-buffered. <br>
  Standard_EXPORT     void RestoreArea(const Standard_Integer Xc,const Standard_Integer Yc,const Standard_Integer Width,const Standard_Integer Height) const;
  //! Restores the full window area from the backing stored window. <br>
//! Warning <br>
//! This function only works if the window is double-buffered. <br>
  Standard_EXPORT     void Restore() const;
  
  Standard_EXPORT     void Dump() const;
  
  Standard_EXPORT     void Dump(const Standard_CString aFileName) const;
  //! From the X, Y coordinates, returns the list of picked <br>
//! graphic objects within the precision value aPrecision. <br>
  Standard_EXPORT     Handle_Graphic2d_DisplayList Pick(const Standard_Integer X,const Standard_Integer Y,const Standard_Integer aPrecision) ;
  
  Standard_EXPORT     Handle_Graphic2d_DisplayList PickByCircle(const Standard_Integer X,const Standard_Integer Y,const Standard_Integer Radius) ;
  //! Returns the list of the picked graphic objects. <br>
  Standard_EXPORT     Handle_Graphic2d_DisplayList Pick(const Standard_Integer Xmin,const Standard_Integer Ymin,const Standard_Integer Xmax,const Standard_Integer Ymax,const Graphic2d_PickMode aPickMode = Graphic2d_PM_INCLUDE) ;
  //! Removes all the graphic objects from the view. <br>
  Standard_EXPORT     void Erase() ;
  //! indicates that the window in which the view is drawn has been resized <br>
//!          and updates the view. <br>
  Standard_EXPORT     void MustBeResized(const V2d_TypeOfWindowResizingEffect anEffect) ;
  //! Indicates whether the window associated with the <br>
//! view has been moved or not. <br>
  Standard_EXPORT     void HasBeenMoved() ;
  //!    Plots the view to a plotter aPlotterDriver centered <br>
//! through aXCenter, aYCenter with the plotting scale aScale. <br>
  Standard_EXPORT     void Plot(const Handle(PlotMgt_PlotterDriver)& aPlotterDriver,const Quantity_Length aXCenter,const Quantity_Length aYCenter,const Quantity_Factor aScale = 1.0) const;
  //! plot a view as on screen. <br>
//! Note:     if <aScale> is zero then plots exactly what is on the screen <br>
  Standard_EXPORT     void Plot(const Handle(PlotMgt_PlotterDriver)& aPlotterDriver,const Quantity_Factor aScale = 1.0) const;
  //!Plots the view to a plotter according to the current <br>
//! size and center of the view. <br>
  Standard_EXPORT     void PlotScreen(const Handle(PlotMgt_PlotterDriver)& aPlotterDriver) const;
  //! dump the view <br>
  Standard_EXPORT     void ScreenCopy(const Handle(PlotMgt_PlotterDriver)& aPlotterDriver,const Standard_Boolean fWhiteBackground = Standard_True,const Quantity_Factor aScale = 1.0) ;
  
//! Plots the view to the PostScript file aFile according to <br>
//! a paper format specified by the arguments aWidth, <br>
//! aHeight, aXCenter, aYCenter with the scale aScale. <br>
  Standard_EXPORT     void PostScriptOutput(const Standard_CString aFile,const Quantity_Length aWidth,const Quantity_Length aHeight,const Quantity_Length aXCenter,const Quantity_Length aYCenter,const Quantity_Factor aScale,const Aspect_TypeOfColorSpace aTypeOfColorSpace) const;
  //! Plots the view to the PostScript file aFile according to <br>
//! the paper format specified by the arguments aWidth, <br>
//! aHeight. This is done by keeping the same view size and center. <br>
  Standard_EXPORT     void ScreenPostScriptOutput(const Standard_CString aFile,const Quantity_Length aWidth,const Quantity_Length aHeight,const Aspect_TypeOfColorSpace aTypeOfColorSpace) const;
  //! From the X,Y point, returns the nearest point gx,gy <br>
//! on the grid. <br>
  Standard_EXPORT     void Hit(const Standard_Integer X,const Standard_Integer Y,Quantity_Length& gx,Quantity_Length& gy) const;
  //! shows the point matching the grid. <br>
//!          if the hit has already been shown, it is first erased. <br>
//!          Does not update the view. <br>
  Standard_EXPORT     void ShowHit(const Standard_Integer X,const Standard_Integer Y) ;
  //! erases the hit point and updates the view. <br>
  Standard_EXPORT     void EraseHit() ;
  //! Defines the default override color of objects or <br>
//!		primitives using Highlight() methods. <br>
  Standard_EXPORT     void SetDefaultHighlightColor(const Standard_Integer aColorIndex) ;
  //! Updates the drawing precision factor aDeflection for <br>
//! curves and circles. <br>
  Standard_EXPORT     void SetDeflection(const Quantity_Length aDeflection) ;
  //! Returns the current deflection coefficient. <br>
  Standard_EXPORT     Quantity_Length Deflection() const;
  //! Returns the associated Grahic2d view with this view. <br>
  Standard_EXPORT     Handle_Graphic2d_View View() const;
  //! Returns the parent viewer of this view. <br>
  Standard_EXPORT     Handle_V2d_Viewer Viewer() const;
  //! Returns the window driver handle associated with this view. <br>
  Standard_EXPORT     Handle_Aspect_WindowDriver Driver() const;
  //! returns the current zoom factor of the view. <br>
  Standard_EXPORT     Quantity_Factor Zoom() const;
  //! returns the current point of the user space <br>
//!          being at the center of the view. <br>
  Standard_EXPORT     void Center(Quantity_Length& aX,Quantity_Length& aY) const;
  //! Returns the current size of the view. <br>
  Standard_EXPORT     Quantity_Length Size() const;
  //! returns the background color of the view. <br>
  Standard_EXPORT     Quantity_NameOfColor Color() const;
  //! returns the background color of the view. <br>
  Standard_EXPORT     void Color(Quantity_Color& color) const;
  
  Standard_EXPORT     void Scroll(Standard_Integer& XCenter,Standard_Integer& YCenter,Standard_Integer& DX,Standard_Integer& DY) ;
  //! Returns the default override color of objects or <br>
//!		primitives using Highlight() methods. <br>
//!  Warning: Returns -1 when the color index is not defined. <br>
  Standard_EXPORT     Standard_Integer DefaultHighlightColor() const;
  //! idem than WindowFit <br>
  Standard_EXPORT     void Fit(const Standard_Integer aX1,const Standard_Integer aY1,const Standard_Integer aX2,const Standard_Integer aY2) ;
  //! Defines the color of view's background <br>
  Standard_EXPORT     void SetBackground(const Quantity_NameOfColor aNameColor) ;
  //! Defines the color of view's background <br>
  Standard_EXPORT     void SetBackground(const Quantity_Color& color) ;
  //! Loads the view background from an image file <aName> <br>
//! defined with a supported format XWD,GIF or BMP <br>
//! and returns TRUE if the operation is successfull. <br>
  Standard_EXPORT     Standard_Boolean SetBackground(const Standard_CString aNameFile,const Aspect_FillMethod aMethod = Aspect_FM_CENTERED) ;




  DEFINE_STANDARD_RTTI(V2d_View)

protected:




private: 

  
  Standard_EXPORT     void StoreCurrent() ;
  
  Standard_EXPORT     void MapToCenter() ;

Handle_Aspect_WindowDriver myWindowDriver;
V2d_ViewerPointer myViewer;
Standard_Real myFitallRatio;
Standard_Real myDeflection;
Handle_Graphic2d_ViewMapping myViewMapping;
Standard_Real myXPosition;
Standard_Real myYPosition;
Standard_Real myScale;
Standard_Real myPreviousX;
Standard_Real myPreviousY;
Standard_Real myPreviousSize;
Standard_Real myPreviousXPosition;
Standard_Real myPreviousYPosition;
Standard_Real myPreviousScale;
Standard_Boolean myEnablePrevious;
Handle_Graphic2d_GraphicObject myHitPoint;
Handle_Graphic2d_Buffer myHitBuf;
Standard_Real myWidth;
Standard_Real myHeight;
Standard_Real pxmin;
Standard_Real pymin;
Standard_Real pxmax;
Standard_Real pymax;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
