// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GeomConvert_ApproxCurve_HeaderFile
#define _GeomConvert_ApproxCurve_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_BSplineCurve_HeaderFile
#include <Handle_Geom_BSplineCurve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Geom_Curve;
class Geom_BSplineCurve;
class Standard_OutOfRange;
class Standard_ConstructionError;


//! A framework to convert a 3D curve to a 3D BSpline. <br>
//! This is done by approximation to a BSpline curve within a given tolerance. <br>
class GeomConvert_ApproxCurve  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Constructs a curve approximation framework defined by - <br>
//!   -      the conic Curve, <br>
//!   -      the tolerance value Tol3d, <br>
//!   -      the degree of continuity Order, <br>
//!   -      the maximum number of segments <br>
//!     MaxSegments allowed in the resulting BSpline curve, and <br>
//!   -      the highest degree MaxDeg which the <br>
//!     polynomial defining the BSpline curve may have. <br>
  Standard_EXPORT   GeomConvert_ApproxCurve(const Handle(Geom_Curve)& Curve,const Standard_Real Tol3d,const GeomAbs_Shape Order,const Standard_Integer MaxSegments,const Standard_Integer MaxDegree);
  //! Returns the BSpline curve resulting from the approximation algorithm. <br>
  Standard_EXPORT     Handle_Geom_BSplineCurve Curve() const;
  //!  returns  Standard_True  if  the  approximation  has <br>
//! been  done  within  requiered tolerance <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  //! Returns  Standard_True if the approximation did come out <br>
//! with a result that  is not NECESSARELY within the required tolerance <br>
  Standard_EXPORT     Standard_Boolean HasResult() const;
  //!  Returns the greatest distance between a point on the <br>
//! source conic and the BSpline curve resulting from the <br>
//! approximation. (>0 when an approximation <br>
//!  has  been  done, 0  if  no  approximation) <br>
  Standard_EXPORT     Standard_Real MaxError() const;
  //!  Print on the stream  o  information about the object <br>
  Standard_EXPORT     void Dump(Standard_OStream& o) const;





protected:





private:



Handle_Geom_Curve myCurve;
Standard_Boolean myIsDone;
Standard_Boolean myHasResult;
Handle_Geom_BSplineCurve myBSplCurve;
Standard_Real myMaxError;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
