// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepExtrema_DistShapeShape_HeaderFile
#define _BRepExtrema_DistShapeShape_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _BRepExtrema_SeqOfSolution_HeaderFile
#include <BRepExtrema_SeqOfSolution.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _TopTools_IndexedMapOfShape_HeaderFile
#include <TopTools_IndexedMapOfShape.hxx>
#endif
#ifndef _BRepExtrema_SupportType_HeaderFile
#include <BRepExtrema_SupportType.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class Standard_OutOfRange;
class BRepExtrema_UnCompatibleShape;
class TopoDS_Shape;
class TopTools_IndexedMapOfShape;
class Bnd_SeqOfBox;
class gp_Pnt;


//! This class  provides tools to compute minimum distance <br>
//!          between two Shapes (Compound,CompSolid, Solid, Shell, Face, Wire, Edge, Vertex). <br>
class BRepExtrema_DistShapeShape  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! create empty brepextrema <br>
  Standard_EXPORT   BRepExtrema_DistShapeShape();
  //! computation of  the minimum  distance  (value  and <br>
//!          couple  of points) using default deflection <br>
  Standard_EXPORT   BRepExtrema_DistShapeShape(const TopoDS_Shape& Shape1,const TopoDS_Shape& Shape2);
  //! Creates brepextrema and load both shapes into it <br>
//!          Default value is Precision::Confusion(). <br>
  Standard_EXPORT   BRepExtrema_DistShapeShape(const TopoDS_Shape& Shape1,const TopoDS_Shape& Shape2,const Standard_Real theDeflection);
  
  Standard_EXPORT     void SetDeflection(const Standard_Real theDeflection) ;
  //! load first shape into extrema <br>
  Standard_EXPORT     void LoadS1(const TopoDS_Shape& Shape1) ;
  //! load second shape into extrema <br>
  Standard_EXPORT     void LoadS2(const TopoDS_Shape& Shape1) ;
  //! computation of  the minimum  distance  (value  and <br>
//!          couple  of points). Parameter theDeflection is used <br>
//!          to specify a maximum deviation of extreme distances <br>
//!          from the minimum one. <br>
//!          Returns IsDone status. <br>
  Standard_EXPORT     Standard_Boolean Perform() ;
  //! True if the minimum  distance  is found. <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  //! Returns the number of solutions satisfying the minimum <br>
//!          distance. <br>
  Standard_EXPORT     Standard_Integer NbSolution() const;
  //! Returns the value of the minimum distance. <br>
  Standard_EXPORT     Standard_Real Value() const;
  //! True if one of  the  shapes is  a solid and the <br>
//!          other shape is completely or partially inside the solid. <br>
  Standard_EXPORT     Standard_Boolean InnerSolution() const;
  //! Returns the Point corresponding to  the <N>th <br>
//!          solution on the first Shape <br>
  Standard_EXPORT     gp_Pnt PointOnShape1(const Standard_Integer N) const;
  //! Returns the Point  corresponding to the <N>th <br>
//!          solution on the second Shape <br>
  Standard_EXPORT     gp_Pnt PointOnShape2(const Standard_Integer N) const;
  //! gives the type   of  the support  where the   Nth <br>
//!          solution on the first shape is situated: <br>
//!          IsVertex : <br>
//!          => the Nth solution on the first shape is a Vertex <br>
//!          IsOnEdge <br>
//!          => the Nth soluion on the first shape is on a Edge <br>
//!          IsInFace <br>
//!          => the Nth solution on the first shape is inside a <br>
//!          face <br>
//! <br>
//!           the  corresponding  support   is  obtained by  the <br>
//!          method SupportOnShape1 <br>
  Standard_EXPORT     BRepExtrema_SupportType SupportTypeShape1(const Standard_Integer N) const;
  //! gives the type    of  the support  where the   Nth <br>
//!          solution on the second shape is situated: <br>
//!          IsVertex : <br>
//!          => the Nth solution on the second shape is a Vertex <br>
//!          IsOnEdge <br>
//!          => the Nth soluion on the secondt shape is on a Edge <br>
//!          IsInFace <br>
//!          => the Nth solution on the second shape is inside a <br>
//!          face <br>
//! <br>
//!          the support is obtained by the method SupportOnShape2 <br>
  Standard_EXPORT     BRepExtrema_SupportType SupportTypeShape2(const Standard_Integer N) const;
  //!gives the support  where the   Nth <br>
//!          solution on the first  shape is situated. <br>
//!          This support can be a Vertex, an Edge or a Face. <br>
  Standard_EXPORT     TopoDS_Shape SupportOnShape1(const Standard_Integer N) const;
  //! gives the support  where the   Nth <br>
//!          solution on the second   shape is situated. <br>
//!          This support can be a Vertex, an Edge or a Face. <br>
  Standard_EXPORT     TopoDS_Shape SupportOnShape2(const Standard_Integer N) const;
  //! gives the  corresponding  parameter  t if the  Nth <br>
//!          Solution is situated on an Egde of the first shape <br>
  Standard_EXPORT     void ParOnEdgeS1(const Standard_Integer N,Standard_Real& t) const;
  //! gives the  corresponding  parameter  t if the  Nth <br>
//!          Solution is situated on an Egde of the first shape <br>
  Standard_EXPORT     void ParOnEdgeS2(const Standard_Integer N,Standard_Real& t) const;
  //! gives the  corresponding  parameters  (U,V)  if the  Nth <br>
//!          Solution is situated on an face  of the first shape <br>
  Standard_EXPORT     void ParOnFaceS1(const Standard_Integer N,Standard_Real& u,Standard_Real& v) const;
  //! gives the  corresponding  parameters (U,V)   if the  Nth <br>
//!          Solution is situated on an Face  of the second  shape <br>
  Standard_EXPORT     void ParOnFaceS2(const Standard_Integer N,Standard_Real& u,Standard_Real& v) const;
  //! Prints on the stream o information on the current state <br>
//!          of the object. <br>
//! <br>
  Standard_EXPORT     void Dump(Standard_OStream& o) const;





protected:





private:

  //! computes the minimum  distance  between two map  of <br>
//!          shapes(Face,Edge,Vertex) <br>
  Standard_EXPORT     void DistanceMapMap(const TopTools_IndexedMapOfShape& Map1,const TopTools_IndexedMapOfShape& Map2,const Bnd_SeqOfBox& LBox1,const Bnd_SeqOfBox& LBox2) ;


Standard_Integer myNbSolution;
Standard_Real myDistRef;
Standard_Real myDistValue;
Standard_Boolean myIsDone;
BRepExtrema_SeqOfSolution ListeDeSolutionShape1;
BRepExtrema_SeqOfSolution ListeDeSolutionShape2;
Standard_Boolean myInnerSol;
Standard_Real myEps;
TopoDS_Shape myShape1;
TopoDS_Shape myShape2;
TopTools_IndexedMapOfShape myMapV1;
TopTools_IndexedMapOfShape myMapV2;
TopTools_IndexedMapOfShape myMapE1;
TopTools_IndexedMapOfShape myMapE2;
TopTools_IndexedMapOfShape myMapF1;
TopTools_IndexedMapOfShape myMapF2;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
