// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BOP_FaceAreaBuilder_HeaderFile
#define _BOP_FaceAreaBuilder_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _BOP_Area2dBuilder_HeaderFile
#include <BOP_Area2dBuilder.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class BOP_LoopSet;
class BOP_LoopClassifier;



//! The FaceAreaBuilder algorithm is used to construct Faces from a LoopSet, <br>
//! where the Loop is the composite topological object of the boundary, <br>
//! here wire or block of edges. <br>
//! The LoopSet gives an iteration on Loops. <br>
//! For each Loop  it indicates if it is on the boundary (wire) or if it <br>
//! results from  an interference (block of edges). <br>
//! The result of the FaceAreaBuilder is an iteration on areas. <br>
//! An area is described by a set of Loops. <br>
class BOP_FaceAreaBuilder  : public BOP_Area2dBuilder {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
//! Empty constructor; <br>
  Standard_EXPORT   BOP_FaceAreaBuilder();
  
//! Creates the object to build faces on the (wires,blocks of edge) <br>
//! of <LS>, using the classifier <LC>. <br>
  Standard_EXPORT   BOP_FaceAreaBuilder(BOP_LoopSet& LS,BOP_LoopClassifier& LC,const Standard_Boolean ForceClass = Standard_False);
  
//! Initializes the object to build faces on the (wires,blocks of edge) <br>
//! of <LS>, using the classifier <LC>. <br>
  Standard_EXPORT     void InitFaceAreaBuilder(BOP_LoopSet& LS,BOP_LoopClassifier& LC,const Standard_Boolean ForceClass = Standard_False) ;





protected:





private:





};





// other Inline functions and methods (like "C++: function call" methods)


#endif
