// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESGeom_SurfaceOfRevolution_HeaderFile
#define _IGESGeom_SurfaceOfRevolution_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESGeom_SurfaceOfRevolution_HeaderFile
#include <Handle_IGESGeom_SurfaceOfRevolution.hxx>
#endif

#ifndef _Handle_IGESGeom_Line_HeaderFile
#include <Handle_IGESGeom_Line.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
class IGESGeom_Line;
class IGESData_IGESEntity;


//! defines IGESSurfaceOfRevolution, Type <120> Form <0> <br>
//!          in package IGESGeom <br>
//!          A surface of revolution is defined by an axis of rotation <br>
//!          a generatrix, and start and terminate rotation angles. The <br>
//!          surface is created by rotating the generatrix about the axis <br>
//!          of rotation through the start and terminate rotation angles. <br>
class IGESGeom_SurfaceOfRevolution : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESGeom_SurfaceOfRevolution();

//! This method is used to set the fields of the class Line <br>
//!       - anAxis      : Axis of revolution <br>
//!       - aGeneratrix : The curve which is revolved about the axis <br>
//!       - aStartAngle : Start angle of the surface of revolution <br>
//!       - anEndAngle  : End angle of the surface of revolution <br>
Standard_EXPORT   void Init(const Handle(IGESGeom_Line)& anAxis,const Handle(IGESData_IGESEntity)& aGeneratrix,const Standard_Real aStartAngle,const Standard_Real anEndAngle) ;

//! returns the axis of revolution <br>
Standard_EXPORT   Handle_IGESGeom_Line AxisOfRevolution() const;

//! returns the curve which is revolved about the axis <br>
Standard_EXPORT   Handle_IGESData_IGESEntity Generatrix() const;

//! returns start angle of revolution <br>
Standard_EXPORT   Standard_Real StartAngle() const;

//! returns end angle of revolution <br>
Standard_EXPORT   Standard_Real EndAngle() const;
//Standard_EXPORT ~IGESGeom_SurfaceOfRevolution();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IGESGeom_Line theLine;
Handle_IGESData_IGESEntity theGeneratrix;
Standard_Real theStartAngle;
Standard_Real theEndAngle;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
