// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _HLRBRep_CLPropsATool_HeaderFile
#define _HLRBRep_CLPropsATool_HeaderFile

#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class gp_Pnt2d;
class gp_Vec2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class HLRBRep_CLPropsATool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! Computes the  point <P> of  parameter <U>   on the <br>
//!          Curve from HLRBRep <C>. <br>
static  void Value(const Standard_Address A,const Standard_Real U,gp_Pnt2d& P) ;
//! Computes the point <P>  and  first derivative <V1> <br>
//!          of parameter <U> on the curve <C>. <br>
static  void D1(const Standard_Address A,const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1) ;
//! Computes the point <P>,  the first derivative <V1> <br>
//!          and second derivative <V2> of parameter <U> on the <br>
//!          curve <C>. <br>
static  void D2(const Standard_Address A,const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1,gp_Vec2d& V2) ;
//! Computes the point <P>, the first derivative <V1>, <br>
//!          the second derivative  <V2>   and third derivative <br>
//!          <V3> of parameter <U> on the curve <C>. <br>
static  void D3(const Standard_Address A,const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1,gp_Vec2d& V2,gp_Vec2d& V3) ;
//! returns the order  of continuity of the curve <C>. <br>
//!          returns 1 :  first  derivative only is  computable <br>
//!          returns 2  : first and  second derivative only are <br>
//!          computable.  returns  3 : first,  second and third <br>
//!          are computable. <br>
static  Standard_Integer Continuity(const Standard_Address A) ;
//! returns the first parameter bound of the curve. <br>
//! <br>
static  Standard_Real FirstParameter(const Standard_Address A) ;
//! returns the  last  parameter bound  of  the curve. <br>
//!          FirstParameter must be less than LastParamenter. <br>
static  Standard_Real LastParameter(const Standard_Address A) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <HLRBRep_CLPropsATool.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
