// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic3d_Vector_HeaderFile
#define _Graphic3d_Vector_HeaderFile

#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Graphic3d_VectorError;
class Graphic3d_Vertex;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class allows the creation and update <br>
//!	    of a 3D vector. <br>
class Graphic3d_Vector  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a vector with 1.0, 0.0, 0.0 coordinates. <br>
Standard_EXPORT Graphic3d_Vector();

//! Creates a vector with <AX>, <AY>, <AZ> coordinates. <br>
Standard_EXPORT Graphic3d_Vector(const Standard_Real AX,const Standard_Real AY,const Standard_Real AZ);

//! Creates a vector from 2 points <APoint1> and <APoint2>. <br>
Standard_EXPORT Graphic3d_Vector(const Graphic3d_Vertex& APoint1,const Graphic3d_Vertex& APoint2);

//! Normalises <me>. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises VectorError if <me> is null. <br>
Standard_EXPORT   void Normalize() ;

//! Modifies the coordinates of the vector <me>. <br>
Standard_EXPORT   void SetCoord(const Standard_Real Xnew,const Standard_Real Ynew,const Standard_Real Znew) ;

//! Modifies the X coordinate of the vector <me>. <br>
Standard_EXPORT   void SetXCoord(const Standard_Real Xnew) ;

//! Modifies the Y coordinate of the vector <me>. <br>
Standard_EXPORT   void SetYCoord(const Standard_Real Ynew) ;

//! Modifies the Z coordinate of the vector <me>. <br>
Standard_EXPORT   void SetZCoord(const Standard_Real Znew) ;

//! Returns the coordinates of the vector <me>. <br>
Standard_EXPORT   void Coord(Standard_Real& AX,Standard_Real& AY,Standard_Real& AZ) const;

//! Returns Standard_True if <me> has length 1. <br>
Standard_EXPORT   Standard_Boolean IsNormalized() const;

//! Returns Standard_True if <me> has length zero. <br>
Standard_EXPORT   Standard_Boolean LengthZero() const;

//! Returns the X coordinates of the vector <me>. <br>
Standard_EXPORT   Standard_Real X() const;

//! Returns the Y coordinate of the vector <me>. <br>
Standard_EXPORT   Standard_Real Y() const;

//! Returns the Z coordinate of the vector <me>. <br>
Standard_EXPORT   Standard_Real Z() const;

//! Returns Standard_True if the vector <AV1> and <br>
//!	    <AV2> are parallel. <br>
Standard_EXPORT static  Standard_Boolean IsParallel(const Graphic3d_Vector& AV1,const Graphic3d_Vector& AV2) ;

//! Returns the norm of the vector <AX>, <AY>, <AZ>. <br>
Standard_EXPORT static  Standard_Real NormeOf(const Standard_Real AX,const Standard_Real AY,const Standard_Real AZ) ;

//! Returns the norm of the vector <AVector>. <br>
Standard_EXPORT static  Standard_Real NormeOf(const Graphic3d_Vector& AVector) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_ShortReal MyX;
Standard_ShortReal MyY;
Standard_ShortReal MyZ;
Standard_ShortReal MyNorme;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
