// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomConvert_CompBezierSurfacesToBSplineSurface_HeaderFile
#define _GeomConvert_CompBezierSurfacesToBSplineSurface_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_TColgp_HArray2OfPnt_HeaderFile
#include <Handle_TColgp_HArray2OfPnt.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
class TColStd_HArray1OfInteger;
class TColStd_HArray1OfReal;
class TColgp_HArray2OfPnt;
class Standard_DimensionError;
class Standard_NotImplemented;
class Standard_ConstructionError;
class TColGeom_Array2OfBezierSurface;
class TColStd_Array1OfReal;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! An algorithm to convert a grid of adjacent <br>
//! non-rational Bezier surfaces into a BSpline surface. <br>
//! A CompBezierSurfacesToBSplineSurface object <br>
//! provides a framework for: <br>
//! -   defining the grid of adjacent Bezier surfaces <br>
//!   which is to be converted into a BSpline surface, <br>
//! -   implementing the computation algorithm, and <br>
//! -   consulting the results. <br>
//! Warning <br>
//! Do not attempt to convert rational Bezier surfaces using such an algorithm. <br>
//! Input is array of Bezier patch <br>
//!           1    2    3     4  -> VIndex [1, NbVPatches] -> VDirection <br>
//!         ----------------------- <br>
//!    1    |    |    |    |      | <br>
//!         ----------------------- <br>
//!    2    |    |    |    |      | <br>
//!         ----------------------- <br>
//!    3    |    |    |    |      | <br>
//!         ----------------------- <br>
//!  UIndex [1, NbUPatches]  Udirection <br>
//! <br>
//!  Warning! Patches must have compatible parametrization <br>
class GeomConvert_CompBezierSurfacesToBSplineSurface  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//!  Computes all the data needed to build a "C0" <br>
//! continuous BSpline surface equivalent to the grid of <br>
//! adjacent non-rational Bezier surfaces Beziers. <br>
//! Each surface in the Beziers grid becomes a natural <br>
//! patch, limited by knots values, on the BSpline surface <br>
//! whose data is computed. Surfaces in the grid must <br>
//! satisfy the following conditions: <br>
//! -   Coincident bounding curves between two <br>
//!   consecutive surfaces in a row of the Beziers grid <br>
//!   must be u-isoparametric bounding curves of these two surfaces. <br>
//! -   Coincident bounding curves between two <br>
//!   consecutive surfaces in a column of the Beziers <br>
//!   grid must be v-isoparametric bounding curves of these two surfaces. <br>
//!   The BSpline surface whose data is computed has the <br>
//! following characteristics: <br>
//! -   Its degree in the u (respectively v) parametric <br>
//!   direction is equal to that of the Bezier surface <br>
//!   which has the highest degree in the u <br>
//!   (respectively v) parametric direction in the Beziers grid. <br>
//! -   It is a "Piecewise Bezier" in both u and v <br>
//!   parametric directions, i.e.: <br>
//!   -   the knots are regularly spaced in each <br>
//!    parametric direction (i.e. the difference between <br>
//!    two consecutive knots is a constant), and <br>
//!   -   all the multiplicities of the surface knots in a <br>
//!    given parametric direction are equal to <br>
//!    Degree, which is the degree of the BSpline <br>
//!    surface in this parametric direction, except for <br>
//!    the first and last knots for which the multiplicity is <br>
//!    equal to Degree + 1. <br>
//! -   Coincident bounding curves between two <br>
//!   consecutive columns of Bezier surfaces in the <br>
//!   Beziers grid become u-isoparametric curves, <br>
//!   corresponding to knots values of the BSpline surface. <br>
//! -   Coincident bounding curves between two <br>
//!   consecutive rows of Bezier surfaces in the Beziers <br>
//!   grid become v-isoparametric curves <br>
//!   corresponding to knots values of the BSpline surface. <br>
//!  Use the available consultation functions to access the <br>
//!  computed data. This data may be used to construct the BSpline surface. <br>
//! Warning <br>
//! The surfaces in the Beziers grid must be adjacent, i.e. <br>
//! two consecutive Bezier surfaces in the grid (in a row <br>
//! or column) must have a coincident bounding curve. In <br>
//! addition, the location of the parameterization on each <br>
//! of these surfaces (i.e. the relative location of u and v <br>
//! isoparametric curves on the surface) is of importance <br>
//! with regard to the positioning of the surfaces in the <br>
//! Beziers grid. Care must be taken with respect to the <br>
//! above, as these properties are not checked and an <br>
//! error may occur if they are not satisfied. <br>
//! Exceptions <br>
//! Standard_NotImplemented if one of the Bezier <br>
//! surfaces of the Beziers grid is rational. <br>
Standard_EXPORT GeomConvert_CompBezierSurfacesToBSplineSurface(const TColGeom_Array2OfBezierSurface& Beziers);

//! Build an Ci uniform (Rational) BSpline surface <br>
//!           The higest Continuity Ci is imposed, like the <br>
//!           maximal deformation is lower than <Tolerance>. <br>
//!  Warning:  The Continuity C0 is imposed without any check. <br>
Standard_EXPORT GeomConvert_CompBezierSurfacesToBSplineSurface(const TColGeom_Array2OfBezierSurface& Beziers,const Standard_Real Tolerance,const Standard_Boolean RemoveKnots = Standard_True);

//!  Computes all the data needed to construct a BSpline <br>
//! surface equivalent to the adjacent non-rational <br>
//! Bezier surfaces Beziers grid. <br>
//! Each surface in the Beziers grid becomes a natural <br>
//! patch, limited by knots values, on the BSpline surface <br>
//! whose data is computed. Surfaces in the grid must <br>
//! satisfy the following conditions: <br>
//! -   Coincident bounding curves between two <br>
//!   consecutive surfaces in a row of the Beziers grid <br>
//!   must be u-isoparametric bounding curves of these two surfaces. <br>
//! -   Coincident bounding curves between two <br>
//!   consecutive surfaces in a column of the Beziers <br>
//! grid must be v-isoparametric bounding curves of these two surfaces. <br>
//!   The BSpline surface whose data is computed has the <br>
//! following characteristics: <br>
//! -   Its degree in the u (respectively v) parametric <br>
//!   direction is equal to that of the Bezier surface <br>
//!   which has the highest degree in the u <br>
//!   (respectively v) parametric direction in the Beziers grid. <br>
//! -   Coincident bounding curves between two <br>
//!   consecutive columns of Bezier surfaces in the <br>
//!   Beziers grid become u-isoparametric curves <br>
//!   corresponding to knots values of the BSpline surface. <br>
//! -   Coincident bounding curves between two <br>
//!   consecutive rows of Bezier surfaces in the Beziers <br>
//!   grid become v-isoparametric curves <br>
//!   corresponding to knots values of the BSpline surface. <br>
//! Knots values of the BSpline surface are given in the two tables: <br>
//! -   UKnots for the u parametric direction (which <br>
//!   corresponds to the order of Bezier surface columns in the Beziers grid), and <br>
//! -   VKnots for the v parametric direction (which <br>
//!  corresponds to the order of Bezier surface rows in the Beziers grid). <br>
//!   The dimensions of UKnots (respectively VKnots) <br>
//! must be equal to the number of columns (respectively, <br>
//! rows) of the Beziers grid, plus 1 . <br>
//! UContinuity and VContinuity, which are both <br>
//! defaulted to GeomAbs_C0, specify the required <br>
//! continuity on the BSpline surface. If the required <br>
//! degree of continuity is greater than 0 in a given <br>
//! parametric direction, a deformation is applied locally <br>
//! on the initial surface (as defined by the Beziers grid) <br>
//! to satisfy this condition. This local deformation is not <br>
//! applied however, if it is greater than Tolerance <br>
//! (defaulted to 1.0 e-7). In such cases, the <br>
//! continuity condition is not satisfied, and the function <br>
//! IsDone will return false. A small tolerance value <br>
//! prevents any modification of the surface and a large <br>
//! tolerance value "smoothes" the surface. <br>
//! Use the available consultation functions to access the <br>
//! computed data. This data may be used to construct the BSpline surface. <br>
//! Warning <br>
//! The surfaces in the Beziers grid must be adjacent, i.e. <br>
//! two consecutive Bezier surfaces in the grid (in a row <br>
//! or column) must have a coincident bounding curve. In <br>
//! addition, the location of the parameterization on each <br>
//! of these surfaces (i.e. the relative location of u and v <br>
//! isoparametric curves on the surface) is of importance <br>
//! with regard to the positioning of the surfaces in the <br>
//! Beziers grid. Care must be taken with respect to the <br>
//! above, as these properties are not checked and an <br>
//! error may occur if they are not satisfied. <br>
//! Exceptions <br>
//! Standard_DimensionMismatch: <br>
//! -   if the number of knots in the UKnots table (i.e. the <br>
//!   length of the UKnots array) is not equal to the <br>
//!   number of columns of Bezier surfaces in the <br>
//!   Beziers grid plus 1, or <br>
//! -   if the number of knots in the VKnots table (i.e. the <br>
//!   length of the VKnots array) is not equal to the <br>
//!   number of rows of Bezier surfaces in the Beziers grid, plus 1. <br>
//!   Standard_ConstructionError: <br>
//! -   if UContinuity and VContinuity are not equal to <br>
//!   one of the following values: GeomAbs_C0, <br>
//!   GeomAbs_C1, GeomAbs_C2 and GeomAbs_C3; or <br>
//! -   if the number of columns in the Beziers grid is <br>
//!   greater than 1, and the required degree of <br>
//!   continuity in the u parametric direction is greater <br>
//!   than that of the Bezier surface with the highest <br>
//!   degree in the u parametric direction (in the Beziers grid), minus 1; or <br>
//! -   if the number of rows in the Beziers grid is <br>
//!   greater than 1, and the required degree of <br>
//!   continuity in the v parametric direction is greater <br>
//!   than that of the Bezier surface with the highest <br>
//!   degree in the v parametric direction (in the Beziers grid), minus 1 . <br>
//!   Standard_NotImplemented if one of the Bezier <br>
//! surfaces in the Beziers grid is rational. <br>
Standard_EXPORT GeomConvert_CompBezierSurfacesToBSplineSurface(const TColGeom_Array2OfBezierSurface& Beziers,const TColStd_Array1OfReal& UKnots,const TColStd_Array1OfReal& VKnots,const GeomAbs_Shape UContinuity = GeomAbs_C0,const GeomAbs_Shape VContinuity = GeomAbs_C0,const Standard_Real Tolerance = 1.0e-4);
//!  Returns the number of knots in the U direction <br>
//! of the BSpline surface whose data is computed in this framework. <br>
  Standard_Integer NbUKnots() const;
//! Returns number of poles in the U direction <br>
//! of the BSpline surface whose data is computed in this framework. <br>
  Standard_Integer NbUPoles() const;
//! Returns the number of knots in the V direction <br>
//! of the BSpline surface whose data is computed in this framework. <br>
  Standard_Integer NbVKnots() const;
//! Returns the number of poles in the V direction <br>
//! of the BSpline surface whose data is computed in this framework. <br>
  Standard_Integer NbVPoles() const;
//!  Returns the table of poles of the BSpline surface <br>
//! whose data is computed in this framework. <br>
 const Handle_TColgp_HArray2OfPnt& Poles() const;
//! Returns the knots table for the u parametric <br>
//! direction of the BSpline surface whose data is computed in this framework. <br>
 const Handle_TColStd_HArray1OfReal& UKnots() const;
//! Returns the degree for the u  parametric <br>
//! direction of the BSpline surface whose data is computed in this framework. <br>
  Standard_Integer UDegree() const;
//! Returns the knots table for the v parametric <br>
//! direction of the BSpline surface whose data is computed in this framework. <br>
 const Handle_TColStd_HArray1OfReal& VKnots() const;
//! Returns the degree for the v  parametric <br>
//! direction of the BSpline surface whose data is computed in this framework. <br>
  Standard_Integer VDegree() const;

//! Returns the multiplicities table for the u <br>
//! parametric direction of the knots of the BSpline <br>
//! surface whose data is computed in this framework. <br>
 const Handle_TColStd_HArray1OfInteger& UMultiplicities() const;
//! -- Returns the multiplicities table for the v <br>
//! parametric direction of the knots of the BSpline <br>
//! surface whose data is computed in this framework. <br>
 const Handle_TColStd_HArray1OfInteger& VMultiplicities() const;

//! Returns true if the conversion was successful. <br>
//! Unless an exception was raised at the time of <br>
//! construction, the conversion of the Bezier surface <br>
//! grid assigned to this algorithm is always carried out. <br>
//! IsDone returns false if the constraints defined at the <br>
//! time of construction cannot be respected. This occurs <br>
//! when there is an incompatibility between a required <br>
//! degree of continuity on the BSpline surface, and the <br>
//! maximum tolerance accepted for local deformations <br>
//! of the surface. In such a case the computed data <br>
//! does not satisfy all the initial constraints. <br>
Standard_EXPORT   Standard_Boolean IsDone() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//!  It used internaly by the constructors. <br>
Standard_EXPORT   void Perform(const TColGeom_Array2OfBezierSurface& Beziers) ;


 // Fields PRIVATE
 //
Standard_Integer myUDegree;
Standard_Integer myVDegree;
Handle_TColStd_HArray1OfInteger myVMults;
Handle_TColStd_HArray1OfInteger myUMults;
Handle_TColStd_HArray1OfReal myUKnots;
Handle_TColStd_HArray1OfReal myVKnots;
Handle_TColgp_HArray2OfPnt myPoles;
Standard_Boolean isrational;
Standard_Boolean myDone;


};


#include <GeomConvert_CompBezierSurfacesToBSplineSurface.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
