// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _DsgPrs_DiameterPresentation_HeaderFile
#define _DsgPrs_DiameterPresentation_HeaderFile

#ifndef _Handle_Prs3d_Presentation_HeaderFile
#include <Handle_Prs3d_Presentation.hxx>
#endif
#ifndef _Handle_Prs3d_Drawer_HeaderFile
#include <Handle_Prs3d_Drawer.hxx>
#endif
#ifndef _DsgPrs_ArrowSide_HeaderFile
#include <DsgPrs_ArrowSide.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Prs3d_Presentation;
class Prs3d_Drawer;
class TCollection_ExtendedString;
class gp_Pnt;
class gp_Circ;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A framework for displaying diameters in shapes. <br>
class DsgPrs_DiameterPresentation  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Draws the diameter of the circle aCircle displayed in <br>
//! the presentation aPresentation and with attributes <br>
//! defined by the attribute manager aDrawer. The point <br>
//! AttachmentPoint defines the point of contact <br>
//! between the circle and the diameter presentation. <br>
//! The value of the enumeration ArrowSide controls <br>
//! whether arrows will be displayed at either or both <br>
//! ends of the length. The text aText labels the diameter. <br>
Standard_EXPORT static  void Add(const Handle(Prs3d_Presentation)& aPresentation,const Handle(Prs3d_Drawer)& aDrawer,const TCollection_ExtendedString& aText,const gp_Pnt& AttachmentPoint,const gp_Circ& aCircle,const DsgPrs_ArrowSide ArrowSide,const Standard_Boolean IsDiamSymbol) ;

//! Draws the diameter of the arc anArc displayed in the <br>
//! presentation aPresentation and with attributes <br>
//! defined by the attribute manager aDrawer. The point <br>
//! AttachmentPoint defines the point of contact <br>
//! between the arc and the diameter presentation. The <br>
//! value of the enumeration ArrowSide controls whether <br>
//! arrows will be displayed at either or both ends of the <br>
//! length. The parameters uFirst and uLast define the <br>
//! first and last points of the arc. The text aText labels the diameter. <br>
Standard_EXPORT static  void Add(const Handle(Prs3d_Presentation)& aPresentation,const Handle(Prs3d_Drawer)& aDrawer,const TCollection_ExtendedString& aText,const gp_Pnt& AttachmentPoint,const gp_Circ& aCircle,const Standard_Real uFirst,const Standard_Real uLast,const DsgPrs_ArrowSide ArrowSide,const Standard_Boolean IsDiamSymbol) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
