// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_ShellSolid_HeaderFile
#define _BOP_ShellSolid_HeaderFile

#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BOP_Builder_HeaderFile
#include <BOP_Builder.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _BOP_Operation_HeaderFile
#include <BOP_Operation.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
#ifndef _Handle_BOP_HistoryCollector_HeaderFile
#include <Handle_BOP_HistoryCollector.hxx>
#endif
class BOPTools_DSFiller;
class BOP_WireEdgeSet;
class TopTools_IndexedMapOfShape;
class TopTools_IndexedDataMapOfShapeListOfShape;
class TColStd_IndexedMapOfInteger;
class TopoDS_Shape;
class TopoDS_Edge;
class TopoDS_Face;
class TopoDS_Shell;
class TopTools_ListOfShape;
class TopTools_DataMapOfShapeInteger;
class BOP_HistoryCollector;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! Performs  Boolean Operations  (BO) <br>
//!  Common,Cut,Fuse for arguments of <br>
//!  shell/solid type <br>
class BOP_ShellSolid  : public BOP_Builder {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor; <br>
Standard_EXPORT BOP_ShellSolid();


//! see base  classes, please <br>
Standard_EXPORT virtual  void Do() ;


//! see base  classes, please <br>
Standard_EXPORT virtual  void DoWithFiller(const BOPTools_DSFiller& aDSF) ;


//! Destructor <br>
Standard_EXPORT virtual  void Destroy() ;
Standard_EXPORT virtual ~BOP_ShellSolid(){Destroy();}


//! see base  classes, please <br>
Standard_EXPORT virtual  void BuildResult() ;


//! see base  classes, please <br>
Standard_EXPORT virtual  void DoNewFaces() ;


//! Provides some preparing steps of algorithm <br>
//! 1.  Compute the 3D-States <br>
//! 2.  Compute P-Curves for section- and split- edges <br>
//! 3.  Treat degenerated edges <br>
//! 4   Detect Same Domain faces <br>
Standard_EXPORT virtual  void Prepare() ;


//! Check the types of arguments. <br>
//! Returns  FALSE if types of arguments <br>
//! are non-valid to be  treated by the <br>
//! agorithm <br>
Standard_EXPORT static  Standard_Boolean CheckArgTypes(const TopAbs_ShapeEnum theType1,const TopAbs_ShapeEnum theType2,const BOP_Operation theOperation) ;


//! Check the types of arguments. <br>
//! Returns  FALSE if types of arguments <br>
//! are non-valid to be  treated by the <br>
//! agorithm <br>
Standard_EXPORT   Standard_Boolean CheckArgTypes() const;


Standard_EXPORT   Standard_Boolean SplitFace(const Standard_Integer theFaceIndex,TopTools_DataMapOfShapeInteger& theMapOfEdgeIndex,TopTools_ListOfShape& theListOfFace) const;


Standard_EXPORT virtual  void SetHistoryCollector(const Handle(BOP_HistoryCollector)& theHistory) ;





protected:

 // Methods PROTECTED
 // 


//! The algo to find SameDomain Faces <br>
//! among interferred ones <br>
Standard_EXPORT   void DetectSDFaces() ;


Standard_EXPORT   void AddSplitPartsINOUT(const Standard_Integer nF1,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddSectionPartsSh(const Standard_Integer nF1,const Standard_Integer iFF,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddSplitPartsONSh(const Standard_Integer nF1,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddPartsEFSh(const Standard_Integer nF1,const Standard_Integer iFF,TopTools_IndexedMapOfShape& anEMap,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddINON2DPartsSh(const Standard_Integer nF1,const Standard_Integer iFF,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddPartsEFNonSDSh(const Standard_Integer nF1,const Standard_Integer iFF,TopTools_IndexedMapOfShape& anEMap,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddPartsEENonSDSh(const Standard_Integer nF1,const Standard_Integer iFF,TopTools_IndexedMapOfShape& anEMap,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddSectionPartsSo(const Standard_Integer nF1,const Standard_Integer iFF,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddSplitPartsON3DSo(const Standard_Integer nF1,const Standard_Integer iFF,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddSplitPartsONSo(const Standard_Integer nF1,const TopTools_IndexedDataMapOfShapeListOfShape& aMEFObj,const TopTools_IndexedDataMapOfShapeListOfShape& aMEFTool,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddPartsEFSo(const Standard_Integer nF1,const Standard_Integer iFF,const TopTools_IndexedDataMapOfShapeListOfShape& aMEFObj,const TopTools_IndexedDataMapOfShapeListOfShape& aMEFTool,TopTools_IndexedMapOfShape& anEMap,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddINON2DPartsSo(const Standard_Integer iFF,const Standard_Integer nF1,const Standard_Integer nF2,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddPartsEFSDSo(const Standard_Integer nF1,const Standard_Integer iFF,const TopTools_IndexedDataMapOfShapeListOfShape& aMEFObj,const TopTools_IndexedDataMapOfShapeListOfShape& aMEFTool,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddPartsEFNonSDSo(const Standard_Integer nF1,const Standard_Integer iFF,const TopTools_IndexedDataMapOfShapeListOfShape& aMEFObj,const TopTools_IndexedDataMapOfShapeListOfShape& aMEFTool,const TColStd_IndexedMapOfInteger& aFFInMap,TopTools_IndexedMapOfShape& anEMap,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddPartsEENonSDSo(const Standard_Integer nF1,const Standard_Integer iFF,const TopTools_IndexedDataMapOfShapeListOfShape& aMEFObj,const TopTools_IndexedDataMapOfShapeListOfShape& aMEFTool,const TColStd_IndexedMapOfInteger& aFFInMap,TopTools_IndexedMapOfShape& anEMap,BOP_WireEdgeSet& aWES) ;


Standard_EXPORT   void AddPartsEESDSo(const Standard_Integer nF1,const Standard_Integer iFF,const TopTools_IndexedDataMapOfShapeListOfShape& aMEFObj,const TopTools_IndexedDataMapOfShapeListOfShape& aMEFTool,BOP_WireEdgeSet& aWES) ;


//! Internal usage <br>
Standard_EXPORT static  void Path(const TopoDS_Shape& aE,const TopTools_IndexedDataMapOfShapeListOfShape& aEFMap,TopTools_IndexedMapOfShape& aFaces,TopTools_IndexedMapOfShape& aProcE) ;


//! Internal usage <br>
Standard_EXPORT static  TopAbs_Orientation Orientation(const TopoDS_Edge& aE,const TopoDS_Face& aF) ;


Standard_EXPORT static  void OrientFacesOnShell(const TopoDS_Shell& aShell,TopoDS_Shell& aShellNew) ;


//! Internal usage <br>
Standard_EXPORT   void DoInternalVertices(const Standard_Integer nF1,const TopTools_ListOfShape& aFaces) ;


//! Internal usage <br>
Standard_EXPORT  const TopTools_ListOfShape& Internals() const;


//! Internal usage <br>
Standard_EXPORT   void CollectInternals() ;


//! Internal usage <br>
Standard_EXPORT   void FillSectionEdges() ;


 // Fields PROTECTED
 //
TopoDS_Face myFace;
TopTools_ListOfShape myNewFaces;
TopTools_ListOfShape myInternals;
Standard_Integer myRank;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
