/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2011  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD2JPCOMMON_RULE_H
#define NJD2JPCOMMON_RULE_H

#ifdef __cplusplus
#define NJD2JPCOMMON_RULE_H_START extern "C" {
#define NJD2JPCOMMON_RULE_H_END   }
#else
#define NJD2JPCOMMON_RULE_H_START
#define NJD2JPCOMMON_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD2JPCOMMON_RULE_H_START;

static const char *njd2jpcommon_pos_list[] = {
   "¾", "", "*", "*", "¾",
   "ե顼", "*", "*", "*", "ư",
   "ư", "*", "*", "*", "ư",
   "", "ե٥å", "*", "*", "",
   "", "", "*", "*", "",
   "", "̳", "*", "*", "",
   "", "", "*", "*", "",
   "", "", "*", "*", "",
   "", "", "*", "*", "",
   "", "", "*", "*", "",
   "ƻ", "Ω", "*", "*", "ƻ",
   "ƻ", "", "*", "*", "-ƻŪ",
   "ƻ", "Ω", "*", "*", "ƻ",
   "", "ʽ", "", "*", "-ʽ",
   "", "ʽ", "", "*", "-ʽ",
   "", "ʽ", "Ϣ", "*", "-ʽ",
   "", "", "*", "*", "-",
   "", "", "*", "*", "-",
   "", "³", "*", "*", "-³",
   "", "ü", "*", "*", "-¾",
   "", "첽", "*", "*", "-¾",
   "", "", "*", "*", "-",
   "", "졿Ω졿", "*", "*", "-¾",
   "", "Ω", "*", "*", "-¾",
   "", "Ϣβ", "*", "*", "-¾",
   "ư", "*", "*", "*", "ư",
   "³", "*", "*", "*", "³",
   "Ƭ", "ƻ³", "*", "*", "Ƭ",
   "Ƭ", "³", "*", "*", "Ƭ",
   "Ƭ", "ư³", "*", "*", "Ƭ",
   "Ƭ", "̾³", "*", "*", "Ƭ",
   "ư", "Ω", "*", "*", "ư",
   "ư", "", "*", "*", "-ưŪ",
   "ư", "Ω", "*", "*", "ư-Ω",
   "", "*", "*", "*", "",
   "", "", "*", "*", "",
   "", "³", "*", "*", "",
   "̾", "³", "*", "*", "̾-³",
   "̾", "ʥƻ촴", "*", "*", "̾-̾",
   "̾", "", "*", "*", "̾-̾",
   "̾", "ʸ", "*", "*", "̾-̾",
   "̾", "ư촴", "*", "*", "",
   "̾", "ͭ̾", "", "*", "̾-ͭ̾",
   "̾", "ͭ̾", "̾", "", "̾-ͭ̾",
   "̾", "ͭ̾", "̾", "", "̾-ͭ̾",
   "̾", "ͭ̾", "̾", "̾", "̾-ͭ̾",
   "̾", "ͭ̾", "ȿ", "*", "̾-ͭ̾",
   "̾", "ͭ̾", "ϰ", "", "̾-ͭ̾",
   "̾", "ͭ̾", "ϰ", "", "̾-ͭ̾",
   "̾", "", "*", "*", "̾-",
   "̾", "³Ū", "*", "*", "̾-̾",
   "̾", "", "³", "*", "-̾Ū",
   "̾", "", "", "*", "-̾Ū",
   "̾", "", "ư촴", "*", "-Ū",
   "̾", "", "", "*", "-̾Ū",
   "̾", "", "ư촴", "*", "-̾Ū",
   "̾", "", "̾", "*", "-̾Ū",
   "̾", "", "ϰ", "*", "-̾Ū",
   "̾", "", "ü", "*", "-̾Ū",
   "̾", "", "ǽ", "*", "-̾Ū",
   "̾", "̾", "", "*", "̾",
   "̾", "̾", "", "*", "̾",
   "̾", "ưΩŪ", "*", "*", "̾-̾",
   "̾", "ü", "ư촴", "*", "̾-̾",
   "̾", "Ω", "", "*", "̾-Ω",
   "̾", "Ω", "ư촴", "*", "̾-Ω",
   "̾", "Ω", "ư촴", "*", "̾-Ω",
   "̾", "Ω", "ǽ", "*", "̾-Ω",
   "̾", "ǽ", "*", "*", "̾-̾",
   "Ϣλ", "*", "*", "*", "Ϣλ",
   NULL, NULL, NULL, NULL, NULL
};

static const char *njd2jpcommon_cform_list[] = {
   "*", "*",
   "³", "¾",
   "شܷ", "ܷ",
   "", "",
   "", "",
   "", "",
   "ܷ", "ܷ",
   "ܷ-¥", "ܷ",
   "ܷ", "ܷ",
   "θ³", "Ϣη",
   "θ³ü", "Ϣη",
   "θ³ü죲", "Ϣη",
   "ʸܷ", "ܷ",
   "̤³", "̤",
   "̤³", "̤",
   "̤³", "̤",
   "̤", "̤",
   "̤ü", "̤",
   "̿", "̿",
   "̿", "̿",
   "̿", "̿",
   "̿", "̿",
   "Ϣѥ³", "Ϣѷ",
   "Ϣѥ³", "Ϣѷ",
   "Ϣѥ³", "Ϣѷ",
   "Ϣѥ³", "Ϣѷ",
   "Ϣѥ³", "Ϣѷ",
   "Ϣѷ", "Ϣѷ",
   NULL, NULL
};

static const char *njd2jpcommon_ctype_list[] = {
   "*", "*",
   "ѡ", "ѳ",
   "ѡ", "ѳ",
   "ѡݥ", "ѳ",
   "ѡݥ", "ѳ",
   "ѡ", "ѳ",
   "", "ѳ",
   "", "",
   "ʡ", "",
   "ʡ", "",
   "󡦥", "",
   "󡦥", "",
   "󡦥", "",
   "󡦥", "",
   "󡦥Ϲ", "",
   "󡦥޹", "",
   "", "",
   "ƻ졦", "ƻ",
   "ƻ졦", "ƻ",
   "ƻ졦", "ƻ",
   "ʡԥ", "",
   "ʡ¥", "",
   "ʡ¥إ楯", "",
   "ʡ", "",
   "ʡ", "",
   "ʡ", "",
   "ʡʹ", "",
   "ʡй", "",
   "ʡ޹", "",
   "ʡ", "",
   "ʡԥ", "",
   "ʡü", "",
   "ʡԥ", "",
   "ʡ¥", "",
   "ʡ", "",
   "ʡ", "",
   "ʡϹ", "",
   "ʡй", "",
   "󡦥", "",
   "󡦥Ϲ", "",
   "ü졦", "ư",
   "ü졦", "ư",
   "ü졦", "ư",
   "ü졦", "ư",
   "ü졦ǥ", "ư",
   "ü졦ʥ", "ư",
   "ü졦", "ư",
   "ü졦ޥ", "ư",
   "ü졦", "ư",
   "Ѳ", "Ѳ",
   "ʸ졦", "ʸư",
   "ʸ졦", "ʸư",
   "ʸ졦ȥ", "ʸư",
   "ʸ졦ʥ", "ʸư",
   "ʸ졦٥", "ʸư",
   "ʸ졦ޥ", "ʸư",
   "ʸ졦", "ʸư",
   "ʸ졦", "ʸư",
   NULL, NULL
};

NJD2JPCOMMON_RULE_H_END;

#endif                          /* !NJD2JPCOMMON_RULE_H */
