/*
 *   OpenOffice.org extension for syntax highlighting
 *   Copyright (C) 2008  Cédric Bosdonnat cedricbosdo@openoffice.org
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; 
 *   version 2 of the License.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.openoffice.coooder.comp.test;

import java.io.File;
import java.io.FileInputStream;

import org.openoffice.coooder.XHighlighter;
import org.openoffice.coooder.XLanguage;
import org.openoffice.coooder.theLanguagesManager;
import org.openoffice.coooder.comp.test.base.UnoTestCase;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.FrameSearchFlag;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;


public class SyntaxTest extends UnoTestCase {

    public void testSyntaxHighlighting() {
        try {
            // Generate the document
            XTextDocument xDoc = generateDocument("css");
            
            // Highlight the selection
            highlight("css");

            // Compare with the geshi generated file
            compareWithGeshi(xDoc, "css");
        
        } catch (Exception e) {
            fail("Shouldn't have thrown an exception");
        }
    }

    private XTextDocument generateDocument(String pLanguage) throws Exception {
        // Create a new text document
        XTextDocument xDoc = loadDocument("private:factory/swriter");

        // Copy the test string in the document
        String testString = readTestFile(pLanguage);
        xDoc.getText().setString(testString);
        
        // Select the whole inserted text
        Object oController = xDoc.getCurrentController();
        XSelectionSupplier xSelSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(
                XSelectionSupplier.class, oController);
        xSelSupplier.select(xDoc.getText());
        
        return xDoc;
    }

    private void highlight(String pLanguage) throws Exception {
        XMultiComponentFactory xMngr = getContext().getServiceManager();
        Object oHighlighter = xMngr.createInstanceWithContext(
                "org.openoffice.coooder.Highlighter", getContext());
        XHighlighter xHL = (XHighlighter)UnoRuntime.queryInterface(XHighlighter.class, oHighlighter);
        
        XLanguage xLang = theLanguagesManager.get(getContext()).getLanguage(pLanguage);
        xHL.setLanguage(xLang);
        
        // There is no need of a progress monitor here.
        xHL.parse(null);
    }
    
    private void compareWithGeshi(XTextDocument pDoc, String pLanguage) {
        // TODO Load the HTML document generated by Geshi
        
        
        // TODO Loop over each character and compare its color, wont weight and slant
    }

    private String readTestFile(String pLanguage) throws Exception {
        String pwd = System.getenv("user.dir");
        File file = new File(pwd, pLanguage + ".txt");
        
        FileInputStream fi = new FileInputStream(file);
        byte[] buf = new byte[fi.available()];
        fi.read(buf);
        String text = new String(buf);
        
        return text;
    }

    private XTextDocument loadDocument(String pUrl) throws Exception {
        XMultiComponentFactory xMngr = getContext().getServiceManager();
        Object oDesktop = xMngr.createInstanceWithContext("com.sun.star.frame.Desktop", getContext());
        XComponentLoader xLoader = (XComponentLoader)UnoRuntime.queryInterface(
                XComponentLoader.class, oDesktop);

        XComponent xDoc = xLoader.loadComponentFromURL(pUrl, "_default", 
                FrameSearchFlag.ALL, new PropertyValue[0]);
        
        XTextDocument xTextDoc = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, xDoc);
        return xTextDoc;
    }
}
