#include "vorbisDecoder.h"

#ifdef HAVE_LIBVORBIS

#include <iostream>
#include <sstream>
#include <string>

#include "vorbisStreamParameter.h"

VorbisDecoder::VorbisDecoder(int8 _streamID) :
    MediaOutputDecoder(_streamID), initCount(0)
{

}

VorbisDecoder::~VorbisDecoder()
{

  if (isConfigured()) {
    vorbis_info_clear(&vorbisInfo);
    vorbis_block_clear(&vorbisBlock);
    vorbis_dsp_clear(&vorbisDspState);
  }

}

std::string VorbisDecoder::getInfoString()
{
  return ("");

  /*  std::stringstream stream;

   stream << "Vorbis Stream";

   return(stream.str());
   */
}

void VorbisDecoder::initDecoder(StreamConfig& config, std::vector<OggComment>& oggComments)
{

  if (isConfigured()) {
    std::cerr << "VorbisDecoder: Decoder is still configured\n";
    return;
  }

  /* initialize the info and comment handler structs */
  vorbis_info_init(&vorbisInfo);
  vorbis_comment_init(&vorbisComment);

  /* initialize the packet counter */
  packetCount = 0;

  /* Konfiguration des Decoders */
  int retVal;
  for (uint8 i(0); i<config.headerList.size(); ++i) {

    /* Einfügen der Header
     * Fehlermeldung, wenn die Daten nicht zum aktuellen Codec passen */
    retVal = vorbis_synthesis_headerin(&vorbisInfo, &vorbisComment, config.headerList[i].obj());
    if (retVal < 0)
      throw "VorbisDecoder::initDecoder: packet is not a header\n";

  }

  /* extract the comments*/
  for (uint8 i(0); i<vorbisComment.comments; ++i) {
    /* We have to extract the tags by ourself - there is no interface :-(*/
    std::string commentStr(vorbisComment.user_comments[i],
                           vorbisComment.comment_lengths[i]);

    std::size_t commentSeparatorPos;
    if ((commentSeparatorPos = commentStr.find_first_of("="))
        != std::string::npos) {
      OggComment comment;
      comment.tag = commentStr.substr(0, commentSeparatorPos);
      comment.value = commentStr.substr(commentSeparatorPos+1,
                                        std::string::npos);
      oggComments.push_back(comment);
    }

  }

  /* finish initialization */
  vorbis_synthesis_init(&vorbisDspState,&vorbisInfo);
  vorbis_block_init(&vorbisDspState,&vorbisBlock);

  /*
  	config.type = ogg_vorbis;
  	VorbisStreamParameter* vorbisParam = new VorbisStreamParameter;

  	vorbisParam->samplerate = vorbisInfo.rate;
  	vorbisParam->datarate = vorbisInfo.bitrate_nominal;
  	vorbisParam->datarate = vorbisInfo.bitrate_nominal;

  	config.parameter = vorbisParam;
  */

  /* set the state machine */
  setConfigured();

}

MediaOutputDecoder& VorbisDecoder::operator<<(OggPacket packet)
{
  if (!isConfigured()) {
    std::cerr << "VorbisDecoder::operator<<: stream not configured\n";
    return(*this);
  }

  if (vorbis_synthesis(&vorbisBlock,packet.obj())==0)
    vorbis_synthesis_blockin(&vorbisDspState,&vorbisBlock);

  float** pcm;
  int samples;

  while ((samples=vorbis_synthesis_pcmout(&vorbisDspState,&pcm))>0) {
    AudioPacket apack(new AudioPacketInternal(pcm, samples, vorbisInfo.channels));
    packetList.push_back(apack);
    vorbis_synthesis_read(&vorbisDspState,samples);
  }


  /* has there not been a packet in the queue before */
  if (!packetList.empty()) {
    /* set the internal state */
    setAvailable();
  }

  /* count the audio packets, to have a glimps of the actual position */
  packetCount++;

  return(*this);
}

VorbisDecoder& VorbisDecoder::operator>>(AudioPacket& audioPacket)
{
  if (!isAvailable())
    throw "No audio packets available";

  audioPacket = packetList.front();
  packetList.pop_front();

  sampleCounter += (*audioPacket)->getLength();

  if (packetList.empty())
    setEmpty();

  return(*this);
}

vorbis_comment& VorbisDecoder::getComment()
{
  return (vorbisComment);
}

double VorbisDecoder::getTimeOfNextPacket()
{
  return (sampleCounter/vorbisInfo.rate);
}

#endif // WITH_LIBVORBIS
