/***************************************************************************
                          miview_fmri.h  -  description
                             -------------------
    begin                : Mon Jan 2 19:02:26 CEST 2006
    copyright            : (C) 2006 by Thies H. Jochimsen
    email                : jochimse@cns.mpg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIVIEW_FMRI_H
#define MIVIEW_FMRI_H

#include <odinpara/jdxnumbers.h>
#include <odinpara/jdxtypes.h>
#include <odinpara/jdxblock.h>
#include <odinpara/jdxarrays.h>

// forward declarations
class FileReadOpts;
class Protocol;
class FilterChain;
struct FmriData;

////////////////////////////////////////////////////////////

class MiViewFmri : public JcampDxBlock {

 public:
  MiViewFmri();
  ~MiViewFmri();

  bool init(const FileReadOpts& ropts, const Protocol& prot, const FilterChain& filterchain);

  bool is_valid() const {return valid;}

  const farray& get_overlay_map() const;

  void update();

 private:
  JDXstring designfile;
  JDXstring fmrifile;
  JDXstring maskfile;
  JDXbool bonferr;
  JDXbool hrf;
  JDXfloat corr;
  JDXfloat zscore;
  JDXint designavg;
  JDXint neighb;
  JDXstring sigchange;
  JDXfloat zsum;
  JDXint zcount;
  JDXstring zaverage;
  JDXfloatArr design;
  JDXfloatArr tcourse;
  JDXfloatArr sigcourse;
  JDXstring dumptcourse;
  JDXstring dumpzmap;

  FmriData* data;
  mutable farray overlay_map;
  mutable farray toberemoved;
  bool valid;

};





#endif


